/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class GroupedElementsRenderer
implements Accessible {
    protected SeparatorWithText mySeparatorComponent = this.createSeparator();
    @Deprecated
    protected JComponent myComponent;
    protected MyComponent myRendererComponent;
    private UpdateScaleHelper updateScaleHelper = new UpdateScaleHelper();
    protected ErrorLabel myTextLabel;

    protected abstract JComponent createItemComponent();

    public GroupedElementsRenderer() {
        this.myRendererComponent = new MyComponent();
        this.myComponent = this.createItemComponent();
        this.layout();
    }

    protected abstract void layout();

    public JComponent getItemComponent() {
        return this.myComponent;
    }

    protected SeparatorWithText createSeparator() {
        return new SeparatorWithText();
    }

    protected final JComponent configureComponent(@NlsContexts.ListItem String text, @NlsContexts.Tooltip String tooltip, Icon icon, Icon disabledIcon, boolean isSelected, boolean hasSeparatorAbove, @NlsContexts.Separator String separatorTextAbove, int preferredForcedWidth) {
        this.mySeparatorComponent.setVisible(hasSeparatorAbove);
        this.mySeparatorComponent.setCaption(separatorTextAbove);
        this.mySeparatorComponent.setMinimumWidth(preferredForcedWidth);
        this.myTextLabel.setText(text);
        this.myRendererComponent.setToolTipText(tooltip);
        this.setComponentIcon(icon, disabledIcon);
        this.updateSelection(isSelected, this.myComponent, this.myTextLabel);
        this.myRendererComponent.setPreferredWidth(preferredForcedWidth);
        this.updateScaleHelper.saveScaleAndUpdateUIIfChanged((JComponent)this.myRendererComponent);
        return this.myRendererComponent;
    }

    protected void updateSelection(boolean isSelected, JComponent component, JComponent innerComponent) {
        if (!ExperimentalUI.isNewUI()) {
            this.setSelected(component, isSelected);
        } else {
            UIUtil.setNotOpaqueRecursively((Component)component);
        }
        this.setSelected(innerComponent, isSelected);
    }

    protected void setComponentIcon(Icon icon, Icon disabledIcon) {
        this.myTextLabel.setIcon(icon);
        this.myTextLabel.setDisabledIcon(disabledIcon);
        this.myTextLabel.setIconTextGap(JBUI.CurrentTheme.ActionsList.elementIconGap());
    }

    protected final void setSelected(JComponent aComponent) {
        this.setSelected(aComponent, true);
    }

    protected final void setDeselected(JComponent aComponent) {
        this.setSelected(aComponent, false);
    }

    protected final void setSelected(JComponent aComponent, boolean selected2) {
        UIUtil.setBackgroundRecursively((Component)aComponent, (Color)(selected2 ? this.getSelectionBackground() : this.getBackground()));
        this.setForegroundSelected(aComponent, selected2);
    }

    protected final void setForegroundSelected(JComponent aComponent, boolean selected2) {
        aComponent.setForeground(selected2 ? this.getSelectionForeground() : this.getForeground());
    }

    protected void setSeparatorFont(Font font) {
        this.mySeparatorComponent.setFont(font);
    }

    protected abstract Color getSelectionBackground();

    protected abstract Color getSelectionForeground();

    protected abstract Color getBackground();

    protected abstract Color getForeground();

    protected Border getDefaultItemComponentBorder() {
        return GroupedElementsRenderer.getBorder();
    }

    private static Border getBorder() {
        return new EmptyBorder(JBUI.CurrentTheme.ActionsList.cellPadding());
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.myRendererComponent.getAccessibleContext();
    }

    @NlsSafe
    protected String getDelegateAccessibleName() {
        return this.myTextLabel != null ? this.myTextLabel.getAccessibleContext().getAccessibleName() : null;
    }

    @NlsSafe
    protected String getDelegateAccessibleDescription() {
        return this.myTextLabel != null ? this.myTextLabel.getAccessibleContext().getAccessibleDescription() : null;
    }

    public class MyComponent
    extends OpaquePanel
    implements UiInspectorContextProvider {
        private int myPrefWidth;
        @NotNull
        private final GroupedElementsRenderer renderer;

        public MyComponent() {
            super((LayoutManager)new BorderLayout(), GroupedElementsRenderer.this.getBackground());
            this.myPrefWidth = -1;
            this.renderer = GroupedElementsRenderer.this;
        }

        public void setPreferredWidth(int minWidth) {
            this.myPrefWidth = minWidth;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = this.myPrefWidth == -1 ? size.width : this.myPrefWidth;
            return size;
        }

        @ApiStatus.Internal
        @NotNull
        public SeparatorWithText getSeparator() {
            SeparatorWithText separatorWithText = GroupedElementsRenderer.this.mySeparatorComponent;
            if (separatorWithText == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            return separatorWithText;
        }

        @ApiStatus.Internal
        @NotNull
        public GroupedElementsRenderer getRenderer() {
            GroupedElementsRenderer groupedElementsRenderer = this.renderer;
            if (groupedElementsRenderer == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            return groupedElementsRenderer;
        }

        @Override
        public @NotNull java.util.List<PropertyBean> getUiInspectorContext() {
            ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
            result2.add(new PropertyBean("Renderer Delegate", this.renderer));
            result2.add(new PropertyBean("Renderer Delegate Class", UiInspectorUtil.getClassPresentation(this.renderer)));
            ArrayList<PropertyBean> arrayList = result2;
            if (arrayList == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new MyAccessibleContext();
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ui/GroupedElementsRenderer$MyComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiInspectorContext";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private final class MyAccessibleContext
        extends JPanel.AccessibleJPanel {
            private MyAccessibleContext() {
                super(MyComponent.this);
            }

            @Override
            public String getAccessibleName() {
                return GroupedElementsRenderer.this.getDelegateAccessibleName();
            }

            @Override
            public String getAccessibleDescription() {
                return GroupedElementsRenderer.this.getDelegateAccessibleDescription();
            }
        }
    }

    public static abstract class Tree
    extends GroupedElementsRenderer
    implements TreeCellRenderer {
        @Override
        protected void layout() {
            this.myRendererComponent.add((Component)this.mySeparatorComponent, "North");
            this.myRendererComponent.add((Component)this.myComponent, "West");
        }

        @Override
        protected Color getSelectionBackground() {
            return UIUtil.getTreeSelectionBackground((boolean)true);
        }

        @Override
        protected Color getSelectionForeground() {
            return UIUtil.getTreeSelectionForeground((boolean)true);
        }

        @Override
        protected Color getBackground() {
            return UIUtil.getTreeBackground();
        }

        @Override
        protected Color getForeground() {
            return UIUtil.getTreeForeground();
        }
    }

    public static abstract class List
    extends GroupedElementsRenderer {
        @Override
        protected void layout() {
            this.myRendererComponent.add((Component)this.mySeparatorComponent, "North");
            NonOpaquePanel centerComponent = new NonOpaquePanel(this.myComponent){

                @Override
                public Dimension getPreferredSize() {
                    return UIUtil.updateListRowHeight((Dimension)super.getPreferredSize());
                }
            };
            this.myRendererComponent.add((Component)centerComponent, "Center");
        }

        @Override
        protected final Color getSelectionBackground() {
            return UIUtil.getListSelectionBackground((boolean)true);
        }

        @Override
        protected final Color getSelectionForeground() {
            return NamedColorUtil.getListSelectionForeground((boolean)true);
        }

        @Override
        protected Color getBackground() {
            return UIUtil.getListBackground();
        }

        @Override
        protected Color getForeground() {
            return UIUtil.getListForeground();
        }
    }
}

