/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.progress;

import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.TtySink;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/agent/progress/DockerResponseItemTtyHandler;", "", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "<init>", "(Lcom/intellij/docker/agent/progress/TtySink;)V", "currentStreams", "", "", "", "progressFormat", "Lcom/intellij/docker/agent/progress/DockerProgressDetailsFormat;", "handleItem", "", "item", "Lcom/intellij/docker/agent/progress/DockerResponseItem;", "displayItem", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerResponseItemTtyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerResponseItemTtyHandler.kt\ncom/intellij/docker/agent/progress/DockerResponseItemTtyHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n383#2,7:102\n1#3:109\n*S KotlinDebug\n*F\n+ 1 DockerResponseItemTtyHandler.kt\ncom/intellij/docker/agent/progress/DockerResponseItemTtyHandler\n*L\n30#1:102,7\n*E\n"})
public final class DockerResponseItemTtyHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TtySink ttySink;
    @NotNull
    private final Map<String, Integer> currentStreams;
    @NotNull
    private final DockerProgressDetailsFormat progressFormat;
    @NotNull
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public DockerResponseItemTtyHandler(@NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.ttySink = ttySink;
        this.currentStreams = new LinkedHashMap();
        this.progressFormat = new DockerProgressDetailsFormat(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleItem(@NotNull DockerResponseItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int jump = 0;
        String id2 = item.getId();
        if (id2 == null || item.getProgress() == null && item.getProgressMessage() == null) {
            this.currentStreams.clear();
        } else {
            Object object;
            void $this$getOrPut$iv;
            Map<String, Integer> map2 = this.currentStreams;
            String key$iv = id2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                this.ttySink.invoke("\r\n");
                Integer answer$iv = this.currentStreams.size();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            int itemIdx = ((Number)object).intValue();
            jump = this.currentStreams.size() - itemIdx;
            this.ttySink.ttyCursorUp(jump);
        }
        this.displayItem(item);
        if (id2 != null) {
            this.ttySink.ttyCursorDown(jump);
        }
    }

    private final void displayItem(DockerResponseItem item) {
        block22: {
            String endLine;
            block24: {
                Object object;
                String safeStatus;
                block28: {
                    DockerResponseItem.ErrorDetail error;
                    block27: {
                        String string;
                        block26: {
                            String string2;
                            block25: {
                                String string3;
                                block23: {
                                    Object it;
                                    CharSequence it2;
                                    block21: {
                                        Object object2;
                                        block20: {
                                            block19: {
                                                DockerResponseItem.ErrorDetail errorDetail = item.getError();
                                                boolean bl = errorDetail != null ? 401 == errorDetail.getCode() : false;
                                                if (bl) {
                                                    this.ttySink.invoke(DockerAgentBundle.Companion.message("DockerResponseItemTtyHandler.authentication.is.required", new Object[0]));
                                                    return;
                                                }
                                                endLine = "";
                                                String string4 = item.getStream();
                                                if (string4 == null) {
                                                    string4 = "";
                                                }
                                                if (((CharSequence)string4).length() == 0 && item.getProgress() != null) {
                                                    this.ttySink.ttyClearLine();
                                                    endLine = "\r";
                                                }
                                                if (item.getTime() != 0L) {
                                                    String time = TIME_FORMAT.format(new Date(item.getTime()));
                                                    this.ttySink.invoke(time + " ");
                                                }
                                                String string5 = item.getId();
                                                if (string5 != null) {
                                                    it2 = string5;
                                                    boolean bl2 = false;
                                                    this.ttySink.invoke(it2 + ": ");
                                                }
                                                String string6 = item.getFrom();
                                                if (string6 != null) {
                                                    it2 = string6;
                                                    boolean bl3 = false;
                                                    Object[] objectArray = new Object[]{it2};
                                                    this.ttySink.invoke(DockerAgentBundle.Companion.message("DockerResponseItemTtyHandler.from", objectArray));
                                                }
                                                if ((object2 = item.getProgress()) == null) break block19;
                                                it = object2;
                                                boolean bl4 = false;
                                                String string7 = this.progressFormat.toTtyString((DockerResponseItem.ProgressDetail)it);
                                                object2 = string7;
                                                if (string7 != null) break block20;
                                            }
                                            object2 = item.getProgressMessage();
                                        }
                                        Object progress = object2;
                                        if (progress == null) break block21;
                                        this.ttySink.invoke(item.getStatus() + " " + (String)progress + endLine);
                                        break block22;
                                    }
                                    if (item.getStream() == null) break block23;
                                    String string8 = item.getStream();
                                    Intrinsics.checkNotNull((Object)string8);
                                    it2 = string8;
                                    Regex bl3 = new Regex("(?<=[^\r])\n");
                                    it = "\r\n";
                                    String it3 = bl3.replace(it2, (String)it);
                                    boolean bl = false;
                                    Object fixedStream = StringsKt.startsWith$default((CharSequence)it3, (char)'\n', (boolean)false, (int)2, null) ? "\r" + it3 : it3;
                                    this.ttySink.invoke((String)fixedStream + endLine);
                                    break block22;
                                }
                                if (item.getError() == null) break block24;
                                DockerResponseItem.ErrorDetail errorDetail = item.getError();
                                Intrinsics.checkNotNull((Object)errorDetail);
                                error = errorDetail;
                                string2 = item.getStatus();
                                if (string2 == null) break block25;
                                String it = string3 = string2;
                                boolean bl = false;
                                string2 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                                if (string2 != null) break block26;
                            }
                            string2 = safeStatus = "Error response from daemon:";
                        }
                        if ((object = error.getMessage()) == null) break block27;
                        String it = string = object;
                        boolean bl = false;
                        object = !StringsKt.isBlank((CharSequence)it) ? string : null;
                        if (object != null) break block28;
                    }
                    object = "Error code " + error.getCode();
                }
                Object errorMessage = object;
                this.ttySink.invoke(safeStatus + " " + (String)errorMessage + "\r\n");
                break block22;
            }
            endLine = "\r";
            String string = item.getStatus();
            if (string == null) {
                string = "";
            }
            this.ttySink.invoke(string + endLine + "\n");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/progress/DockerResponseItemTtyHandler$Companion;", "", "<init>", "()V", "TIME_FORMAT", "Ljava/text/SimpleDateFormat;", "getTIME_FORMAT", "()Ljava/text/SimpleDateFormat;", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleDateFormat getTIME_FORMAT() {
            return TIME_FORMAT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

