/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.matching.MatchingMode;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CamelHumpMatcher
extends PrefixMatcher {
    private final MinusculeMatcher myMatcher;
    private final MinusculeMatcher myCaseInsensitiveMatcher;
    private final boolean myCaseSensitive;
    private static boolean ourForceStartMatching;
    private final boolean myTypoTolerant;

    public CamelHumpMatcher(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(0);
        }
        this(prefix, true);
    }

    public CamelHumpMatcher(String prefix, boolean caseSensitive) {
        this(prefix, caseSensitive, false);
    }

    @ApiStatus.Internal
    public CamelHumpMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        super(prefix);
        this.myCaseSensitive = caseSensitive;
        this.myTypoTolerant = typoTolerant;
        this.myMatcher = this.createMatcher(this.myCaseSensitive);
        this.myCaseInsensitiveMatcher = this.createMatcher(false);
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isStartMatch(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(1);
        }
        return this.myMatcher.isStartMatch(name);
    }

    public boolean isStartMatch(@NotNull LookupElement element) {
        if (element == null) {
            CamelHumpMatcher.$$$reportNull$$$0(2);
        }
        for (String s : CompletionUtil.iterateLookupStrings(element)) {
            List ranges = this.myCaseInsensitiveMatcher.match(s);
            if (ranges == null || !ranges.isEmpty() && CamelHumpMatcher.skipUnderscores(s) < ((TextRange)ranges.getFirst()).getStartOffset()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isTypoTolerant() {
        return this.myTypoTolerant;
    }

    private static int skipUnderscores(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(3);
        }
        return CharArrayUtil.shiftForward((CharSequence)name, (int)0, (String)"_");
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(4);
        }
        if (name.startsWith("_") && CodeInsightSettings.getInstance().getCompletionCaseSensitive() == 3 && this.firstLetterCaseDiffers(name)) {
            return false;
        }
        return this.myMatcher.matches(name);
    }

    private boolean firstLetterCaseDiffers(String name) {
        int nameFirst = CamelHumpMatcher.skipUnderscores(name);
        int prefixFirst = CamelHumpMatcher.skipUnderscores(this.myPrefix);
        return nameFirst < name.length() && prefixFirst < this.myPrefix.length() && CamelHumpMatcher.caseDiffers(name.charAt(nameFirst), this.myPrefix.charAt(prefixFirst));
    }

    private static boolean caseDiffers(char c1, char c2) {
        return Character.isLowerCase(c1) != Character.isLowerCase(c2) || Character.isUpperCase(c1) != Character.isUpperCase(c2);
    }

    public boolean prefixMatches(@NotNull LookupElement element) {
        if (element == null) {
            CamelHumpMatcher.$$$reportNull$$$0(5);
        }
        return this.prefixMatchersInternal(element, !element.isCaseSensitive());
    }

    private boolean prefixMatchersInternal(LookupElement element, boolean itemCaseInsensitive) {
        for (String name : element.getAllLookupStrings()) {
            if (itemCaseInsensitive && StringUtil.startsWithIgnoreCase((String)name, (String)this.myPrefix) || this.prefixMatches(name)) {
                return true;
            }
            if (!itemCaseInsensitive || 1 == CodeInsightSettings.getInstance().getCompletionCaseSensitive() || !this.myCaseInsensitiveMatcher.matches(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(6);
        }
        if (prefix.equals(this.myPrefix)) {
            CamelHumpMatcher camelHumpMatcher = this;
            if (camelHumpMatcher == null) {
                CamelHumpMatcher.$$$reportNull$$$0(7);
            }
            return camelHumpMatcher;
        }
        return new CamelHumpMatcher(prefix, this.myCaseSensitive, this.myTypoTolerant);
    }

    private MinusculeMatcher createMatcher(boolean caseSensitive) {
        String prefix = CamelHumpMatcher.applyMiddleMatching(this.myPrefix);
        NameUtil.MatcherBuilder builder = NameUtil.buildMatcher((String)prefix);
        if (caseSensitive) {
            int setting = CodeInsightSettings.getInstance().getCompletionCaseSensitive();
            if (setting == 3) {
                builder = builder.withMatchingMode(MatchingMode.FIRST_LETTER);
            } else if (setting == 1) {
                builder = builder.withMatchingMode(MatchingMode.MATCH_CASE);
            }
        }
        if (this.myTypoTolerant) {
            builder = builder.typoTolerant();
        }
        return builder.build();
    }

    public static String applyMiddleMatching(String prefix) {
        if (Registry.is((String)"ide.completion.middle.matching") && !prefix.isEmpty() && !ourForceStartMatching) {
            return "*" + StringUtil.replace((String)prefix, (String)".", (String)". ").trim();
        }
        return prefix;
    }

    public String toString() {
        return this.myPrefix;
    }

    @Deprecated
    @TestOnly
    public static void forceStartMatching(Disposable parent) {
        ourForceStartMatching = true;
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                ourForceStartMatching = false;
            }
        });
    }

    public int matchingDegree(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(8);
        }
        return this.matchingDegree(name, this.matchingFragments(name));
    }

    @Nullable
    public List<TextRange> matchingFragments(String string) {
        return this.myMatcher.match(string);
    }

    public int matchingDegree(String string, @Nullable List<? extends TextRange> fragments) {
        int matchStart;
        List ciRanges;
        int underscoreEnd = CamelHumpMatcher.skipUnderscores(string);
        if (underscoreEnd > 0 && (ciRanges = this.myCaseInsensitiveMatcher.match(string)) != null && !ciRanges.isEmpty() && (matchStart = ((TextRange)ciRanges.getFirst()).getStartOffset()) > 0 && matchStart <= underscoreEnd) {
            return this.myCaseInsensitiveMatcher.matchingDegree(string.substring(matchStart), true) - 1;
        }
        return this.myMatcher.matchingDegree(string, true, fragments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStartMatch";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipUnderscores";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

