/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CloseAllEditorsButActiveAction
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            CloseAllEditorsButActiveAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project2);
        EditorWindow window = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
        if (window != null) {
            window.closeAllExcept((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
            return;
        }
        VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
        for (VirtualFile sibling : fileEditorManager.getSiblings(selectedFile)) {
            if (Comparing.equal((Object)selectedFile, (Object)sibling)) continue;
            fileEditorManager.closeFile(sibling);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CloseAllEditorsButActiveAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation2.setEnabled(false);
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project2);
        EditorWindow window = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        if (window != null) {
            presentation2.setEnabled(window.getFileList().size() > 1);
            return;
        }
        if (fileEditorManager.getSelectedFiles().length == 0) {
            presentation2.setEnabled(false);
            return;
        }
        VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
        presentation2.setEnabled(!ApplicationManager.getApplication().isUnitTestMode() && fileEditorManager.getSiblings(selectedFile).size() > 1);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CloseAllEditorsButActiveAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CloseAllEditorsButActiveAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CloseAllEditorsButActiveAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

