/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.impl.Origin;
import com.intellij.ide.impl.ProjectOriginInfoProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0007\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"getProjectOriginUrl", "", "projectDir", "Ljava/nio/file/Path;", "KNOWN_HOSTINGS", "", "getOriginFromUrl", "Lcom/intellij/ide/impl/Origin;", "url", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
public final class ProjectOriginKt {
    @NotNull
    private static final List<String> KNOWN_HOSTINGS;
    @NotNull
    private static final Logger LOG;

    @NlsSafe
    @Nullable
    public static final String getProjectOriginUrl(@Nullable Path projectDir) {
        if (projectDir == null) {
            return null;
        }
        ExtensionPointName epName = ExtensionPointName.Companion.create("com.intellij.projectOriginInfoProvider");
        for (ProjectOriginInfoProvider extension : (ProjectOriginInfoProvider[])epName.getExtensions()) {
            String url = extension.getOriginUrl(projectDir);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Nullable
    public static final Origin getOriginFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Object urlWithScheme = URLUtil.containsScheme((String)url) ? url : "ssh://" + url;
            URI uri = new URI((String)urlWithScheme);
            String host = uri.getHost();
            if (host == null && Intrinsics.areEqual((Object)uri.getScheme(), (Object)"ssh") && uri.getAuthority() != null) {
                String string = uri.getAuthority();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthority(...)");
                String[] stringArray = new String[]{"@"};
                List at = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String hostAndOrg = at.size() > 1 ? (String)at.get(1) : (String)at.get(0);
                String[] stringArray2 = new String[]{":"};
                List comma = StringsKt.split$default((CharSequence)hostAndOrg, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                host = (String)comma.get(0);
                if (comma.size() > 1) {
                    String org = (String)comma.get(1);
                    return new Origin(uri.getScheme(), host + "/" + org);
                }
            }
            if (host == null) {
                return null;
            }
            if (KNOWN_HOSTINGS.contains(host)) {
                String string;
                String path = uri.getPath();
                Intrinsics.checkNotNull((Object)path);
                int secondSlash = StringsKt.indexOf$default((CharSequence)path, (String)"/", (int)1, (boolean)false, (int)4, null);
                if (secondSlash >= 0) {
                    String string2 = path.substring(0, secondSlash);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = path;
                }
                String organization = string;
                return new Origin(uri.getScheme(), uri.getHost() + organization);
            }
            String string = uri.getScheme();
            String string3 = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHost(...)");
            return new Origin(string, string3);
        }
        catch (Exception e) {
            LOG.warn("Couldn't parse URL " + url, (Throwable)e);
            return null;
        }
    }

    static {
        Object[] objectArray = new String[]{"git.jetbrains.space", "github.com", "bitbucket.org", "gitlab.com"};
        KNOWN_HOSTINGS = CollectionsKt.listOf((Object[])objectArray);
        Logger logger2 = Logger.getInstance((String)"com.intellij.ide.impl.TrustedHosts");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }
}

