/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.certificates;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0019\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0011\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/plugins/certificates/PluginCertificateStore;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MANAGED_TRUSTSTORE_PATH", "", "kotlin.jvm.PlatformType", "DEFAULT_PATH", "DEFAULT_PASSWORD", "customTrustManager", "Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "getCustomTrustManager", "()Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "customTrustManager$delegate", "Lkotlin/Lazy;", "managedTrustedCertificates", "", "Ljava/security/cert/X509Certificate;", "getManagedTrustedCertificates", "()Ljava/util/List;", "managedTrustedCertificates$delegate", "loadCertificates", "storePath", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPluginCertificateStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginCertificateStore.kt\ncom/intellij/ide/plugins/certificates/PluginCertificateStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1642#2,10:47\n1915#2:57\n1916#2:59\n1652#2:60\n1#3:58\n*S KotlinDebug\n*F\n+ 1 PluginCertificateStore.kt\ncom/intellij/ide/plugins/certificates/PluginCertificateStore\n*L\n38#1:47,10\n38#1:57\n38#1:59\n38#1:60\n38#1:58\n*E\n"})
public final class PluginCertificateStore {
    @NotNull
    public static final PluginCertificateStore INSTANCE = new PluginCertificateStore();
    @NotNull
    private static final Logger LOG;
    private static final String MANAGED_TRUSTSTORE_PATH;
    @NotNull
    private static final String DEFAULT_PATH;
    @NotNull
    private static final String DEFAULT_PASSWORD = "changeit";
    @NotNull
    private static final Lazy customTrustManager$delegate;
    @NotNull
    private static final Lazy managedTrustedCertificates$delegate;

    private PluginCertificateStore() {
    }

    @NotNull
    public final ConfirmingTrustManager.MutableTrustManager getCustomTrustManager() {
        Lazy lazy = customTrustManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ConfirmingTrustManager.MutableTrustManager)object;
    }

    @NotNull
    public final List<X509Certificate> getManagedTrustedCertificates() {
        Lazy lazy = managedTrustedCertificates$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<X509Certificate> loadCertificates(String storePath) {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        Path path = Paths.get(storePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path keystorePath = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(keystorePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(keystorePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                char[] cArray = DEFAULT_PASSWORD.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                keystore.load(inputStream, cArray);
                Enumeration<String> enumeration = keystore.aliases();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"aliases(...)");
                ArrayList<String> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                Iterable iterable = arrayList;
                boolean $i$f$mapNotNull = false;
                void var6_7 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    X509Certificate it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    Certificate certificate = keystore.getCertificate(it);
                    if ((certificate instanceof X509Certificate ? (X509Certificate)certificate : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            catch (Exception e) {
                LOG.warn("Failed to load managed plugin truststore", (Throwable)e);
            }
        }
        return CollectionsKt.emptyList();
    }

    private static final ConfirmingTrustManager.MutableTrustManager customTrustManager_delegate$lambda$0() {
        return ConfirmingTrustManager.createForStorage((String)DEFAULT_PATH, (String)DEFAULT_PASSWORD).getCustomManager();
    }

    private static final List managedTrustedCertificates_delegate$lambda$0() {
        List<X509Certificate> list2;
        String string = MANAGED_TRUSTSTORE_PATH;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANAGED_TRUSTSTORE_PATH");
        if (!StringsKt.isBlank((CharSequence)string)) {
            String string2 = MANAGED_TRUSTSTORE_PATH;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MANAGED_TRUSTSTORE_PATH");
            list2 = INSTANCE.loadCertificates(string2);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    static {
        Logger logger2 = Logger.getInstance(PluginCertificateStore.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        MANAGED_TRUSTSTORE_PATH = System.getProperty("intellij.plugin.truststore", "");
        Path path = PathManager.getOriginalConfigDir().resolve("ssl").resolve("plugins-certs");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        DEFAULT_PATH = ((Object)path).toString();
        customTrustManager$delegate = LazyKt.lazy(PluginCertificateStore::customTrustManager_delegate$lambda$0);
        managedTrustedCertificates$delegate = LazyKt.lazy(PluginCertificateStore::managedTrustedCertificates_delegate$lambda$0);
    }
}

