/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.impl.DataValidators;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.util.containers.ConcurrentBitSet;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u000bR6\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/actionSystem/impl/CachedData;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ide/impl/DataValidators$SourceWrapper;", "isDisplayable", "", "uiSnapshot", "Lkotlinx/collections/immutable/PersistentMap;", "", "", "<init>", "(ZLkotlinx/collections/immutable/PersistentMap;)V", "()Z", "value", "getUiSnapshot", "()Lkotlinx/collections/immutable/PersistentMap;", "uiComputed", "Ljava/util/concurrent/ConcurrentHashMap;", "getUiComputed", "()Ljava/util/concurrent/ConcurrentHashMap;", "bgtComputed", "getBgtComputed", "nullsByRules", "Lcom/intellij/util/containers/ConcurrentBitSet;", "Lorg/jetbrains/annotations/NotNull;", "getNullsByRules", "()Lcom/intellij/util/containers/ConcurrentBitSet;", "uiData", "dataId", "clear", "", "getData", "unwrapSource", "intellij.platform.ide.impl"})
final class CachedData
implements DataProvider,
DataValidators.SourceWrapper {
    private final boolean isDisplayable;
    @NotNull
    private volatile PersistentMap<String, ? extends Object> uiSnapshot;
    @NotNull
    private final ConcurrentHashMap<String, Object> uiComputed;
    @NotNull
    private final ConcurrentHashMap<String, Object> bgtComputed;
    @NotNull
    private final ConcurrentBitSet nullsByRules;

    public CachedData(boolean isDisplayable, @NotNull PersistentMap<String, ? extends Object> uiSnapshot) {
        Intrinsics.checkNotNullParameter(uiSnapshot, (String)"uiSnapshot");
        this.isDisplayable = isDisplayable;
        this.uiSnapshot = uiSnapshot;
        this.uiComputed = new ConcurrentHashMap();
        this.bgtComputed = new ConcurrentHashMap();
        ConcurrentBitSet concurrentBitSet = ConcurrentBitSet.create();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentBitSet, (String)"create(...)");
        this.nullsByRules = concurrentBitSet;
    }

    public final boolean isDisplayable() {
        return this.isDisplayable;
    }

    @NotNull
    public final PersistentMap<String, Object> getUiSnapshot() {
        return this.uiSnapshot;
    }

    @NotNull
    public final ConcurrentHashMap<String, Object> getUiComputed() {
        return this.uiComputed;
    }

    @NotNull
    public final ConcurrentHashMap<String, Object> getBgtComputed() {
        return this.bgtComputed;
    }

    @NotNull
    public final ConcurrentBitSet getNullsByRules() {
        return this.nullsByRules;
    }

    @Nullable
    public final Object uiData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            object = this.uiComputed.get(dataId);
            if (object == null) {
                object = this.uiSnapshot.get((Object)dataId);
            }
        } else {
            object = this.uiSnapshot.get((Object)dataId);
            if (object == null) {
                object = this.uiComputed.get(dataId);
            }
        }
        return object;
    }

    public final void clear() {
        this.uiSnapshot = ExtensionsKt.persistentHashMapOf();
        this.uiComputed.clear();
        this.bgtComputed.clear();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return this.uiData(dataId);
    }

    @NotNull
    public Object unwrapSource() {
        return MapsKt.emptyMap();
    }
}

