/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

final class EditorTablessBorder
extends SideBorder {
    private final Project myProject;
    private final JPanel myHeaderPanel;

    EditorTablessBorder(Project project2, JPanel headerPanel) {
        super(JBColor.border(), 15);
        this.myProject = project2;
        this.myHeaderPanel = headerPanel;
    }

    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        if (c == null) {
            EditorTablessBorder.$$$reportNull$$$0(0);
        }
        if (g == null) {
            EditorTablessBorder.$$$reportNull$$$0(1);
        }
        if (c instanceof JComponent) {
            Insets insets = ((JComponent)c).getInsets();
            if (insets.left > 0) {
                super.paintBorder(c, g, x, y, width, height);
            } else {
                g.setColor(UIUtil.getPanelBackground());
                g.fillRect(x, y, width, 1);
                g.setColor(Gray._50.withAlpha(90));
                g.fillRect(x, y, width, 1);
            }
        }
    }

    @NotNull
    public Insets getBorderInsets(Component c) {
        boolean paintTop;
        Container splitters2 = SwingUtilities.getAncestorOfClass(EditorsSplitters.class, c);
        boolean thereIsSomethingAbove = !SystemInfo.isMac || UISettings.getInstance().getShowMainToolbar() || UISettings.getInstance().getShowNavigationBar() || this.toolWindowIsNotEmpty();
        Component header = this.myHeaderPanel == null ? null : (Component)ArrayUtil.getFirstElement((Object[])this.myHeaderPanel.getComponents());
        boolean bl = paintTop = thereIsSomethingAbove && header == null && UISettings.getInstance().getEditorTabPlacement() != 1;
        Insets insets = splitters2 == null ? super.getBorderInsets(c) : JBUI.insetsTop((int)(paintTop ? 1 : 0));
        if (insets == null) {
            EditorTablessBorder.$$$reportNull$$$0(2);
        }
        return insets;
    }

    private boolean toolWindowIsNotEmpty() {
        if (this.myProject == null) {
            return false;
        }
        return !ToolWindowManagerEx.getInstanceEx(this.myProject).getIdsOn(ToolWindowAnchor.TOP).isEmpty();
    }

    public boolean isBorderOpaque() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorTablessBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorTablessBorder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderInsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintBorder";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

