/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileRenderer {
    private static final Color GRAYED = SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
    private static final Color HIDDEN = SimpleTextAttributes.DARK_TEXT.getFgColor();

    public <T> ColoredListCellRenderer<T> forList() {
        return new ColoredListCellRenderer<T>(){

            protected void customizeCellRenderer(@NotNull JList<? extends T> list2, T value, int index, boolean selected, boolean focused) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileRenderer.customize((SimpleColoredComponent)this, value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileChooser/tree/FileRenderer$1", "customizeCellRenderer"));
            }
        };
    }

    public ColoredTableCellRenderer forTable() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value, boolean selected, boolean focused, int row2, int column) {
                if (table2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileRenderer.customize((SimpleColoredComponent)this, value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/fileChooser/tree/FileRenderer$2", "customizeCellRenderer"));
            }
        };
    }

    @Contract(value=" -> new")
    @NotNull
    public ColoredTreeCellRenderer forTree() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean focused) {
                if (tree2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileRenderer.customize((SimpleColoredComponent)this, value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/fileChooser/tree/FileRenderer$3", "customizeCellRenderer"));
            }
        };
    }

    private static void customize(SimpleColoredComponent renderer2, Object value) {
        int style = 0;
        Color color = null;
        Icon icon2 = null;
        String name2 = null;
        String comment2 = null;
        boolean hidden = false;
        boolean valid = true;
        if (value instanceof FileNode) {
            FileNode node = (FileNode)value;
            icon2 = node.getIcon();
            name2 = node.getName();
            comment2 = node.getComment();
            hidden = node.isHidden();
            valid = node.isValid();
        } else if (value instanceof VirtualFile) {
            VirtualFile file2 = (VirtualFile)value;
            name2 = file2.getName();
            hidden = FileElement.isFileHidden((VirtualFile)file2);
            valid = file2.isValid();
        } else if (value != null) {
            name2 = value.toString();
            color = GRAYED;
        }
        if (!valid) {
            style |= 4;
        }
        if (hidden) {
            color = HIDDEN;
        }
        renderer2.setIcon(!hidden || icon2 == null ? icon2 : IconLoader.getTransparentIcon((Icon)icon2));
        SimpleTextAttributes attributes = new SimpleTextAttributes(style, color);
        if (name2 != null) {
            renderer2.append(name2, attributes);
        }
        if (comment2 != null) {
            renderer2.append(comment2, attributes);
        }
    }
}

