/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapImplKt;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b(\u001a\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0002\u001a$\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u001a\"\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u00012\b\b\u0001\u0010B\u001a\u00020\u00012\u0006\u0010C\u001a\u00020\u0019H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001e\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001f\u0010 \"\u0014\u0010!\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010 \"\u0014\u0010#\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b$\u0010 \"\u0014\u0010%\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b&\u0010 \"\u0014\u0010'\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b(\u0010 \"\u0014\u0010)\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010 \"\u0014\u0010+\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b,\u0010 \"\u0014\u0010-\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b.\u0010 \"\u0014\u0010/\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b0\u0010 \"\u0014\u00101\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b2\u0010 \"\u0014\u00103\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b4\u0010 \"\u000e\u00105\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u00106\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b7\u0010 \"\u0014\u00108\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b9\u0010 \"\u0014\u0010:\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b;\u0010 \"\u0014\u0010<\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b=\u0010 \"\u0014\u0010>\u001a\u00020\u0001X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b?\u0010 \u00a8\u0006D"}, d2={"KEY_MAP", "", "KEYBOARD_SHORTCUT", "KEYBOARD_GESTURE_SHORTCUT", "KEYBOARD_GESTURE_KEY", "KEYBOARD_GESTURE_MODIFIER", "KEYSTROKE_ATTRIBUTE", "FIRST_KEYSTROKE_ATTRIBUTE", "SECOND_KEYSTROKE_ATTRIBUTE", "ACTION", "VERSION_ATTRIBUTE", "PARENT_ATTRIBUTE", "NAME_ATTRIBUTE", "ID_ATTRIBUTE", "MOUSE_SHORTCUT", "KeymapImpl", "Lcom/intellij/openapi/keymap/impl/KeymapImpl;", "name", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "sortInRegistrationOrder", "", "ids", "", "areShortcutsEqual", "", "shortcuts1", "", "Lcom/intellij/openapi/actionSystem/Shortcut;", "shortcuts2", "macOSKeymap", "getMacOSKeymap$annotations", "()V", "gnomeKeymap", "getGnomeKeymap$annotations", "kdeKeymap", "getKdeKeymap$annotations", "xwinKeymap", "getXwinKeymap$annotations", "eclipseKeymap", "getEclipseKeymap$annotations", "emacsKeymap", "getEmacsKeymap$annotations", "netbeansKeymap", "getNetbeansKeymap$annotations", "qtcreatorKeymap", "getQtcreatorKeymap$annotations", "resharperKeymap", "getResharperKeymap$annotations", "sublimeKeymap", "getSublimeKeymap$annotations", "visualStudioKeymap", "getVisualStudioKeymap$annotations", "visualStudio2022Keymap", "xcodeKeymap", "getXcodeKeymap$annotations", "visualAssistKeymap", "getVisualAssistKeymap$annotations", "riderKeymap", "getRiderKeymap$annotations", "vsCodeKeymap", "getVsCodeKeymap$annotations", "vsForMacKeymap", "getVsForMacKeymap$annotations", "notifyAboutMissingKeymap", "keymapName", "message", "isParent", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class KeymapImplKt {
    @NotNull
    private static final String KEY_MAP = "keymap";
    @NotNull
    private static final String KEYBOARD_SHORTCUT = "keyboard-shortcut";
    @NotNull
    private static final String KEYBOARD_GESTURE_SHORTCUT = "keyboard-gesture-shortcut";
    @NotNull
    private static final String KEYBOARD_GESTURE_KEY = "keystroke";
    @NotNull
    private static final String KEYBOARD_GESTURE_MODIFIER = "modifier";
    @NotNull
    private static final String KEYSTROKE_ATTRIBUTE = "keystroke";
    @NotNull
    private static final String FIRST_KEYSTROKE_ATTRIBUTE = "first-keystroke";
    @NotNull
    private static final String SECOND_KEYSTROKE_ATTRIBUTE = "second-keystroke";
    @NotNull
    private static final String ACTION = "action";
    @NotNull
    private static final String VERSION_ATTRIBUTE = "version";
    @NotNull
    private static final String PARENT_ATTRIBUTE = "parent";
    @NotNull
    private static final String NAME_ATTRIBUTE = "name";
    @NotNull
    private static final String ID_ATTRIBUTE = "id";
    @NotNull
    private static final String MOUSE_SHORTCUT = "mouse-shortcut";
    @NotNull
    private static final String macOSKeymap = "com.intellij.plugins.macoskeymap";
    @NotNull
    private static final String gnomeKeymap = "com.intellij.plugins.gnomekeymap";
    @NotNull
    private static final String kdeKeymap = "com.intellij.plugins.kdekeymap";
    @NotNull
    private static final String xwinKeymap = "com.intellij.plugins.xwinkeymap";
    @NotNull
    private static final String eclipseKeymap = "com.intellij.plugins.eclipsekeymap";
    @NotNull
    private static final String emacsKeymap = "com.intellij.plugins.emacskeymap";
    @NotNull
    private static final String netbeansKeymap = "com.intellij.plugins.netbeanskeymap";
    @NotNull
    private static final String qtcreatorKeymap = "com.intellij.plugins.qtcreatorkeymap";
    @NotNull
    private static final String resharperKeymap = "com.intellij.plugins.resharperkeymap";
    @NotNull
    private static final String sublimeKeymap = "com.intellij.plugins.sublimetextkeymap";
    @NotNull
    private static final String visualStudioKeymap = "com.intellij.plugins.visualstudiokeymap";
    @NotNull
    private static final String visualStudio2022Keymap = "com.intellij.plugins.visualstudio2022keymap";
    @NotNull
    private static final String xcodeKeymap = "com.intellij.plugins.xcodekeymap";
    @NotNull
    private static final String visualAssistKeymap = "com.intellij.plugins.visualassistkeymap";
    @NotNull
    private static final String riderKeymap = "com.intellij.plugins.riderkeymap";
    @NotNull
    private static final String vsCodeKeymap = "com.intellij.plugins.vscodekeymap";
    @NotNull
    private static final String vsForMacKeymap = "com.intellij.plugins.vsformackeymap";

    @NotNull
    public static final KeymapImpl KeymapImpl(@NotNull String name2, @NotNull SchemeDataHolder<? super KeymapImpl> dataHolder) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)NAME_ATTRIBUTE);
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        KeymapImpl result2 = new KeymapImpl(dataHolder);
        result2.setName(name2);
        result2.schemeState = SchemeState.UNCHANGED;
        return result2;
    }

    private static final void sortInRegistrationOrder(List<String> ids) {
        CollectionsKt.sortWith(ids, (Comparator)ActionManagerEx.Companion.getInstanceEx().getRegistrationOrderComparator());
    }

    private static final boolean areShortcutsEqual(List<? extends Shortcut> shortcuts1, List<? extends Shortcut> shortcuts2) {
        if (shortcuts1.size() != shortcuts2.size()) {
            return false;
        }
        for (Shortcut shortcut : shortcuts1) {
            if (shortcuts2.contains(shortcut)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void getMacOSKeymap$annotations() {
    }

    private static /* synthetic */ void getGnomeKeymap$annotations() {
    }

    private static /* synthetic */ void getKdeKeymap$annotations() {
    }

    private static /* synthetic */ void getXwinKeymap$annotations() {
    }

    private static /* synthetic */ void getEclipseKeymap$annotations() {
    }

    private static /* synthetic */ void getEmacsKeymap$annotations() {
    }

    private static /* synthetic */ void getNetbeansKeymap$annotations() {
    }

    private static /* synthetic */ void getQtcreatorKeymap$annotations() {
    }

    private static /* synthetic */ void getResharperKeymap$annotations() {
    }

    private static /* synthetic */ void getSublimeKeymap$annotations() {
    }

    private static /* synthetic */ void getVisualStudioKeymap$annotations() {
    }

    private static /* synthetic */ void getXcodeKeymap$annotations() {
    }

    private static /* synthetic */ void getVisualAssistKeymap$annotations() {
    }

    private static /* synthetic */ void getRiderKeymap$annotations() {
    }

    private static /* synthetic */ void getVsCodeKeymap$annotations() {
    }

    private static /* synthetic */ void getVsForMacKeymap$annotations() {
    }

    public static final void notifyAboutMissingKeymap(@NotNull String keymapName, @NlsContexts.NotificationContent @NotNull String message, boolean isParent) {
        Intrinsics.checkNotNullParameter((Object)keymapName, (String)"keymapName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ProjectManagerListener(connection, keymapName, message, isParent){
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ String $keymapName;
            final /* synthetic */ String $message;
            final /* synthetic */ boolean $isParent;
            {
                this.$connection = $connection;
                this.$keymapName = $keymapName;
                this.$message = $message;
                this.$isParent = $isParent;
            }

            public void projectOpened(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                this.$connection.disconnect();
                ApplicationManager.getApplication().invokeLater(() -> notifyAboutMissingKeymap.1.projectOpened$lambda$0(this.$keymapName, this.$message, project2, this.$isParent), ModalityState.nonModal());
            }

            private static final void projectOpened$lambda$0(String $keymapName, String $message, Project $project, boolean $isParent) {
                AnAction anAction;
                String pluginId;
                switch ($keymapName) {
                    case "Mac OS X": 
                    case "Mac OS X 10.5+": {
                        String string = "com.intellij.plugins.macoskeymap";
                        break;
                    }
                    case "Default for GNOME": {
                        String string = "com.intellij.plugins.gnomekeymap";
                        break;
                    }
                    case "Default for KDE": {
                        String string = "com.intellij.plugins.kdekeymap";
                        break;
                    }
                    case "Default for XWin": {
                        String string = "com.intellij.plugins.xwinkeymap";
                        break;
                    }
                    case "Eclipse": 
                    case "Eclipse (Mac OS X)": {
                        String string = "com.intellij.plugins.eclipsekeymap";
                        break;
                    }
                    case "Emacs": {
                        String string = "com.intellij.plugins.emacskeymap";
                        break;
                    }
                    case "NetBeans 6.5": {
                        String string = "com.intellij.plugins.netbeanskeymap";
                        break;
                    }
                    case "QtCreator OSX": 
                    case "QtCreator": {
                        String string = "com.intellij.plugins.qtcreatorkeymap";
                        break;
                    }
                    case "ReSharper": 
                    case "ReSharper OSX": {
                        String string = "com.intellij.plugins.resharperkeymap";
                        break;
                    }
                    case "Sublime Text": 
                    case "Sublime Text (Mac OS X)": {
                        String string = "com.intellij.plugins.sublimetextkeymap";
                        break;
                    }
                    case "Visual Studio OSX": 
                    case "Visual Studio": {
                        String string = "com.intellij.plugins.visualstudiokeymap";
                        break;
                    }
                    case "Visual Studio 2022": {
                        String string = "com.intellij.plugins.visualstudio2022keymap";
                        break;
                    }
                    case "Visual Assist": 
                    case "Visual Assist OSX": {
                        String string = "com.intellij.plugins.visualassistkeymap";
                        break;
                    }
                    case "Xcode": {
                        String string = "com.intellij.plugins.xcodekeymap";
                        break;
                    }
                    case "Visual Studio for Mac": {
                        String string = "com.intellij.plugins.vsformackeymap";
                        break;
                    }
                    case "Rider OSX": 
                    case "Rider": {
                        String string = "com.intellij.plugins.riderkeymap";
                        break;
                    }
                    case "VSCode": 
                    case "VSCode OSX": {
                        String string = "com.intellij.plugins.vscodekeymap";
                        break;
                    }
                    default: {
                        String string = pluginId = null;
                    }
                }
                if (pluginId == null) {
                    var7_6 = new Object[]{$keymapName};
                    var6_7 = IdeBundle.message((String)"action.text.search.for.keymap", (Object[])var7_6);
                    anAction = (AnAction)new NotificationAction(var6_7){

                        public void actionPerformed(AnActionEvent e, Notification notification2) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                            ShowSettingsUtil.getInstance().showSettingsDialog(e.getProject(), PluginManagerConfigurable.class);
                        }
                    };
                } else {
                    var7_6 = new Object[]{$keymapName};
                    var6_7 = IdeBundle.message((String)"action.text.install.keymap", (Object[])var7_6);
                    anAction = (AnAction)new NotificationAction(pluginId, $project, $keymapName, $isParent, var6_7){
                        final /* synthetic */ String $pluginId;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ String $keymapName;
                        final /* synthetic */ boolean $isParent;
                        {
                            this.$pluginId = $pluginId;
                            this.$project = $project;
                            this.$keymapName = $keymapName;
                            this.$isParent = $isParent;
                            super($super_call_param$1);
                        }

                        public void actionPerformed(AnActionEvent e, Notification notification2) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                            MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
                            Topic topic = KeymapManagerListener.TOPIC;
                            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                            connect.subscribe(topic, (Object)new KeymapManagerListener(this.$keymapName, connect, this.$isParent, e){
                                final /* synthetic */ String $keymapName;
                                final /* synthetic */ MessageBusConnection $connect;
                                final /* synthetic */ boolean $isParent;
                                final /* synthetic */ AnActionEvent $e;
                                {
                                    this.$keymapName = $keymapName;
                                    this.$connect = $connect;
                                    this.$isParent = $isParent;
                                    this.$e = $e;
                                }

                                public void keymapAdded(Keymap keymap2) {
                                    Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
                                    ApplicationManager.getApplication().invokeLater(() -> notifyAboutMissingKeymap.projectOpened.1.action.actionPerformed.1.keymapAdded$lambda$0(keymap2, this.$keymapName, this.$connect, this.$isParent, this.$e));
                                }

                                private static final void keymapAdded$lambda$0(Keymap $keymap, String $keymapName, MessageBusConnection $connect, boolean $isParent, AnActionEvent $e) {
                                    if (Intrinsics.areEqual((Object)$keymap.getName(), (Object)$keymapName)) {
                                        String string;
                                        $connect.disconnect();
                                        if ($isParent) {
                                            var7_5 = new Object[]{$keymapName};
                                            string = IdeBundle.message((String)"notification.content.keymap.successfully.installed", (Object[])var7_5);
                                        } else {
                                            KeymapManagerEx.getInstanceEx().setActiveKeymap($keymap);
                                            var7_5 = new Object[]{$keymapName};
                                            string = IdeBundle.message((String)"notification.content.keymap.successfully.activated", (Object[])var7_5);
                                        }
                                        String string2 = string;
                                        Intrinsics.checkNotNull((Object)string2);
                                        String successMessage = string2;
                                        new Notification("KeymapInstalled", successMessage, NotificationType.INFORMATION).notify($e.getProject());
                                    }
                                }
                            });
                            Object object = new PluginId[]{PluginId.Companion.getId(this.$pluginId)};
                            Set plugins2 = SetsKt.mutableSetOf((Object[])object);
                            switch (this.$pluginId) {
                                case "com.intellij.plugins.gnomekeymap": 
                                case "com.intellij.plugins.kdekeymap": {
                                    ((Collection)plugins2).add(PluginId.Companion.getId("com.intellij.plugins.xwinkeymap"));
                                    break;
                                }
                                case "com.intellij.plugins.resharperkeymap": {
                                    ((Collection)plugins2).add(PluginId.Companion.getId("com.intellij.plugins.visualstudiokeymap"));
                                    break;
                                }
                                case "com.intellij.plugins.visualassistkeymap": {
                                    ((Collection)plugins2).add(PluginId.Companion.getId("com.intellij.plugins.visualstudiokeymap"));
                                    break;
                                }
                                case "com.intellij.plugins.visualstudio2022keymap": {
                                    ((Collection)plugins2).add(PluginId.Companion.getId("com.intellij.plugins.visualstudiokeymap"));
                                    break;
                                }
                                case "com.intellij.plugins.vsformackeymap": 
                                case "com.intellij.plugins.xcodekeymap": {
                                    ((Collection)plugins2).add(PluginId.Companion.getId("com.intellij.plugins.macoskeymap"));
                                }
                            }
                            PluginsAdvertiser.installAndEnable$default(this.$project, plugins2, false, false, null, notifyAboutMissingKeymap.projectOpened.1.action.2::actionPerformed$lambda$0, 28, null);
                            notification2.expire();
                        }

                        private static final void actionPerformed$lambda$0() {
                        }
                    };
                }
                AnAction action2 = anAction;
                new Notification("KeymapMissing", IdeBundle.message((String)"notification.group.missing.keymap", (Object[])new Object[0]), $message, NotificationType.ERROR).addAction(action2).notify($project);
            }
        });
    }

    public static final /* synthetic */ boolean access$areShortcutsEqual(List shortcuts1, List shortcuts2) {
        return KeymapImplKt.areShortcutsEqual(shortcuts1, shortcuts2);
    }

    public static final /* synthetic */ void access$sortInRegistrationOrder(List ids) {
        KeymapImplKt.sortInRegistrationOrder(ids);
    }
}

