/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CompositeConfigurable<T extends UnnamedConfigurable>
extends BaseConfigurable {
    private List<T> myConfigurables;

    public void reset() {
        for (UnnamedConfigurable configurable : this.getConfigurables()) {
            configurable.reset();
        }
    }

    public void apply() throws ConfigurationException {
        for (UnnamedConfigurable configurable : this.getConfigurables()) {
            configurable.apply();
        }
    }

    public boolean isModified() {
        for (UnnamedConfigurable configurable : this.getConfigurables()) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void disposeUIResources() {
        if (this.myConfigurables != null) {
            for (UnnamedConfigurable myConfigurable : this.myConfigurables) {
                myConfigurable.disposeUIResources();
            }
            this.myConfigurables = null;
        }
    }

    protected abstract @Unmodifiable @NotNull List<T> createConfigurables();

    public @Unmodifiable @NotNull List<T> getConfigurables() {
        if (this.myConfigurables == null) {
            this.myConfigurables = this.createConfigurables();
        }
        List<T> list2 = this.myConfigurables;
        if (list2 == null) {
            CompositeConfigurable.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompositeConfigurable", "getConfigurables"));
    }
}

