/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public final class AssertFocused
extends AbstractCommand {
    public static final String PREFIX = "%assert focused";

    public AssertFocused(String text2, int line) {
        super(text2, line);
    }

    @Override
    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        if (context2 == null) {
            AssertFocused.$$$reportNull$$$0(0);
        }
        String text2 = this.getText().substring(PREFIX.length()).trim();
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        if (!text2.isEmpty()) {
            String[] keyValue;
            for (String each : keyValue = text2.split(",")) {
                String[] eachPair = each.split("=");
                if (eachPair.length != 2) {
                    String error2 = "Syntax error, must be comma-separated pairs key=value";
                    context2.error(error2, this.getLine());
                    Promise promise = Promises.rejectedPromise((String)error2);
                    if (promise == null) {
                        AssertFocused.$$$reportNull$$$0(1);
                    }
                    return promise;
                }
                expected.put(eachPair[0], eachPair[1]);
            }
        }
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager.findInstance().doWhenFocusSettlesDown(() -> {
            try {
                this.doAssert(expected, context2);
                result2.setResult(null);
            }
            catch (AssertionError error2) {
                context2.error("Assertion failed: " + ((Throwable)((Object)error2)).getMessage(), this.getLine());
                result2.setError((Throwable)((Object)error2));
            }
        });
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            AssertFocused.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    private void doAssert(Map<String, String> expected, PlaybackContext context2) throws AssertionError {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            throw new AssertionError((Object)"No component focused");
        }
        LinkedHashMap actual = new LinkedHashMap();
        for (Component eachParent = owner; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof Queryable)) continue;
            ((Queryable)eachParent).putInfo(actual);
        }
        LinkedHashSet<String> testedKeys = new LinkedHashSet<String>();
        for (String string : expected.keySet()) {
            testedKeys.add(string);
            String actualValue = (String)actual.get(string);
            String expectedValue = expected.get(string);
            if (!expectedValue.equals(actualValue)) {
                throw new AssertionError((Object)(string + " expected: " + expectedValue + " but was: " + actualValue));
            }
        }
        HashMap<String, String> untested = new HashMap<String, String>();
        for (String eachKey : actual.keySet()) {
            if (testedKeys.contains(eachKey)) continue;
            untested.put(eachKey, (String)actual.get(eachKey));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String each : untested.keySet()) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(",");
            }
            stringBuilder.append(each).append("=").append((String)untested.get(each));
        }
        context2.message("Untested info: " + String.valueOf(stringBuilder), this.getLine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/playback/commands/AssertFocused";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/playback/commands/AssertFocused";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

