/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsAdvertiserDialogPluginInstaller {
    private static final Logger LOG = Logger.getInstance(PluginsAdvertiserDialogPluginInstaller.class);
    private final Collection<PluginDownloader> myPluginToInstall;
    @Nullable
    private final Project myProject;
    @NotNull
    private final List<PluginNode> myCustomPlugins;
    @Nullable
    private final Consumer<Boolean> myFinishFunction;

    public PluginsAdvertiserDialogPluginInstaller(@Nullable Project project2, @NotNull Collection<PluginDownloader> pluginsToInstall, @NotNull List<PluginNode> customPlugins2, @Nullable Consumer<Boolean> finishFunction) {
        if (pluginsToInstall == null) {
            PluginsAdvertiserDialogPluginInstaller.$$$reportNull$$$0(0);
        }
        if (customPlugins2 == null) {
            PluginsAdvertiserDialogPluginInstaller.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myPluginToInstall = pluginsToInstall;
        this.myCustomPlugins = customPlugins2;
        this.myFinishFunction = finishFunction;
    }

    public boolean doInstallPlugins(@NotNull Predicate<? super PluginDownloader> predicate, @NotNull ModalityState modalityState) {
        if (predicate == null) {
            PluginsAdvertiserDialogPluginInstaller.$$$reportNull$$$0(2);
        }
        if (modalityState == null) {
            PluginsAdvertiserDialogPluginInstaller.$$$reportNull$$$0(3);
        }
        ArrayList<IdeaPluginDescriptor> pluginsToEnable = new ArrayList<IdeaPluginDescriptor>();
        ArrayList<PluginNode> nodes = new ArrayList<PluginNode>();
        for (PluginDownloader downloader : this.myPluginToInstall) {
            if (!predicate.test(downloader)) continue;
            IdeaPluginDescriptor plugin = downloader.getDescriptor();
            pluginsToEnable.add(plugin);
            if (!plugin.isEnabled()) continue;
            nodes.add(downloader.toPluginNode());
        }
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(nodes)) {
            return false;
        }
        TreeSet notAllowedToInstallPlugins = nodes.stream().filter(descriptor2 -> !PluginManagementPolicy.getInstance().canInstallPlugin((IdeaPluginDescriptor)descriptor2)).map(e -> e.getPluginId().getIdString()).collect(Collectors.toCollection(TreeSet::new));
        if (!notAllowedToInstallPlugins.isEmpty()) {
            LOG.warn("Some advertised plugins were not allowed to install for the organization: " + StringUtil.join((Collection)notAllowedToInstallPlugins, (String)", "));
            return false;
        }
        PluginManagerMain.suggestToEnableInstalledDependantPlugins((PluginEnabler)PluginEnabler.HEADLESS, nodes);
        Runnable notifyRunnable = () -> {
            boolean notInstalled = nodes.stream().map(PluginNode::getPluginId).map(PluginManagerCore::getPlugin).anyMatch(Objects::isNull);
            if (notInstalled) {
                PluginManagerMain.notifyPluginsUpdated(this.myProject);
            }
        };
        PluginEnabler.HEADLESS.enable(pluginsToEnable);
        if (!nodes.isEmpty()) {
            try {
                this.downloadPlugins(nodes, this.myCustomPlugins, notifyRunnable, modalityState, this.myFinishFunction);
            }
            catch (IOException e2) {
                LOG.error((Throwable)e2);
            }
        } else if (!pluginsToEnable.isEmpty()) {
            notifyRunnable.run();
        }
        return true;
    }

    @ApiStatus.OverrideOnly
    public void downloadPlugins(@NotNull List<PluginNode> plugins2, @NotNull Collection<PluginNode> customPlugins2, @Nullable Runnable onSuccess, @NotNull ModalityState modalityState, @Nullable Consumer<Boolean> function) throws IOException {
        if (plugins2 == null) {
            PluginsAdvertiserDialogPluginInstaller.$$$reportNull$$$0(4);
        }
        if (customPlugins2 == null) {
            PluginsAdvertiserDialogPluginInstaller.$$$reportNull$$$0(5);
        }
        if (modalityState == null) {
            PluginsAdvertiserDialogPluginInstaller.$$$reportNull$$$0(6);
        }
        PluginManagerMain.downloadPlugins(plugins2, customPlugins2, true, onSuccess, (PluginEnabler)PluginEnabler.HEADLESS, modalityState, function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserDialogPluginInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doInstallPlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadPlugins";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

