/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.projectActions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.RecentProjectIconHelper;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.wm.impl.welcomeScreen.projectActions.ChangeProjectColorActionGroupKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B.\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00062\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/projectActions/ChangeProjectColorAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "projectPath", "Ljava/nio/file/Path;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "index", "", "projectName", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;ILjava/lang/String;)V", "getName", "()Ljava/lang/String;", "getIndex", "()I", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "transformToCurrentIfNeeded", "project", "Lcom/intellij/openapi/project/Project;", "actionPerformed", "intellij.platform.ide.impl"})
public final class ChangeProjectColorAction
extends AnAction
implements DumbAware {
    @NotNull
    private final String name;
    private final int index;

    public ChangeProjectColorAction(@NotNull Path projectPath, @NotNull String name2, int index, @Nullable String projectName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(name2, "", RecentProjectIconHelper.Companion.generateNewProjectIcon(projectPath, true, projectName, index, 16));
        this.name = name2;
        this.index = index;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        e.getPresentation().setText(this.transformToCurrentIfNeeded(this.name, project3));
    }

    @NlsActions.ActionText
    private final String transformToCurrentIfNeeded(@NlsActions.ActionText String name2, Project project2) {
        ProjectWindowCustomizerService customizer = ProjectWindowCustomizerService.Companion.getInstance();
        Integer n = customizer.getCurrentProjectColorIndex(project2);
        if (n != null && this.index == n) {
            Object[] objectArray = new Object[]{name2};
            String string = IdeBundle.message((String)"action.ChangeProjectColorAction.Current.title", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        return name2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ProjectWindowCustomizerService customizer = ProjectWindowCustomizerService.Companion.getInstance();
        customizer.clearToolbarColorsAndInMemoryCache(project3);
        customizer.setAssociatedColorsIndex(project3, this.index);
        ChangeProjectColorActionGroupKt.access$repaintFrame(project3);
    }
}

