/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.syntax.LanguageSyntaxDefinition;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.TokenList;
import com.intellij.platform.syntax.psi.DefaultWhitespaceOrCommentPolicy;
import com.intellij.platform.syntax.psi.ElementTypeConverter;
import com.intellij.platform.syntax.psi.ElementTypeConverters;
import com.intellij.platform.syntax.psi.LanguageSyntaxDefinitions;
import com.intellij.platform.syntax.psi.PsiSyntaxBuilder;
import com.intellij.platform.syntax.psi.PsiSyntaxBuilderFactory;
import com.intellij.platform.syntax.psi.impl.LazyParseableToken;
import com.intellij.platform.syntax.psi.impl.LexingKt;
import com.intellij.platform.syntax.psi.impl.PsiSyntaxBuilderImpl;
import com.intellij.platform.syntax.psi.impl.PsiSyntaxBuilderImplKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/syntax/psi/PsiSyntaxBuilderFactoryImpl;", "Lcom/intellij/platform/syntax/psi/PsiSyntaxBuilderFactory;", "<init>", "()V", "createBuilder", "Lcom/intellij/platform/syntax/psi/PsiSyntaxBuilder;", "chameleon", "Lcom/intellij/lang/ASTNode;", "lexer", "Lcom/intellij/platform/syntax/lexer/Lexer;", "lang", "Lcom/intellij/lang/Language;", "text", "", "Lcom/intellij/lang/LighterLazyParseableNode;", "getParserDefinition", "Lcom/intellij/lang/ParserDefinition;", "language", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "getConverter", "Lcom/intellij/platform/syntax/psi/ElementTypeConverter;", "intellij.platform.syntax.psi"})
public final class PsiSyntaxBuilderFactoryImpl
implements PsiSyntaxBuilderFactory {
    @Override
    @NotNull
    public PsiSyntaxBuilder createBuilder(@NotNull ASTNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence text2) {
        ParserDefinition parserDefinition = this.getParserDefinition(lang, chameleon.getElementType());
        ElementTypeConverter tokenConverter = this.getConverter(lang, chameleon.getElementType());
        LanguageSyntaxDefinition languageSyntaxDefinition = (LanguageSyntaxDefinition)LanguageSyntaxDefinitions.Companion.getINSTANCE().forLanguage(lang);
        if (languageSyntaxDefinition == null) {
            throw new IllegalStateException("No SyntaxDefinition for language: " + lang);
        }
        LanguageSyntaxDefinition syntaxDefinition = languageSyntaxDefinition;
        Lexer lexer2 = lexer;
        if (lexer2 == null) {
            lexer2 = syntaxDefinition.createLexer();
        }
        Lexer actualLexer = lexer2;
        TokenList cachedLexemes = PsiSyntaxBuilderImplKt.extractCachedLexemes(chameleon);
        TokenList lexingResult = LexingKt.performLexingIfNecessary(cachedLexemes, actualLexer, text2, lang);
        PsiFile psiFile = SharedImplUtil.getContainingFile((ASTNode)chameleon);
        CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)chameleon);
        ASTNode aSTNode = (ASTNode)Pair.getFirst((Pair)((Pair)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)));
        CharSequence charSequence = (CharSequence)Pair.getSecond((Pair)((Pair)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)));
        DefaultWhitespaceOrCommentPolicy defaultWhitespaceOrCommentPolicy = new DefaultWhitespaceOrCommentPolicy(tokenConverter);
        return new PsiSyntaxBuilderImpl(psiFile, parserDefinition, syntaxDefinition, charTable, text2, aSTNode, charSequence, null, 0, lexingResult, tokenConverter, null, defaultWhitespaceOrCommentPolicy);
    }

    @Override
    @NotNull
    public PsiSyntaxBuilder createBuilder(@NotNull LighterLazyParseableNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence text2) {
        ParserDefinition parserDefinition = this.getParserDefinition(null, chameleon.getTokenType());
        ElementTypeConverter tokenConverter = this.getConverter(lang, chameleon.getTokenType());
        LanguageSyntaxDefinition languageSyntaxDefinition = (LanguageSyntaxDefinition)LanguageSyntaxDefinitions.Companion.getINSTANCE().forLanguage(lang);
        Lexer lexer2 = lexer;
        if (lexer2 == null) {
            lexer2 = languageSyntaxDefinition.createLexer();
        }
        Lexer actualLexer = lexer2;
        TokenList cachedLexemes = PsiSyntaxBuilderImplKt.extractCachedLexemes(chameleon);
        TokenList lexingResult = LexingKt.performLexingIfNecessary(cachedLexemes, actualLexer, text2, lang);
        PsiFile psiFile = chameleon.getContainingFile();
        CharTable charTable = chameleon.getCharTable();
        Intrinsics.checkNotNull((Object)chameleon, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.psi.impl.LazyParseableToken");
        return new PsiSyntaxBuilderImpl(psiFile, parserDefinition, languageSyntaxDefinition, charTable, text2, null, null, (FlyweightCapableTreeStructure<LighterASTNode>)((FlyweightCapableTreeStructure)((LazyParseableToken)chameleon).getParentStructure()), ((LazyParseableToken)chameleon).getStartOffset(), lexingResult, tokenConverter, null, new DefaultWhitespaceOrCommentPolicy(tokenConverter));
    }

    private final ParserDefinition getParserDefinition(Language language, IElementType tokenType) {
        Language adjusted;
        ParserDefinition parserDefinition;
        Language language2 = language;
        if (language2 == null) {
            language2 = tokenType.getLanguage();
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(adjusted = language2)) == null) {
            throw new AssertionError((Object)("ParserDefinition absent for language: '" + adjusted.getID() + "' (" + adjusted.getClass().getName() + "), for elementType: '" + tokenType.getDebugName() + "' (" + tokenType.getClass().getName() + ')'));
        }
        return parserDefinition;
    }

    private final ElementTypeConverter getConverter(Language language, IElementType tokenType) {
        Language language2 = language;
        if (language2 == null) {
            language2 = tokenType.getLanguage();
        }
        Language adjusted = language2;
        return ElementTypeConverters.getConverter(adjusted);
    }
}

