/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWhiteSpaceFormattingStrategy
implements WhiteSpaceFormattingStrategy {
    @Override
    public boolean replaceDefaultStrategy() {
        return false;
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text2, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        if (whiteSpaceText == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(1);
        }
        CharSequence charSequence = whiteSpaceText;
        if (charSequence == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        if (whiteSpaceText == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(4);
        }
        assert (startElement.getTextRange().contains(startOffset)) : String.format("Element: %s, range: %s, offset: %d", startElement, startElement.getTextRange(), startOffset);
        StringBuilder buffer2 = new StringBuilder();
        PsiElement current = startElement;
        while (current != null && current.getTextRange().getStartOffset() < endOffset) {
            TextRange range = current.getTextRange();
            String text2 = current.getText();
            if (!StringUtil.isEmpty((String)text2)) {
                int start2;
                int n = start2 = startOffset > range.getStartOffset() ? startOffset - range.getStartOffset() : 0;
                if (start2 < text2.length()) {
                    int end;
                    int n2 = end = endOffset < range.getEndOffset() ? text2.length() - (range.getEndOffset() - endOffset) : text2.length();
                    if (end > start2) {
                        if (start2 == 0 && end == text2.length()) {
                            buffer2.append(text2);
                        } else {
                            buffer2.append(text2, start2, end);
                        }
                    }
                }
            }
            current = AbstractWhiteSpaceFormattingStrategy.next(current);
        }
        return this.adjustWhiteSpaceIfNecessary(whiteSpaceText, buffer2, 0, endOffset - startOffset, codeStyleSettings, null);
    }

    @Nullable
    private static PsiElement next(@NotNull PsiElement element) {
        if (element == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(5);
        }
        for (PsiElement anchor = element; anchor != null; anchor = anchor.getParent()) {
            PsiElement result2 = element.getNextSibling();
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        if (node == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Override
    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        if (treePrev == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(7);
        }
        if (whiteSpaceElement == null) {
            AbstractWhiteSpaceFormattingStrategy.$$$reportNull$$$0(8);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePrev";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustWhiteSpaceIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsWhitespacesOnly";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addWhitespace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

