/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.SaturationBrightnessComponent;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J&\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0006\u0010\u001a\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\u0006J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u0015\u0010!\u001a\u00070\u0012\u00a2\u0006\u0002\b\"2\u0006\u0010 \u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ui/colorpicker/LightCalloutPopup;", "", "content", "Ljavax/swing/JComponent;", "closedCallback", "Lkotlin/Function0;", "", "cancelCallBack", "beforeShownCallback", "<init>", "(Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getContent", "()Ljavax/swing/JComponent;", "getClosedCallback", "()Lkotlin/jvm/functions/Function0;", "getCancelCallBack", "getBeforeShownCallback", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "getBalloon", "show", "parentComponent", "location", "Ljava/awt/Point;", "position", "Lcom/intellij/openapi/ui/popup/Balloon$Position;", "close", "cancel", "getPointerColor", "Ljava/awt/Color;", "showingPoint", "Lcom/intellij/ui/awt/RelativePoint;", "component", "createPopup", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
public final class LightCalloutPopup {
    @NotNull
    private final JComponent content;
    @Nullable
    private final Function0<Unit> closedCallback;
    @Nullable
    private final Function0<Unit> cancelCallBack;
    @Nullable
    private final Function0<Unit> beforeShownCallback;
    @Nullable
    private Balloon balloon;

    public LightCalloutPopup(@NotNull JComponent content2, @Nullable Function0<Unit> closedCallback, @Nullable Function0<Unit> cancelCallBack, @Nullable Function0<Unit> beforeShownCallback) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.content = content2;
        this.closedCallback = closedCallback;
        this.cancelCallBack = cancelCallBack;
        this.beforeShownCallback = beforeShownCallback;
    }

    public /* synthetic */ LightCalloutPopup(JComponent jComponent, Function0 function0, Function0 function02, Function0 function03, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        if ((n & 4) != 0) {
            function02 = null;
        }
        if ((n & 8) != 0) {
            function03 = null;
        }
        this(jComponent, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03);
    }

    @NotNull
    public final JComponent getContent() {
        return this.content;
    }

    @Nullable
    public final Function0<Unit> getClosedCallback() {
        return this.closedCallback;
    }

    @Nullable
    public final Function0<Unit> getCancelCallBack() {
        return this.cancelCallBack;
    }

    @Nullable
    public final Function0<Unit> getBeforeShownCallback() {
        return this.beforeShownCallback;
    }

    @Nullable
    public final Balloon getBalloon() {
        return this.balloon;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void show(@Nullable JComponent parentComponent, @NotNull Point location, @NotNull Balloon.Position position2) {
        void $this$show_u24lambda_u240;
        Balloon balloon;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
        if (this.balloon != null) {
            this.cancel();
        }
        Balloon balloon2 = balloon = this.createPopup(this.content);
        LightCalloutPopup lightCalloutPopup = this;
        boolean bl = false;
        $this$show_u24lambda_u240.addListener(new JBPopupListener(this){
            final /* synthetic */ LightCalloutPopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeShown(LightweightWindowEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Function0<Unit> function0 = this.this$0.getBeforeShownCallback();
                    if (function0 == null) break block0;
                    function0.invoke();
                }
            }

            public void onClosed(LightweightWindowEvent event) {
                block1: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (!event.isOk()) break block0;
                        Function0<Unit> function0 = this.this$0.getClosedCallback();
                        if (function0 == null) break block1;
                        function0.invoke();
                        break block1;
                    }
                    Function0<Unit> function0 = this.this$0.getCancelCallBack();
                    if (function0 == null) break block1;
                    function0.invoke();
                }
            }
        });
        if ($this$show_u24lambda_u240 instanceof BalloonImpl) {
            ((BalloonImpl)$this$show_u24lambda_u240).setHideListener(() -> LightCalloutPopup.show$lambda$0$0(this, (Balloon)$this$show_u24lambda_u240));
        }
        RelativePoint relativePoint = parentComponent != null ? new RelativePoint((Component)parentComponent, location) : new RelativePoint(location);
        $this$show_u24lambda_u240.show(relativePoint, position2);
        lightCalloutPopup.balloon = balloon;
    }

    public static /* synthetic */ void show$default(LightCalloutPopup lightCalloutPopup, JComponent jComponent, Point point, Balloon.Position position2, int n, Object object) {
        if ((n & 1) != 0) {
            jComponent = null;
        }
        if ((n & 4) != 0) {
            position2 = Balloon.Position.below;
        }
        lightCalloutPopup.show(jComponent, point, position2);
    }

    public final void close() {
        block0: {
            Balloon balloon = this.balloon;
            if (balloon == null) break block0;
            balloon.hide(true);
        }
    }

    public final void cancel() {
        block0: {
            Balloon balloon = this.balloon;
            if (balloon == null) break block0;
            balloon.hide(false);
        }
    }

    @Nullable
    public final Color getPointerColor(@NotNull RelativePoint showingPoint, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)showingPoint, (String)"showingPoint");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        SaturationBrightnessComponent saturationBrightnessComponent = (SaturationBrightnessComponent)UIUtil.findComponentOfType((JComponent)component2, SaturationBrightnessComponent.class);
        if (saturationBrightnessComponent != null) {
            int y;
            int x;
            if (Registry.Companion.is("ide.color.picker.new.pipette") && saturationBrightnessComponent.getPipetteMode()) {
                return saturationBrightnessComponent.getParent().getBackground();
            }
            Point point = showingPoint.getPoint((Component)saturationBrightnessComponent);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            Point point2 = point;
            Dimension size2 = saturationBrightnessComponent.getSize();
            Point location = saturationBrightnessComponent.getLocation();
            int x1 = location.x;
            int y1 = location.y;
            int x2 = x1 + size2.width;
            int y2 = y1 + size2.height;
            int n = point2.x < x1 ? x1 : (x = point2.x > x2 ? x2 : point2.x);
            int n2 = point2.y < y1 ? y1 : (y = point2.y > y2 ? y2 : point2.y);
            if (y == y2) {
                return null;
            }
            return saturationBrightnessComponent.getColorByPoint(new Point(x, y));
        }
        return null;
    }

    private final Balloon createPopup(JComponent component2) {
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(component2).setFillColor((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR()).setBorderColor(JBColor.border()).setBorderInsets((Insets)JBUI.insets((int)1)).setAnimationCycle(Registry.Companion.intValue("ide.tooltip.animationCycle")).setShowCallout(true).setPositionChangeYShift(2).setHideOnKeyOutside(false).setHideOnAction(false).setBlockClicksThroughBalloon(true).setRequestFocus(true).setDialogMode(false).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        return balloon;
    }

    @JvmOverloads
    public final void show(@Nullable JComponent parentComponent, @NotNull Point location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        LightCalloutPopup.show$default(this, parentComponent, location, null, 4, null);
    }

    @JvmOverloads
    public final void show(@NotNull Point location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        LightCalloutPopup.show$default(this, null, location, null, 5, null);
    }

    private static final void show$lambda$0$0(LightCalloutPopup this$0, Balloon $this_apply) {
        Function0<Unit> function0 = this$0.closedCallback;
        if (function0 != null) {
            function0.invoke();
        }
        ((BalloonImpl)$this_apply).hide();
    }
}

