/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.impl;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.html.CssAttributesEx;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ui/components/impl/EditorColorsSchemeStyleSheet;", "Ljavax/swing/text/html/StyleSheet;", "editorColorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "computedStyles", "", "", "Ljavax/swing/text/Style;", "getRule", "selector", "t", "Ljavax/swing/text/html/HTML$Tag;", "e", "Ljavax/swing/text/Element;", "getTokenRule", "token", "createTokenRule", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorColorsSchemeStyleSheet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorColorsSchemeStyleSheet.kt\ncom/intellij/ui/components/impl/EditorColorsSchemeStyleSheet\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n654#2,5:155\n1#3:160\n*S KotlinDebug\n*F\n+ 1 EditorColorsSchemeStyleSheet.kt\ncom/intellij/ui/components/impl/EditorColorsSchemeStyleSheet\n*L\n26#1:155,5\n*E\n"})
public final class EditorColorsSchemeStyleSheet
extends StyleSheet {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final EditorColorsScheme editorColorsScheme;
    @NotNull
    private final Map<String, Style> computedStyles;
    @NotNull
    private static final Class<?> CssValueClass;
    private static final Object cssValueSolid;
    @NotNull
    private static final Class<?> CssCssValueClass;
    private static final Field CssCssValueSvalueField;
    @NotNull
    private static final Class<?> ColorValueClass;
    private static final Constructor<? extends Object> ColorValueConstructor;
    private static final Field ColorValueColorField;
    @NotNull
    private static final Class<?> StringValueClass;
    private static final Constructor<? extends Object> StringValueConstructor;
    @NotNull
    private static final Class<?> LengthValueClass;
    private static final Constructor<? extends Object> LengthValueConstructor;
    private static final Field LengthValueSpanField;

    public EditorColorsSchemeStyleSheet(@NotNull EditorColorsScheme editorColorsScheme) {
        Intrinsics.checkNotNullParameter((Object)editorColorsScheme, (String)"editorColorsScheme");
        this.editorColorsScheme = editorColorsScheme;
        this.computedStyles = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Style getRule(@NotNull String selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        int ind = StringsKt.indexOf$default((CharSequence)selector, (String)("." + JBHtmlPaneStyleConfiguration.Companion.getEditorColorClassPrefix()), (int)0, (boolean)false, (int)6, null);
        if (ind >= 0) {
            String string;
            block2: {
                void $this$takeWhile$iv;
                String string2 = selector.substring(ind + JBHtmlPaneStyleConfiguration.Companion.getEditorColorClassPrefix().length() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String string3 = string2;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!CharsKt.isWhitespace((char)it)) continue;
                    void var8_8 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string4 = var8_8.substring(n2, index$iv);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    break block2;
                }
                string = $this$takeWhile$iv;
            }
            void token = string;
            return this.getTokenRule((String)token);
        }
        return null;
    }

    @Override
    @Nullable
    public Style getRule(@NotNull HTML.Tag t, @NotNull Element e) {
        String cls;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getAttributes().getAttribute(HTML.Attribute.CLASS);
        String string = cls = object instanceof String ? (String)object : null;
        boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)JBHtmlPaneStyleConfiguration.Companion.getEditorColorClassPrefix(), (boolean)false, (int)2, null) : false;
        if (bl) {
            String string2 = cls.substring(JBHtmlPaneStyleConfiguration.Companion.getEditorColorClassPrefix().length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return this.getTokenRule(string2);
        }
        return null;
    }

    private final Style getTokenRule(String token) {
        Style style = this.computedStyles.computeIfAbsent(token, arg_0 -> EditorColorsSchemeStyleSheet.getTokenRule$lambda$1(arg_0 -> EditorColorsSchemeStyleSheet.getTokenRule$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"computeIfAbsent(...)");
        return style;
    }

    private final Style createTokenRule(String token) {
        Color it;
        TextAttributes attributes = this.editorColorsScheme.getAttributes(TextAttributesKey.createTextAttributesKey((String)token), true);
        StyleContext.NamedStyle result2 = new StyleContext.NamedStyle(this, token, null);
        Color color = attributes.getForegroundColor();
        if (color != null) {
            it = color;
            boolean bl = false;
            result2.addAttribute(CSS.Attribute.COLOR, EditorColorsSchemeStyleSheet.Companion.colorValue(it));
        }
        Color color2 = attributes.getBackgroundColor();
        if (color2 != null) {
            it = color2;
            boolean bl = false;
            result2.addAttribute(CSS.Attribute.BACKGROUND_COLOR, EditorColorsSchemeStyleSheet.Companion.colorValue(it));
        }
        if ((attributes.getFontType() & 1) != 0) {
            result2.addAttribute(StyleConstants.Bold, true);
        }
        if ((attributes.getFontType() & 2) != 0) {
            result2.addAttribute(StyleConstants.Italic, true);
        }
        EffectType effectType = attributes.getEffectType();
        if (attributes.hasEffects() && effectType != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    result2.addAttribute(StyleConstants.Underline, true);
                    break;
                }
                case 5: {
                    result2.addAttribute(StyleConstants.StrikeThrough, true);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    Color color3 = attributes.getEffectColor();
                    if (color3 != null) {
                        Color effectColor = color3;
                        boolean bl = false;
                        Object borderWidth = EditorColorsSchemeStyleSheet.Companion.lengthValue(JBUI.scale((int)1));
                        result2.addAttribute(CSS.Attribute.BORDER_TOP_WIDTH, borderWidth);
                        result2.addAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH, borderWidth);
                        result2.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, borderWidth);
                        result2.addAttribute(CSS.Attribute.BORDER_LEFT_WIDTH, borderWidth);
                        result2.addAttribute(CSS.Attribute.MARGIN_TOP, borderWidth);
                        result2.addAttribute(CSS.Attribute.MARGIN_RIGHT, borderWidth);
                        result2.addAttribute(CSS.Attribute.MARGIN_BOTTOM, borderWidth);
                        result2.addAttribute(CSS.Attribute.MARGIN_LEFT, borderWidth);
                        Object color4 = EditorColorsSchemeStyleSheet.Companion.colorValue(effectColor);
                        result2.addAttribute(CSS.Attribute.BORDER_TOP_COLOR, color4);
                        result2.addAttribute(CSS.Attribute.BORDER_RIGHT_COLOR, color4);
                        result2.addAttribute(CSS.Attribute.BORDER_BOTTOM_COLOR, color4);
                        result2.addAttribute(CSS.Attribute.BORDER_LEFT_COLOR, color4);
                        Object style = cssValueSolid;
                        result2.addAttribute(CSS.Attribute.BORDER_TOP_STYLE, style);
                        result2.addAttribute(CSS.Attribute.BORDER_RIGHT_STYLE, style);
                        result2.addAttribute(CSS.Attribute.BORDER_BOTTOM_STYLE, style);
                        result2.addAttribute(CSS.Attribute.BORDER_LEFT_STYLE, style);
                        Object paddingTopBottom = EditorColorsSchemeStyleSheet.Companion.lengthValue(JBUI.scale((int)2));
                        result2.addAttribute(CSS.Attribute.PADDING_TOP, paddingTopBottom);
                        result2.addAttribute(CSS.Attribute.PADDING_BOTTOM, paddingTopBottom);
                        if (effectType == EffectType.SLIGHTLY_WIDER_BOX) {
                            Object paddingLeftRight = EditorColorsSchemeStyleSheet.Companion.lengthValue(JBUI.scale((int)2));
                            result2.addAttribute(CSS.Attribute.PADDING_LEFT, paddingLeftRight);
                            result2.addAttribute(CSS.Attribute.PADDING_RIGHT, paddingLeftRight);
                        }
                        if (effectType == EffectType.ROUNDED_BOX) {
                            result2.addAttribute(CssAttributesEx.BORDER_RADIUS, JBUI.scale((int)2) + "px");
                            break;
                        }
                        result2.addAttribute(CssAttributesEx.BORDER_RADIUS, "0px");
                    }
                    break;
                }
                case 10: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return result2;
    }

    private static final Style getTokenRule$lambda$0(EditorColorsSchemeStyleSheet this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createTokenRule(it);
    }

    private static final Style getTokenRule$lambda$1(Function1 $tmp0, Object p0) {
        return (Style)$tmp0.invoke(p0);
    }

    static {
        Object object;
        Object[] it;
        Object object2;
        block9: {
            Object object3;
            Class it2;
            block8: {
                Object object4;
                block7: {
                    Object object5;
                    block6: {
                        Object object6;
                        block5: {
                            Companion = new Companion(null);
                            Class<?>[] classArray = CSS.class.getDeclaredClasses();
                            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
                            for (Object object7 : (Object[])classArray) {
                                it2 = (Class)object7;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it2.getSimpleName(), (Object)"Value")) continue;
                                object6 = object7;
                                break block5;
                            }
                            object6 = null;
                        }
                        Intrinsics.checkNotNull(object6);
                        CssValueClass = (Class)object6;
                        it = object2 = CssValueClass.getDeclaredField("SOLID");
                        int n = 0;
                        it.setAccessible(true);
                        cssValueSolid = object2.get(null);
                        Class<?>[] classArray = CSS.class.getDeclaredClasses();
                        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
                        for (Object object7 : (Object[])classArray) {
                            it2 = (Class)object7;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it2.getSimpleName(), (Object)"CssValue")) continue;
                            object5 = object7;
                            break block6;
                        }
                        object5 = null;
                    }
                    Intrinsics.checkNotNull(object5);
                    CssCssValueClass = (Class)object5;
                    it = object2 = CssCssValueClass.getDeclaredField("svalue");
                    int n = 0;
                    it.setAccessible(true);
                    CssCssValueSvalueField = object2;
                    Class<?>[] classArray = CSS.class.getDeclaredClasses();
                    Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
                    for (Object object7 : (Object[])classArray) {
                        it2 = (Class)object7;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getSimpleName(), (Object)"ColorValue")) continue;
                        object4 = object7;
                        break block7;
                    }
                    object4 = null;
                }
                Intrinsics.checkNotNull(object4);
                ColorValueClass = (Class)object4;
                it = object2 = ColorValueClass.getDeclaredConstructor(new Class[0]);
                boolean bl = false;
                it.setAccessible(true);
                ColorValueConstructor = object2;
                it = object2 = ColorValueClass.getDeclaredField("c");
                int n = 0;
                it.setAccessible(true);
                ColorValueColorField = object2;
                Class<?>[] classArray = CSS.class.getDeclaredClasses();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
                for (Object object7 : (Object[])classArray) {
                    it2 = (Class)object7;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getSimpleName(), (Object)"StringValue")) continue;
                    object3 = object7;
                    break block8;
                }
                object3 = null;
            }
            Intrinsics.checkNotNull(object3);
            StringValueClass = (Class)object3;
            it = object2 = StringValueClass.getDeclaredConstructor(new Class[0]);
            int n = 0;
            it.setAccessible(true);
            StringValueConstructor = object2;
            Class<?>[] classArray = CSS.class.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
            for (Object object7 : (Object[])classArray) {
                it2 = (Class)object7;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getSimpleName(), (Object)"LengthValue")) continue;
                object = object7;
                break block9;
            }
            object = null;
        }
        Intrinsics.checkNotNull(object);
        LengthValueClass = (Class)object;
        it = object2 = LengthValueClass.getDeclaredConstructor(new Class[0]);
        boolean bl = false;
        it.setAccessible(true);
        LengthValueConstructor = object2;
        it = object2 = LengthValueClass.getDeclaredField("span");
        boolean bl3 = false;
        it.setAccessible(true);
        LengthValueSpanField = object2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002R\u0012\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \r*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0012\u001a*\u0012\u000e\b\u0001\u0012\n \r*\u0004\u0018\u00010\u00010\u0001 \r*\u0014\u0012\u000e\b\u0001\u0012\n \r*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \r*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0016\u001a*\u0012\u000e\b\u0001\u0012\n \r*\u0004\u0018\u00010\u00010\u0001 \r*\u0014\u0012\u000e\b\u0001\u0012\n \r*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0018\u001a*\u0012\u000e\b\u0001\u0012\n \r*\u0004\u0018\u00010\u00010\u0001 \r*\u0014\u0012\u000e\b\u0001\u0012\n \r*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \r*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ui/components/impl/EditorColorsSchemeStyleSheet$Companion;", "", "<init>", "()V", "colorValue", "color", "Ljava/awt/Color;", "lengthValue", "value", "", "CssValueClass", "Ljava/lang/Class;", "cssValueSolid", "kotlin.jvm.PlatformType", "CssCssValueClass", "CssCssValueSvalueField", "Ljava/lang/reflect/Field;", "ColorValueClass", "ColorValueConstructor", "Ljava/lang/reflect/Constructor;", "ColorValueColorField", "StringValueClass", "StringValueConstructor", "LengthValueClass", "LengthValueConstructor", "LengthValueSpanField", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nEditorColorsSchemeStyleSheet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorColorsSchemeStyleSheet.kt\ncom/intellij/ui/components/impl/EditorColorsSchemeStyleSheet$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Object colorValue(Color color) {
            Object t;
            Object it = t = ColorValueConstructor.newInstance(new Object[0]);
            boolean bl = false;
            ColorValueColorField.set(it, color);
            Object t2 = t;
            Intrinsics.checkNotNullExpressionValue(t2, (String)"also(...)");
            return t2;
        }

        private final Object lengthValue(float value) {
            Object t;
            Object it = t = LengthValueConstructor.newInstance(new Object[0]);
            boolean bl = false;
            LengthValueSpanField.set(it, Float.valueOf(value));
            Object t2 = t;
            Intrinsics.checkNotNullExpressionValue(t2, (String)"also(...)");
            return t2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectType.values().length];
            try {
                nArray[EffectType.LINE_UNDERSCORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.WAVE_UNDERSCORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.BOLD_LINE_UNDERSCORE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.BOLD_DOTTED_LINE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.STRIKEOUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.BOXED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.SLIGHTLY_WIDER_BOX.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.SEARCH_MATCH.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.ROUNDED_BOX.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.FADED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

