/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.jna.Pointer;
import java.awt.Dimension;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.AsyncPromise;

@ApiStatus.Internal
public class TBItemButton
extends TBItem {
    private static final int TEST_DELAY_MS = Integer.getInteger("touchbar.test.delay", 0);
    private static final Executor ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Touchbar buttons updater", (int)2);
    @Nullable
    final TouchBarStats.AnActionStats actionStats;
    @Nullable
    private String myText;
    @Nullable
    private String myHint;
    private boolean myIsHintDisabled = false;
    private int myLayoutBits = 0;
    private boolean myHasArrowIcon = false;
    private boolean isGetDisabledIconNeeded = false;
    private AsyncPromise<Pair<Pointer, Dimension>> rasterPromise;
    @Nullable
    private Runnable action;
    @Nullable
    private NSTLibrary.Action nativeCallback;
    private boolean executeOnEdt = true;
    private ModalityState modality = null;
    @Nullable
    protected Icon originIcon;
    protected int myFlags = 0;
    protected int updateOptions;

    TBItemButton(@Nullable ItemListener listener2, @Nullable TouchBarStats.AnActionStats actionStats) {
        super("button", listener2);
        this.actionStats = actionStats;
    }

    @Nullable
    private Icon getDarkIcon(@Nullable Icon icon2) {
        if (icon2 == null) {
            return null;
        }
        long startNs = this.actionStats == null ? 0L : System.nanoTime();
        icon2 = IconLoader.getDarkIcon((Icon)icon2, (boolean)true);
        if (this.actionStats != null) {
            this.actionStats.iconGetDarkDurationNs += System.nanoTime() - startNs;
        }
        return icon2;
    }

    void setIcon(Icon icon2, boolean needGetDisabled) {
        if (this.isGetDisabledIconNeeded != needGetDisabled || !Objects.equals(icon2, this.originIcon)) {
            this.originIcon = icon2;
            this.isGetDisabledIconNeeded = needGetDisabled;
            this.updateOptions |= 8;
        }
    }

    @VisibleForTesting
    public TBItemButton setIcon(Icon icon2) {
        if (!Objects.equals(icon2, this.originIcon) || this.isGetDisabledIconNeeded) {
            this.originIcon = icon2;
            this.isGetDisabledIconNeeded = false;
            this.updateOptions |= 8;
        }
        return this;
    }

    void setIconFromPresentation(@NotNull Presentation presentation2) {
        Icon icon2;
        if (presentation2 == null) {
            TBItemButton.$$$reportNull$$$0(0);
        }
        boolean needGetDisabledIcon = false;
        if (presentation2.isEnabled()) {
            icon2 = presentation2.getIcon();
        } else {
            icon2 = presentation2.getDisabledIcon();
            if (icon2 == null && presentation2.getIcon() != null) {
                needGetDisabledIcon = true;
                icon2 = presentation2.getIcon();
            }
        }
        this.setIcon(icon2, needGetDisabledIcon);
    }

    void setIconAndTextFromPresentation(@NotNull Presentation presentation2, @Nullable TouchbarActionCustomizations touchBarAction) {
        if (presentation2 == null) {
            TBItemButton.$$$reportNull$$$0(1);
        }
        if (touchBarAction != null) {
            if (touchBarAction.isShowImage() && touchBarAction.isShowText()) {
                this.setIconFromPresentation(presentation2);
                this.setText(presentation2.getText());
            } else if (touchBarAction.isShowText()) {
                this.setText(presentation2.getText());
                this.setIcon(null);
            } else {
                this.setIconFromPresentation(presentation2);
                this.setText(this.originIcon != null ? null : presentation2.getText());
            }
        } else {
            this.setIconFromPresentation(presentation2);
            this.setText(this.originIcon != null ? null : presentation2.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHasArrowIcon(boolean hasArrowIcon) {
        if (hasArrowIcon != this.myHasArrowIcon) {
            this.myHasArrowIcon = hasArrowIcon;
            TBItemButton tBItemButton = this;
            synchronized (tBItemButton) {
                if (this.myNativePeer != ID.NIL) {
                    NST.setArrowImage(this.myNativePeer, this.myHasArrowIcon ? AllIcons.Mac.Touchbar.PopoverArrow : null);
                }
            }
        }
    }

    @VisibleForTesting
    public TBItemButton setText(String text2) {
        if (!Objects.equals(text2, this.myText)) {
            this.myText = text2;
            this.updateOptions |= 4;
        }
        return this;
    }

    void setText(String text2, String hint, boolean isHintDisabled) {
        if (!Objects.equals(text2, this.myText) || !Objects.equals(hint, this.myHint) || hint != null && this.myIsHintDisabled != isHintDisabled) {
            this.myText = text2;
            this.myHint = hint;
            this.myIsHintDisabled = isHintDisabled;
            this.updateOptions |= 4;
        }
    }

    void setModality(ModalityState modality) {
        this.modality = modality;
    }

    @VisibleForTesting
    public TBItemButton setAction(Runnable action2, boolean executeOnEDT) {
        if (action2 == this.action && this.executeOnEdt == executeOnEDT) {
            return this;
        }
        this.action = action2;
        this.executeOnEdt = executeOnEDT;
        this.nativeCallback = action2 == null ? null : () -> {
            if (this.executeOnEdt) {
                Application app = ApplicationManager.getApplication();
                if (this.modality == null) {
                    app.invokeLater(this.action);
                } else {
                    app.invokeLater(this.action, this.modality);
                }
            } else {
                this.action.run();
            }
            ActivityTracker.getInstance().inc();
            if (this.myListener != null) {
                this.myListener.onItemEvent(this, 0);
            }
        };
        this.updateOptions |= 0x10;
        return this;
    }

    @VisibleForTesting
    public TBItemButton setWidth(int width) {
        return this.setLayout(width, 0, 2, 8);
    }

    TBItemButton setLayout(int width, int widthFlags, int margin, int border) {
        if (width < 0) {
            width = 0;
        }
        if (margin < 0) {
            margin = 0;
        }
        if (border < 0) {
            border = 0;
        }
        int newLayout = width & 0xFFF;
        newLayout |= widthFlags;
        newLayout |= NSTLibrary.margin2mask((byte)margin);
        if (this.myLayoutBits != (newLayout |= NSTLibrary.border2mask((byte)border))) {
            this.myLayoutBits = newLayout;
            this.updateOptions |= 1;
        }
        return this;
    }

    @VisibleForTesting
    public void setToggle() {
        this._setFlag(8, true);
    }

    void setColored() {
        this._setFlag(4, true);
    }

    void setSelected(boolean isSelected) {
        this._setFlag(2, isSelected);
    }

    void setDisabled(boolean isDisabled) {
        this._setFlag(1, isDisabled);
    }

    TBItemButton setTransparentBg() {
        return this._setFlag(16, true);
    }

    private TBItemButton _setFlag(int nstLibFlag, boolean val) {
        int flags = TBItemButton._applyFlag(this.myFlags, val, nstLibFlag);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.updateOptions |= 2;
        }
        return this;
    }

    void updateLater(boolean force) {
        if (!(force || this.myIsVisible && this.updateOptions != 0 && this.myNativePeer != ID.NIL)) {
            return;
        }
        if (this.rasterPromise != null && !this.rasterPromise.isDone()) {
            this.rasterPromise.cancel();
        }
        this.rasterPromise = new AsyncPromise();
        this.rasterPromise.onSuccess(raster -> {
            int updateOptions = this.updateOptions;
            String text2 = (updateOptions & 4) != 0 ? this.myText : null;
            String hint = (updateOptions & 4) != 0 ? this.myHint : null;
            NSTLibrary.Action callback = (updateOptions & 0x10) != 0 ? this.nativeCallback : null;
            int validFlags = this._validateFlags();
            int isHintDisabled = this.myIsHintDisabled ? 1 : 0;
            int layoutBits = this.myLayoutBits;
            this.updateOptions = 0;
            TBItemButton tBItemButton = this;
            synchronized (tBItemButton) {
                if (this.myNativePeer.equals((Object)ID.NIL)) {
                    return;
                }
                NST.updateButton(this.myNativePeer, updateOptions, layoutBits, validFlags, text2, hint, isHintDisabled, (Pair<Pointer, Dimension>)raster, callback);
            }
        });
        ourExecutor.execute(() -> {
            Icon icon2;
            long startNs;
            if (this.originIcon == null || !force && (this.updateOptions & 8) == 0) {
                if (TEST_DELAY_MS > 0) {
                    TBItemButton.waitTheTestDelay();
                }
                this.rasterPromise.setResult(null);
                return;
            }
            long l = startNs = this.actionStats == null ? 0L : System.nanoTime();
            if (TEST_DELAY_MS > 0) {
                TBItemButton.waitTheTestDelay();
            }
            if ((icon2 = this.getDarkIcon(this.originIcon)) != null && this.isGetDisabledIconNeeded) {
                icon2 = IconLoader.getDisabledIcon((Icon)icon2);
            }
            Pair<Pointer, Dimension> raster = NST.get4ByteRGBARaster(icon2);
            if (this.actionStats != null && raster != null) {
                ++this.actionStats.iconUpdateIconRasterCount;
                this.actionStats.iconRenderingDurationNs += System.nanoTime() - startNs;
            }
            this.rasterPromise.setResult(raster);
        });
    }

    private static void waitTheTestDelay() {
        if (TEST_DELAY_MS <= 0) {
            return;
        }
        ProgressIndicator progress = Objects.requireNonNull(ProgressIndicatorProvider.getGlobalProgressIndicator());
        long start2 = System.currentTimeMillis();
        while (true) {
            progress.checkCanceled();
            if (System.currentTimeMillis() - start2 > (long)TEST_DELAY_MS) break;
            TimeoutUtil.sleep((long)1L);
        }
    }

    @Override
    protected ID _createNativePeer() {
        if (this.originIcon != null && this.rasterPromise == null) {
            this.updateLater(true);
        }
        ID result2 = NST.createButton(this.getUid(), this.myLayoutBits, this._validateFlags(), this.myText, this.myHint, this.myIsHintDisabled ? 1 : 0, this.rasterPromise == null || !this.rasterPromise.isSucceeded() ? null : (Pair)this.rasterPromise.get(), this.nativeCallback);
        if (this.myHasArrowIcon) {
            NST.setArrowImage(result2, AllIcons.Mac.Touchbar.PopoverArrow);
        }
        return result2;
    }

    private int _validateFlags() {
        int flags = this.myFlags;
        if ((flags & 4) != 0 && (flags & 1) != 0) {
            return flags & 0xFFFFFFFB;
        }
        return flags;
    }

    private static int _applyFlag(int src, boolean include, int flag) {
        return include ? src | flag : src & ~flag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "presentation";
        objectArray2[1] = "com/intellij/ui/mac/touchbar/TBItemButton";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setIconFromPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setIconAndTextFromPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

