/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ObjectUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PopupImplUtil {
    private static final Logger LOG = Logger.getInstance(PopupImplUtil.class);

    private PopupImplUtil() {
    }

    public static AccessToken prohibitFocusEventsInHandleSelect() {
        final boolean[] insideOnChosen = new boolean[]{true};
        final AccessToken token = ProhibitAWTEvents.startFiltered("Popup.handleSelect", e -> {
            if (!(e instanceof WindowEvent) || e.getID() != 205 || !(((WindowEvent)e).getWindow() instanceof JDialog)) {
                return null;
            }
            Throwable throwable = new Throwable("Showing dialogs in PopupStep.onChosen can result in focus issues. Please put the handler into BaseStep.doFinalStep or PopupStep.getFinalRunnable.\n  " + String.valueOf(e));
            ApplicationManager.getApplication().invokeLater(() -> LOG.error(throwable), ModalityState.any(), __ -> !insideOnChosen[0]);
            return null;
        });
        return new AccessToken(){

            public void finish() {
                insideOnChosen[0] = false;
                token.finish();
            }
        };
    }

    public static void uiSnapshotForList(@NotNull JList<?> list2, @NotNull DataSink sink) {
        if (list2 == null) {
            PopupImplUtil.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            PopupImplUtil.$$$reportNull$$$0(1);
        }
        PopupImplUtil.uiSnapshotForList(list2, sink, false);
    }

    public static void uiSnapshotForList(@NotNull JList<?> list2, @NotNull DataSink sink, boolean lazy) {
        if (list2 == null) {
            PopupImplUtil.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            PopupImplUtil.$$$reportNull$$$0(3);
        }
        int index = list2.getSelectedIndex();
        if (lazy) {
            sink.lazy(PlatformCoreDataKeys.SELECTED_ITEM, () -> index > -1 ? list2.getSelectedValue() : ObjectUtils.NULL);
        } else {
            sink.set(PlatformCoreDataKeys.SELECTED_ITEM, index > -1 ? list2.getSelectedValue() : ObjectUtils.NULL);
        }
        Object[] values2 = list2.getSelectedValues();
        for (int i2 = 0; i2 < values2.length; ++i2) {
            if (values2[i2] != null) continue;
            values2[i2] = ObjectUtils.NULL;
        }
        if (lazy) {
            sink.lazy(PlatformCoreDataKeys.SELECTED_ITEMS, () -> values2);
        } else {
            sink.set(PlatformCoreDataKeys.SELECTED_ITEMS, (Object)values2);
        }
    }

    @Nullable
    public static Component getClickSourceFromLastInputEvent() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            return SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            return keyEvent.getComponent();
        }
        return null;
    }

    @NotNull
    public static Dimension getPopupSize(@NotNull JBPopup popup2) {
        String dimensionKey;
        if (popup2 == null) {
            PopupImplUtil.$$$reportNull$$$0(4);
        }
        Dimension size2 = null;
        if (popup2 instanceof AbstractPopup && (dimensionKey = ((AbstractPopup)popup2).getDimensionServiceKey()) != null) {
            size2 = DimensionService.getInstance().getSize(dimensionKey);
        }
        if (size2 == null) {
            size2 = popup2.getContent().getPreferredSize();
        }
        Dimension dimension = size2;
        if (dimension == null) {
            PopupImplUtil.$$$reportNull$$$0(5);
        }
        return dimension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/util/PopupImplUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/util/PopupImplUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uiSnapshotForList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPopupSize";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

