/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.ide.SmartSelectProvider;
import com.intellij.ui.tree.TreePathUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TreeSmartSelectProvider
implements SmartSelectProvider<JTree> {
    public void increaseSelection(JTree tree2) {
        TreePath anchor = TreeSmartSelectProvider.getAnchor(tree2);
        if (anchor == null) {
            return;
        }
        for (TreePath parent = anchor; parent != null; parent = parent.getParentPath()) {
            if (TreeSmartSelectProvider.acceptDescendants(tree2, parent, path -> !tree2.isPathSelected((TreePath)path), tree2::addSelectionPaths)) {
                TreeSmartSelectProvider.setAnchor(tree2, anchor);
                return;
            }
            if (tree2.isPathSelected(parent)) continue;
            if (!tree2.isRootVisible() && parent.getParentPath() == null) {
                return;
            }
            tree2.addSelectionPath(parent);
            TreeSmartSelectProvider.setAnchor(tree2, anchor);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void decreaseSelection(JTree tree2) {
        TreePath lower;
        TreePath anchor;
        block7: {
            anchor = TreeSmartSelectProvider.getAnchor(tree2);
            if (anchor == null) {
                return;
            }
            if (!tree2.isPathSelected(anchor)) {
                return;
            }
            lower = anchor;
            TreePath upper = anchor.getParentPath();
            while (true) {
                if (upper == null) {
                    return;
                }
                if (!TreeSmartSelectProvider.testDescendants(tree2, upper, tree2::isPathSelected)) break block7;
                if (!tree2.isPathSelected(upper)) break;
                lower = upper;
                upper = upper.getParentPath();
            }
            TreePath except = lower;
            if (TreeSmartSelectProvider.acceptDescendants(tree2, upper, path -> tree2.isPathSelected((TreePath)path) && !except.isDescendant((TreePath)path), tree2::removeSelectionPaths)) {
                TreeSmartSelectProvider.setAnchor(tree2, anchor);
                return;
            }
        }
        if (lower != anchor) {
            tree2.removeSelectionPath(lower);
            TreeSmartSelectProvider.setAnchor(tree2, anchor);
            return;
        }
        if (TreeSmartSelectProvider.acceptDescendants(tree2, lower, tree2::isPathSelected, tree2::removeSelectionPaths)) {
            TreeSmartSelectProvider.setAnchor(tree2, anchor);
        }
    }

    @Nullable
    public JTree getSource(DataContext context2) {
        Component component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context2);
        JTree tree2 = component2 instanceof JTree ? (JTree)component2 : null;
        return tree2 == null || 1 == tree2.getSelectionModel().getSelectionMode() ? null : tree2;
    }

    public boolean canIncreaseSelection(JTree tree2) {
        return tree2 != null && 1 != tree2.getSelectionModel().getSelectionMode();
    }

    public boolean canDecreaseSelection(JTree tree2) {
        return tree2 != null && tree2.getSelectionModel().getSelectionCount() > 1;
    }

    @Nullable
    private static TreePath getAnchor(@Nullable JTree tree2) {
        TreePath anchor;
        if (tree2 == null || 1 == tree2.getSelectionModel().getSelectionMode()) {
            return null;
        }
        for (anchor = tree2.getAnchorSelectionPath(); anchor != null && tree2.getRowForPath(anchor) < 0; anchor = anchor.getParentPath()) {
        }
        return anchor;
    }

    private static void setAnchor(@NotNull JTree tree2, @NotNull TreePath path) {
        if (tree2 == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(1);
        }
        tree2.setAnchorSelectionPath(path);
    }

    private static boolean testDescendants(@NotNull JTree tree2, @NotNull TreePath parent, @NotNull Predicate<? super TreePath> predicate) {
        TreePath path;
        if (tree2 == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(3);
        }
        if (predicate == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(4);
        }
        boolean tested = false;
        for (int row2 = Math.max(0, 1 + tree2.getRowForPath(parent)); row2 < tree2.getRowCount() && parent.isDescendant(path = tree2.getPathForRow(row2)); ++row2) {
            if (!predicate.test(path)) {
                return false;
            }
            tested = true;
        }
        return tested;
    }

    private static boolean acceptDescendants(@NotNull JTree tree2, @NotNull TreePath parent, @NotNull Predicate<? super TreePath> predicate, @NotNull Consumer<? super TreePath[]> consumer) {
        if (tree2 == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(6);
        }
        if (predicate == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            TreeSmartSelectProvider.$$$reportNull$$$0(8);
        }
        ArrayList<TreePath> list2 = new ArrayList<TreePath>();
        TreeSmartSelectProvider.testDescendants(tree2, parent, child -> {
            if (predicate.test((TreePath)child)) {
                list2.add((TreePath)child);
            }
            return true;
        });
        if (list2.isEmpty()) {
            return false;
        }
        consumer.accept((TreePath[])TreePathUtil.toTreePathArray(list2));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/TreeSmartSelectProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setAnchor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "testDescendants";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptDescendants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

