/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class NettyUtil {
    public static final int MAX_CONTENT_LENGTH;
    public static final int DEFAULT_CONNECT_ATTEMPT_COUNT = 20;
    public static final int MIN_START_TIME = 100;

    public static void logAndClose(@NotNull Throwable error2, @NotNull Logger log, @NotNull Channel channel) {
        if (error2 == null) {
            NettyUtil.$$$reportNull$$$0(0);
        }
        if (log == null) {
            NettyUtil.$$$reportNull$$$0(1);
        }
        if (channel == null) {
            NettyUtil.$$$reportNull$$$0(2);
        }
        try {
            if (error2 instanceof ConnectException) {
                log.debug(error2);
            } else {
                NettyUtil.log(error2, log);
            }
        }
        finally {
            log.info("Channel will be closed due to error");
            channel.close();
        }
    }

    public static void log(@NotNull Throwable throwable, @NotNull Logger log) {
        String message;
        if (throwable == null) {
            NettyUtil.$$$reportNull$$$0(3);
        }
        if (log == null) {
            NettyUtil.$$$reportNull$$$0(4);
        }
        if ((message = throwable.getMessage()) == null) {
            log.error(throwable);
            return;
        }
        if (message.startsWith("Connection reset")) {
            return;
        }
        if (NettyUtil.isAsWarning(message, throwable)) {
            log.warn(throwable);
        } else {
            log.error(throwable);
        }
    }

    private static boolean isAsWarning(@NlsSafe @NotNull String message, @NotNull Throwable throwable) {
        if (message == null) {
            NettyUtil.$$$reportNull$$$0(5);
        }
        if (throwable == null) {
            NettyUtil.$$$reportNull$$$0(6);
        }
        if (message.equals("Operation timed out") || message.equals("Connection timed out")) {
            return true;
        }
        if (throwable instanceof IOException) {
            return throwable instanceof BindException || message.equals("An established connection was aborted by the software in your host machine") || message.equals("An existing connection was forcibly closed by the remote host") || message.equals("\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0445\u043e\u0441\u0442 \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0440\u0430\u0437\u043e\u0440\u0432\u0430\u043b \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
        }
        return throwable instanceof ChannelException && message.startsWith("Failed to bind to: ");
    }

    @NotNull
    public static Bootstrap nioClientBootstrap(@NotNull EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup == null) {
            NettyUtil.$$$reportNull$$$0(7);
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        if (bootstrap2 == null) {
            NettyUtil.$$$reportNull$$$0(8);
        }
        return bootstrap2;
    }

    public static void addHttpServerCodec(@NotNull ChannelPipeline pipeline) {
        if (pipeline == null) {
            NettyUtil.$$$reportNull$$$0(9);
        }
        pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("httpRequestDecoder", (ChannelHandler)new HttpRequestDecoder(16384, 16384, 8192));
        pipeline.addLast("httpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(MAX_CONTENT_LENGTH));
        if (pipeline.get(ChunkedWriteHandler.class) == null) {
            pipeline.addLast("chunkedWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
        }
        pipeline.addLast("corsHandler", (ChannelHandler)new CorsHandler(CorsConfigBuilder.forAnyOrigin().shortCircuit().allowCredentials().allowNullOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.PATCH}).allowedRequestHeaders(new String[]{"origin", "accept", "authorization", "content-type", "x-ijt", "x-requested-with"}).build()));
    }

    @ApiStatus.Internal
    @NotNull
    public static FullHttpRequest ensureRequestUriIsRelative(@NotNull FullHttpRequest httpRequest) {
        block5: {
            FullHttpRequest fullHttpRequest;
            if (httpRequest == null) {
                NettyUtil.$$$reportNull$$$0(10);
            }
            try {
                URI uri = new URI(httpRequest.uri());
                if (uri.getHost() == null) break block5;
                URI patchedRequestURI = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
                FullHttpRequest httpRequestCopy = httpRequest.copy();
                httpRequestCopy.setUri(patchedRequestURI.toString());
                fullHttpRequest = httpRequestCopy;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (fullHttpRequest == null) {
                NettyUtil.$$$reportNull$$$0(11);
            }
            return fullHttpRequest;
        }
        FullHttpRequest fullHttpRequest = httpRequest;
        if (fullHttpRequest == null) {
            NettyUtil.$$$reportNull$$$0(12);
        }
        return fullHttpRequest;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public static void awaitQuiescenceOfGlobalEventExecutor(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            NettyUtil.$$$reportNull$$$0(13);
        }
        try {
            void unit;
            @NotNull GlobalEventExecutor executor = GlobalEventExecutor.INSTANCE;
            executor.awaitInactivity(timeout, (TimeUnit)unit);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static {
        int maxContentLength = 180;
        try {
            maxContentLength = Integer.parseInt(System.getProperty("ide.netty.max.frame.size.in.mb", "180")) * 1024 * 1024;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        MAX_CONTENT_LENGTH = maxContentLength;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventLoopGroup";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/NettyUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipeline";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpRequest";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/NettyUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nioClientBootstrap";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureRequestUriIsRelative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logAndClose";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAsWarning";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nioClientBootstrap";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addHttpServerCodec";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureRequestUriIsRelative";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "awaitQuiescenceOfGlobalEventExecutor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 12 -> new IllegalStateException(string);
        };
    }
}

