/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.signer.KeystoreUtils;
import org.jetbrains.zip.signer.signer.KeystoreUtilsKt;
import org.jetbrains.zip.signer.signer.PrivateKeyUtils;
import org.jetbrains.zip.signer.signer.SignerInfo;
import org.jetbrains.zip.signer.utils.SecurityUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0007J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0007J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00072\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/zip/signer/signer/SignerInfoLoader;", "", "<init>", "()V", "loadSignerInfoFromKeystore", "Lorg/jetbrains/zip/signer/signer/SignerInfo;", "file", "Ljava/io/File;", "password", "", "keyPassword", "keystoreKeyAlias", "", "keystoreType", "keystoreProviderName", "loadSignerInfoFromText", "privateKey", "certificate", "privateKeyPassword", "loadSignerInfoFromFiles", "privateKeyFile", "certificateFile", "lib"})
public final class SignerInfoLoader {
    @NotNull
    public static final SignerInfoLoader INSTANCE = new SignerInfoLoader();

    private SignerInfoLoader() {
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file2, @NotNull char[] password, @Nullable char[] keyPassword, @Nullable String keystoreKeyAlias, @Nullable String keystoreType, @Nullable String keystoreProviderName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        KeyStore keyStore = KeystoreUtils.INSTANCE.getKeyStore(keystoreType, keystoreProviderName);
        InputStream inputStream = new FileInputStream(file2);
        int n = 8192;
        keyStore.load(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n), password);
        char[] cArray = keyPassword;
        if (keyPassword == null) {
            cArray = password;
        }
        return KeystoreUtilsKt.getSignerInfo(keyStore, cArray, keystoreKeyAlias);
    }

    public static /* synthetic */ SignerInfo loadSignerInfoFromKeystore$default(SignerInfoLoader signerInfoLoader, File file2, char[] cArray, char[] cArray2, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            cArray2 = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return signerInfoLoader.loadSignerInfoFromKeystore(file2, cArray, cArray2, string, string2, string3);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromText(@NotNull String privateKey, @Nullable String certificate, @Nullable char[] privateKeyPassword) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        SecurityUtils.INSTANCE.addBouncyCastleProviderIfMissing();
        PEMKeyPair keyPair = PrivateKeyUtils.INSTANCE.loadKeyPair(privateKey, privateKeyPassword);
        String string = certificate;
        List certificates = string != null ? CertificateUtils.loadCertificates(string) : CollectionsKt.listOf((Object)CertificateUtils.INSTANCE.generateDummyCertificate(keyPair));
        return new SignerInfo(certificates, PrivateKeyUtils.loadPrivateKey(privateKey, privateKeyPassword));
    }

    public static /* synthetic */ SignerInfo loadSignerInfoFromText$default(SignerInfoLoader signerInfoLoader, String string, String string2, char[] cArray, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            cArray = null;
        }
        return signerInfoLoader.loadSignerInfoFromText(string, string2, cArray);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromFiles(@NotNull File privateKeyFile, @Nullable File certificateFile, @Nullable char[] privateKeyPassword) {
        Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
        SecurityUtils.INSTANCE.addBouncyCastleProviderIfMissing();
        PEMKeyPair keyPair = PrivateKeyUtils.INSTANCE.loadKeyPair(privateKeyFile, privateKeyPassword);
        File file2 = certificateFile;
        List certificates = file2 != null ? CertificateUtils.loadCertificatesFromFile(file2) : CollectionsKt.listOf((Object)CertificateUtils.INSTANCE.generateDummyCertificate(keyPair));
        PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(keyPair.getPrivateKeyInfo());
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivateKey(...)");
        return new SignerInfo(certificates, privateKey);
    }

    public static /* synthetic */ SignerInfo loadSignerInfoFromFiles$default(SignerInfoLoader signerInfoLoader, File file2, File file3, char[] cArray, int n, Object object) {
        if ((n & 2) != 0) {
            file3 = null;
        }
        if ((n & 4) != 0) {
            cArray = null;
        }
        return signerInfoLoader.loadSignerInfoFromFiles(file2, file3, cArray);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file2, @NotNull char[] password, @Nullable char[] keyPassword, @Nullable String keystoreKeyAlias, @Nullable String keystoreType) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return SignerInfoLoader.loadSignerInfoFromKeystore$default(this, file2, password, keyPassword, keystoreKeyAlias, keystoreType, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file2, @NotNull char[] password, @Nullable char[] keyPassword, @Nullable String keystoreKeyAlias) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return SignerInfoLoader.loadSignerInfoFromKeystore$default(this, file2, password, keyPassword, keystoreKeyAlias, null, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file2, @NotNull char[] password, @Nullable char[] keyPassword) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return SignerInfoLoader.loadSignerInfoFromKeystore$default(this, file2, password, keyPassword, null, null, null, 56, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file2, @NotNull char[] password) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return SignerInfoLoader.loadSignerInfoFromKeystore$default(this, file2, password, null, null, null, null, 60, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromText(@NotNull String privateKey, @Nullable String certificate) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return SignerInfoLoader.loadSignerInfoFromText$default(this, privateKey, certificate, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromText(@NotNull String privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return SignerInfoLoader.loadSignerInfoFromText$default(this, privateKey, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromFiles(@NotNull File privateKeyFile, @Nullable File certificateFile) {
        Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
        return SignerInfoLoader.loadSignerInfoFromFiles$default(this, privateKeyFile, certificateFile, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromFiles(@NotNull File privateKeyFile) {
        Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
        return SignerInfoLoader.loadSignerInfoFromFiles$default(this, privateKeyFile, null, null, 6, null);
    }
}

