/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClientProperty {
    private static final Key<Map<Key<?>, ContainerListener>> RECURSIVE_LISTENERS = Key.create((String)"ClientProperty.recursiveListeners");

    private ClientProperty() {
    }

    public static <T> void put(@NotNull JComponent component, @NotNull Key<T> key, @Nullable T value) {
        if (component == null) {
            ClientProperty.$$$reportNull$$$0(0);
        }
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(1);
        }
        component.putClientProperty(key, value);
    }

    public static <T> boolean put(@NotNull Window window, @NotNull Key<T> key, @Nullable T value) {
        if (window == null) {
            ClientProperty.$$$reportNull$$$0(2);
        }
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(3);
        }
        return ClientProperty.put(window, key, value);
    }

    public static <T> void remove(@NotNull JComponent component, @NotNull Key<T> key) {
        if (component == null) {
            ClientProperty.$$$reportNull$$$0(4);
        }
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(5);
        }
        ClientProperty.put(component, key, null);
    }

    public static <T> void remove(@NotNull Window window, @NotNull Key<T> key) {
        if (window == null) {
            ClientProperty.$$$reportNull$$$0(6);
        }
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(7);
        }
        ClientProperty.put(window, key, null);
    }

    @Contract(value="null,_,_ -> false")
    public static boolean put(@Nullable Window window, @NotNull @NonNls Object key, @Nullable Object value) {
        JComponent holder;
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(8);
        }
        if ((holder = ClientProperty.getPropertiesHolder(window)) != null) {
            holder.putClientProperty(key, value);
        }
        return holder != null;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static <T> void putRecursive(@NotNull JComponent component, final @NotNull Key<T> key, final @Nullable T value) {
        if (component == null) {
            ClientProperty.$$$reportNull$$$0(9);
        }
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(10);
        }
        ContainerAdapter listener2 = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Container container = e.getContainer();
                if (container instanceof JComponent) {
                    ClientProperty.putRecursive((JComponent)container, key, value);
                }
            }
        };
        LinkedList<JComponent> toProcess = new LinkedList<JComponent>();
        toProcess.add(component);
        while (!toProcess.isEmpty()) {
            ContainerListener existingListener;
            JComponent current = (JComponent)toProcess.poll();
            Map<Key<?>, ContainerListener> listeners = ClientProperty.get((Component)current, RECURSIVE_LISTENERS);
            if (listeners == null) {
                listeners = new HashMap();
                ClientProperty.put(current, RECURSIVE_LISTENERS, listeners);
            }
            if ((existingListener = listeners.get(key)) != null) {
                current.removeContainerListener(existingListener);
            }
            ClientProperty.put(current, key, value);
            listeners.put(key, listener2);
            current.addContainerListener(listener2);
            for (Component child : current.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                toProcess.add((JComponent)child);
            }
        }
    }

    @ApiStatus.Internal
    public static <T> void removeRecursive(@NotNull JComponent component, @NotNull Key<T> key) {
        ContainerListener existingListener;
        Map<Key<?>, ContainerListener> listeners;
        if (component == null) {
            ClientProperty.$$$reportNull$$$0(11);
        }
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(12);
        }
        if ((listeners = ClientProperty.get((Component)component, RECURSIVE_LISTENERS)) != null && (existingListener = listeners.remove(key)) != null) {
            component.removeContainerListener(existingListener);
            if (listeners.isEmpty()) {
                ClientProperty.put(component, RECURSIVE_LISTENERS, null);
            }
        }
        ClientProperty.put(component, key, null);
    }

    @Contract(value="null -> null")
    @Nullable
    private static JComponent getPropertiesHolder(@Nullable Component component) {
        if (component instanceof JComponent) {
            return (JComponent)component;
        }
        if (component instanceof Window && component instanceof RootPaneContainer) {
            RootPaneContainer container = (RootPaneContainer)((Object)component);
            return container.getRootPane();
        }
        return null;
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static Object get(@Nullable Component component, @NotNull @NonNls Object key) {
        JComponent holder;
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(13);
        }
        return (holder = ClientProperty.getPropertiesHolder(component)) == null ? null : holder.getClientProperty(key);
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static Object findInHierarchy(@Nullable Component component, @NotNull @NonNls Object key) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(14);
        }
        while (component != null) {
            Object value = ClientProperty.get(component, key);
            if (value != null) {
                return value;
            }
            if (component instanceof Window) break;
            component = component.getParent();
        }
        return null;
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static <T> T get(@Nullable Component component, @NotNull Key<T> key) {
        Object value;
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(15);
        }
        return (T)((value = ClientProperty.get(component, key)) != null ? value : null);
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static <T> T findInHierarchy(@Nullable Component component, @NotNull Key<T> key) {
        Object value;
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(16);
        }
        return (T)((value = ClientProperty.findInHierarchy(component, key)) != null ? value : null);
    }

    public static boolean isSet(@Nullable Component component, @NotNull @NonNls Object key) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(17);
        }
        return null != ClientProperty.get(component, key);
    }

    public static boolean isSetInHierarchy(@Nullable Component component, @NotNull @NonNls Object key) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(18);
        }
        return null != ClientProperty.findInHierarchy(component, key);
    }

    public static boolean isSet(@Nullable Component component, @NotNull @NonNls Object key, @NotNull Object value) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(19);
        }
        if (value == null) {
            ClientProperty.$$$reportNull$$$0(20);
        }
        return value.equals(ClientProperty.get(component, key));
    }

    public static boolean isSetInHierarchy(@Nullable Component component, @NotNull @NonNls Object key, @NotNull Object value) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(21);
        }
        if (value == null) {
            ClientProperty.$$$reportNull$$$0(22);
        }
        return value.equals(ClientProperty.findInHierarchy(component, key));
    }

    public static boolean isTrue(@Nullable Component component, @NotNull Object key) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(23);
        }
        return ClientProperty.isSet(component, key, Boolean.TRUE);
    }

    public static boolean isTrueInHierarchy(@Nullable Component component, @NotNull Object key) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(24);
        }
        return ClientProperty.isSetInHierarchy(component, key, Boolean.TRUE);
    }

    public static boolean isFalse(@Nullable Component component, @NotNull Object key) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(25);
        }
        return ClientProperty.isSet(component, key, Boolean.FALSE);
    }

    public static boolean isFalseInHierarchy(@Nullable Component component, @NotNull Object key) {
        if (key == null) {
            ClientProperty.$$$reportNull$$$0(26);
        }
        return ClientProperty.isSetInHierarchy(component, key, Boolean.FALSE);
    }

    @NotNull
    public static Map<Object, Object> getAllClientProperties(Object component) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        if (component instanceof RootPaneContainer) {
            component = ((RootPaneContainer)component).getRootPane();
        }
        if (component instanceof JComponent) {
            Map<Object, Object> map2;
            Object table;
            Method method;
            block13: {
                block12: {
                    method = ReflectionUtil.getDeclaredMethod(JComponent.class, (String)"getClientProperties", (Class[])new Class[0]);
                    if (method != null) break block12;
                    Map<Object, Object> map3 = Collections.emptyMap();
                    if (map3 == null) {
                        ClientProperty.$$$reportNull$$$0(27);
                    }
                    return map3;
                }
                method.setAccessible(true);
                table = method.invoke(component, new Object[0]);
                method = ReflectionUtil.getDeclaredMethod(table.getClass(), (String)"getKeys", (Class[])new Class[]{Object[].class});
                if (method != null) break block13;
                Map<Object, Object> map4 = Collections.emptyMap();
                if (map4 == null) {
                    ClientProperty.$$$reportNull$$$0(28);
                }
                return map4;
            }
            try {
                method.setAccessible(true);
                Object arr = method.invoke(table, new Object[1]);
                if (arr instanceof Object[]) {
                    for (Object key : (Object[])arr) {
                        map.put(key, ((JComponent)component).getClientProperty(key));
                    }
                }
                map2 = Collections.unmodifiableMap(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (map2 == null) {
                ClientProperty.$$$reportNull$$$0(29);
            }
            return map2;
        }
        Map<Object, Object> map5 = Collections.emptyMap();
        if (map5 == null) {
            ClientProperty.$$$reportNull$$$0(30);
        }
        return map5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 27, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ClientProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ClientProperty";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClientProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putRecursive";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeRecursive";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findInHierarchy";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSet";
                break;
            }
            case 18: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSetInHierarchy";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isTrue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isTrueInHierarchy";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isFalse";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFalseInHierarchy";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 27, 28, 29, 30 -> new IllegalStateException(string);
        };
    }
}

