/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.border;

import com.intellij.ui.JBColor;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UpdateScaleHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomLineBorder
implements Border {
    private final Color myColor;
    private final Insets myUnscaledInsets;
    private final Insets myInsets;
    private final LazyInitializer.LazyValue<UpdateScaleHelper> myUpdateScaleHelper;

    private CustomLineBorder(@Nullable Color color, @NotNull Insets insets, boolean preScaled) {
        if (insets == null) {
            CustomLineBorder.$$$reportNull$$$0(0);
        }
        this.myInsets = new Insets(0, 0, 0, 0);
        this.myUpdateScaleHelper = LazyInitializer.create(UpdateScaleHelper::new);
        this.myColor = color;
        this.myUnscaledInsets = preScaled ? new Insets(JBUI.unscale(insets.top), JBUI.unscale(insets.left), JBUI.unscale(insets.bottom), JBUI.unscale(insets.right)) : insets;
        this.updateInsets();
    }

    public CustomLineBorder(@Nullable Color color, @NotNull Insets insets) {
        if (insets == null) {
            CustomLineBorder.$$$reportNull$$$0(1);
        }
        this(color, insets, true);
    }

    public CustomLineBorder(@Nullable Color color, int top, int left, int bottom, int right) {
        this(color, new Insets(top, left, bottom, right), false);
    }

    public CustomLineBorder(@NotNull Insets insets) {
        if (insets == null) {
            CustomLineBorder.$$$reportNull$$$0(2);
        }
        this(null, insets);
    }

    public CustomLineBorder(int top, int left, int bottom, int right) {
        this(null, new Insets(top, left, bottom, right), false);
    }

    private void updateInsets() {
        this.myInsets.top = JBUI.scale(this.myUnscaledInsets.top);
        this.myInsets.left = JBUI.scale(this.myUnscaledInsets.left);
        this.myInsets.bottom = JBUI.scale(this.myUnscaledInsets.bottom);
        this.myInsets.right = JBUI.scale(this.myUnscaledInsets.right);
    }

    private void updateInsetsIfNeeded() {
        ((UpdateScaleHelper)this.myUpdateScaleHelper.get()).saveScaleAndRunIfChanged(() -> this.updateInsets());
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.updateInsetsIfNeeded();
        Color oldColor = g.getColor();
        g.setColor(this.getColor());
        if (this.myInsets.left > 0) {
            g.fillRect(x, y, this.myInsets.left, h);
        }
        if (this.myInsets.bottom > 0) {
            g.fillRect(x, y + h - this.myInsets.bottom, w, this.myInsets.bottom);
        }
        if (this.myInsets.right > 0) {
            g.fillRect(x + w - this.myInsets.right, y, this.myInsets.right, h);
        }
        if (this.myInsets.top > 0) {
            g.fillRect(x, y, w, this.myInsets.top);
        }
        g.setColor(oldColor);
    }

    protected Color getColor() {
        return this.myColor == null ? JBColor.border() : this.myColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        this.updateInsetsIfNeeded();
        return (Insets)this.myInsets.clone();
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "com/intellij/ui/border/CustomLineBorder", "<init>"));
    }
}

