/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.jetbrains.AccessibleAnnouncer;
import com.jetbrains.JBR;
import java.awt.KeyboardFocusManager;
import javax.accessibility.Accessible;
import org.jetbrains.annotations.Nullable;

public final class AccessibleAnnouncerUtil {
    private static final AccessibleAnnouncer announcer = JBR.getAccessibleAnnouncer();

    private AccessibleAnnouncerUtil() {
    }

    public static void announce(@Nullable Accessible a, String str, boolean interruptCurrentOutput) {
        if (announcer == null) {
            return;
        }
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (focusManager == null || focusManager.getActiveWindow() == null) {
            return;
        }
        if (interruptCurrentOutput) {
            announcer.announce(a, str, 1);
            return;
        }
        announcer.announce(a, str, 0);
    }

    public static boolean isAnnouncingAvailable() {
        return ScreenReader.isActive() && JBR.isAccessibleAnnouncerSupported() && Registry.is((String)"ide.accessibility.announcing.notifications.available", (boolean)false);
    }
}

