/*
 * Decompiled with CFR 0.152.
 */
package libraries.io;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.io.ThreadUtil;
import libraries.klogging.KLogging;
import libraries.klogging.MDC;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Llibraries/io/DaemonThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "myPrefix", "", "<init>", "(Ljava/lang/String;)V", "myThreadId", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "Companion", "libraries-io"})
public final class DaemonThreadFactory
implements ThreadFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String myPrefix;
    @NotNull
    private final AtomicInteger myThreadId;

    public DaemonThreadFactory(@NotNull String myPrefix) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)myPrefix, (String)"myPrefix");
            this.myPrefix = myPrefix;
            this.myThreadId = new AtomicInteger();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) break block0;
            securityManager.checkPermission(ThreadUtil.INSTANCE.getModifyThreadGroupPermission());
        }
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Thread result2 = new Thread(() -> DaemonThreadFactory.newThread$lambda$0(r));
        result2.setName(this.myPrefix + "-" + this.myThreadId.incrementAndGet());
        result2.setDaemon(true);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void newThread$lambda$0(Runnable $r) {
        Intrinsics.checkNotNullParameter((Object)$r, (String)"$r");
        MDC.INSTANCE.clear();
        try {
            $r.run();
        }
        catch (Throwable t) {
            Companion.getLogger().warn(t, "Exception from pooled thread. " + t.getMessage());
            throw t;
        }
        finally {
            MDC.INSTANCE.clear();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Llibraries/io/DaemonThreadFactory$Companion;", "Llibraries/klogging/KLogging;", "<init>", "()V", "libraries-io"})
    public static final class Companion
    extends KLogging {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

