/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BG\u0012\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0012\u001a\u00020\u0007H\u0016J$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\nH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lruntime/reactive/MappedMutableProperty;", "T", "Lruntime/reactive/MutableProperty;", "changesSource", "Lruntime/reactive/Source;", "forceNotifyFn", "Lkotlin/Function0;", "", "getter", "setter", "Lkotlin/Function1;", "<init>", "(Lruntime/reactive/Source;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "forceNotify", "forEach", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "sink", "changes", "getChanges", "()Lruntime/reactive/Source;", "platform-ui"})
final class MappedMutableProperty<T>
implements MutableProperty<T> {
    @Nullable
    private final Source<?> changesSource;
    @Nullable
    private final Function0<Unit> forceNotifyFn;
    @NotNull
    private final Function0<T> getter;
    @NotNull
    private final Function1<T, Unit> setter;
    @NotNull
    private final Source<T> changes;

    public MappedMutableProperty(@Nullable Source<?> changesSource, @Nullable Function0<Unit> forceNotifyFn, @NotNull Function0<? extends T> getter2, @NotNull Function1<? super T, Unit> setter2) {
        Intrinsics.checkNotNullParameter(getter2, (String)"getter");
        Intrinsics.checkNotNullParameter(setter2, (String)"setter");
        this.changesSource = changesSource;
        this.forceNotifyFn = forceNotifyFn;
        this.getter = getter2;
        this.setter = setter2;
        this.changes = SourceKt.skip(this, 1);
    }

    @Override
    public T getValue() {
        return (T)this.getter.invoke();
    }

    @Override
    public void setValue(T value2) {
        this.setter.invoke(value2);
    }

    @Override
    public void forceNotify() {
        Function0<Unit> function0 = this.forceNotifyFn;
        if (function0 == null) {
            throw new IllegalStateException("You can't force notify on MappedMutableProperty without forceNotifyFn");
        }
        function0.invoke();
    }

    @Override
    public void forEach(@NotNull Lifetime lifetime, @NotNull Function1<? super T, Unit> sink) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(sink, (String)"sink");
            if (lifetime.isTerminated()) {
                return;
            }
            Ref.ObjectRef value2 = new Ref.ObjectRef();
            value2.element = this.getter.invoke();
            sink.invoke(value2.element);
            Source<?> source = this.changesSource;
            if (source == null) break block1;
            source.forEach(lifetime, arg_0 -> MappedMutableProperty.forEach$lambda$0(this, value2, sink, arg_0));
        }
    }

    @Override
    @NotNull
    public Source<T> getChanges() {
        return this.changes;
    }

    @Override
    public void forEachWithPrevious(@NotNull Lifetime lifetime, @NotNull Function2<? super T, ? super T, Unit> consume) {
        MutableProperty.DefaultImpls.forEachWithPrevious(this, lifetime, consume);
    }

    private static final Unit forEach$lambda$0(MappedMutableProperty this$0, Ref.ObjectRef $value, Function1 $sink, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$sink, (String)"$sink");
        Object newValue = this$0.getter.invoke();
        if (!Intrinsics.areEqual((Object)newValue, (Object)$value.element)) {
            $value.element = newValue;
            $sink.invoke(newValue);
        }
        return Unit.INSTANCE;
    }
}

