/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.gateway.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remoteDev.util.RemoteDevProtocolUtil;
import com.intellij.spaceport.gateway.AbstractSpaceGatewayContext;
import com.intellij.spaceport.gateway.messages.SpaceportGatewayBundle;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\n\b\u0003\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\b\u0003\u0010\u0015\u001a\u00020\u0005H\u0002J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u0005J\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ0\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u000b\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0000\u00a2\u0006\u0002\b'R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/spaceport/gateway/ui/SpaceGatewayLoginComponents;", "", "<init>", "()V", "organizationUrlPlaceholder", "", "loginPanel", "", "Lcom/intellij/ui/dsl/builder/Panel;", "bundle", "Lcom/intellij/spaceport/gateway/messages/SpaceportGatewayBundle;", "server", "isLoginActionDefault", "", "loginAction", "Lkotlin/Function1;", "disposable", "Lcom/intellij/openapi/Disposable;", "organizationUrlTextField", "Lcom/intellij/ui/components/JBTextField;", "initialText", "placeholderText", "loginButton", "Ljavax/swing/JButton;", "default", "onClick", "errorText", "Ljavax/swing/JLabel;", "error", "separator", "Ljavax/swing/JComponent;", "separator$intellij_spaceport_gateway", "buildConnectingPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "context", "Lcom/intellij/spaceport/gateway/AbstractSpaceGatewayContext;", "Lcom/intellij/openapi/util/NlsSafe;", "cancelAction", "Lkotlin/Function0;", "buildConnectingPanel$intellij_spaceport_gateway", "intellij.spaceport.gateway"})
@SourceDebugExtension(value={"SMAP\nSpaceGatewayLoginComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceGatewayLoginComponents.kt\ncom/intellij/spaceport/gateway/ui/SpaceGatewayLoginComponents\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n466#2:147\n415#2:148\n1266#3,4:149\n*S KotlinDebug\n*F\n+ 1 SpaceGatewayLoginComponents.kt\ncom/intellij/spaceport/gateway/ui/SpaceGatewayLoginComponents\n*L\n136#1:147\n136#1:148\n136#1:149,4\n*E\n"})
public final class SpaceGatewayLoginComponents {
    @NotNull
    public static final SpaceGatewayLoginComponents INSTANCE = new SpaceGatewayLoginComponents();
    @NlsSafe
    @NotNull
    private static final String organizationUrlPlaceholder = "company.jetbrains.space";

    private SpaceGatewayLoginComponents() {
    }

    public final void loginPanel(@NotNull Panel $this$loginPanel, @NotNull SpaceportGatewayBundle bundle, @Nullable String server, boolean isLoginActionDefault, @NotNull Function1<? super String, Unit> loginAction, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)$this$loginPanel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter(loginAction, (String)"loginAction");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        JBTextField serverField = SpaceGatewayLoginComponents.organizationUrlTextField$default(this, server, null, 2, null);
        Ref.BooleanRef isValidationStarted = new Ref.BooleanRef();
        ComponentValidator urlValidator = new ComponentValidator(disposable).withValidator(() -> SpaceGatewayLoginComponents.loginPanel$lambda$0(serverField, bundle)).installOn((JComponent)serverField);
        Function1 onClick = arg_0 -> SpaceGatewayLoginComponents.loginPanel$lambda$1(isValidationStarted, urlValidator, serverField, loginAction, arg_0);
        JButton loginButton = this.loginButton(bundle, isLoginActionDefault, (Function1<? super JButton, Unit>)onClick);
        JComponent jComponent = (JComponent)serverField;
        KeyStroke[] keyStrokeArray = new KeyStroke[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyStroke.getKeyStroke(10, 0), (String)"getKeyStroke(...)");
        UiUtils.addKeyboardAction((JComponent)jComponent, (KeyStroke[])keyStrokeArray, arg_0 -> SpaceGatewayLoginComponents.loginPanel$lambda$2(onClick, loginButton, arg_0));
        $this$loginPanel.row(bundle.message("login.panel.organization.url.label", new Object[0]), arg_0 -> SpaceGatewayLoginComponents.loginPanel$lambda$3(serverField, loginButton, arg_0));
    }

    public static /* synthetic */ void loginPanel$default(SpaceGatewayLoginComponents spaceGatewayLoginComponents, Panel panel, SpaceportGatewayBundle spaceportGatewayBundle, String string, boolean bl, Function1 function1, Disposable disposable, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        spaceGatewayLoginComponents.loginPanel(panel, spaceportGatewayBundle, string, bl, (Function1<? super String, Unit>)function1, disposable);
    }

    private final JBTextField organizationUrlTextField(@NlsSafe String initialText, @NlsContexts.StatusText String placeholderText) {
        JBTextField jBTextField;
        String string = initialText;
        if (string == null) {
            string = "";
        }
        JBTextField $this$organizationUrlTextField_u24lambda_u240 = jBTextField = new JBTextField(string, 45);
        boolean bl = false;
        $this$organizationUrlTextField_u24lambda_u240.setOpaque(false);
        $this$organizationUrlTextField_u24lambda_u240.getEmptyText().setText(placeholderText);
        $this$organizationUrlTextField_u24lambda_u240.getAccessibleContext().setAccessibleName(placeholderText);
        TextComponentEmptyText.setupPlaceholderVisibility((JTextComponent)((JTextComponent)$this$organizationUrlTextField_u24lambda_u240));
        return jBTextField;
    }

    static /* synthetic */ JBTextField organizationUrlTextField$default(SpaceGatewayLoginComponents spaceGatewayLoginComponents, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = organizationUrlPlaceholder;
        }
        return spaceGatewayLoginComponents.organizationUrlTextField(string, string2);
    }

    private final JButton loginButton(SpaceportGatewayBundle bundle, boolean bl, Function1<? super JButton, Unit> onClick) {
        JButton jButton;
        JButton $this$loginButton_u24lambda_u240 = jButton = new JButton(bundle.message("login.panel.log.in.button", new Object[0]));
        boolean bl2 = false;
        $this$loginButton_u24lambda_u240.setOpaque(false);
        $this$loginButton_u24lambda_u240.addActionListener(arg_0 -> SpaceGatewayLoginComponents.loginButton$lambda$0$0(onClick, $this$loginButton_u24lambda_u240, arg_0));
        if (bl) {
            ComponentUtil.putClientProperty((JComponent)$this$loginButton_u24lambda_u240, (Key)DarculaButtonUI.DEFAULT_STYLE_KEY, (Object)true);
        }
        return jButton;
    }

    static /* synthetic */ JButton loginButton$default(SpaceGatewayLoginComponents spaceGatewayLoginComponents, SpaceportGatewayBundle spaceportGatewayBundle, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return spaceGatewayLoginComponents.loginButton(spaceportGatewayBundle, bl, (Function1<? super JButton, Unit>)function1);
    }

    @NotNull
    public final JLabel errorText(@NlsContexts.DetailedDescription @NotNull String error) {
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        JLabel $this$errorText_u24lambda_u240 = jLabel = ComponentPanelBuilder.Companion.createCommentComponent(error, true);
        boolean bl = false;
        $this$errorText_u24lambda_u240.setForeground((Color)JBColor.RED);
        return jLabel;
    }

    @NotNull
    public final JComponent separator$intellij_spaceport_gateway() {
        return (JComponent)new SeparatorComponent(0, (Color)JBColor.namedColor((String)"Group.separatorColor", (Color)((Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51))), null);
    }

    @NotNull
    public final DialogPanel buildConnectingPanel$intellij_spaceport_gateway(@NotNull AbstractSpaceGatewayContext context, @NotNull String server, @NotNull Function0<Unit> cancelAction) {
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(cancelAction, (String)"cancelAction");
        DialogPanel $this$buildConnectingPanel_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> SpaceGatewayLoginComponents.buildConnectingPanel$lambda$0(context, server, cancelAction, arg_0));
        boolean bl = false;
        $this$buildConnectingPanel_u24lambda_u241.setOpaque(false);
        return dialogPanel;
    }

    private static final ValidationInfo loginPanel$lambda$0(JBTextField $serverField, SpaceportGatewayBundle $bundle) {
        String string = $serverField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)string) ? new ValidationInfo($bundle.message("login.panel.url.validation.message", new Object[0]), (JComponent)$serverField) : null;
    }

    private static final Unit loginPanel$lambda$1(Ref.BooleanRef $isValidationStarted, ComponentValidator $urlValidator, JBTextField $serverField, Function1 $loginAction, JButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!$isValidationStarted.element) {
            $urlValidator.andRegisterOnDocumentListener((JTextComponent)$serverField);
            $isValidationStarted.element = true;
        }
        $urlValidator.revalidate();
        if ($urlValidator.getValidationInfo() == null) {
            it.setEnabled(false);
            String string = $serverField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            $loginAction.invoke((Object)((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        return Unit.INSTANCE;
    }

    private static final Unit loginPanel$lambda$2(Function1 $onClick, JButton $loginButton, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $onClick.invoke((Object)$loginButton);
        return Unit.INSTANCE;
    }

    private static final Unit loginPanel$lambda$3(JBTextField $serverField, JButton $loginButton, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$serverField).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        $this$row.cell((JComponent)$loginButton);
        return Unit.INSTANCE;
    }

    private static final void loginButton$lambda$0$0(Function1 $onClick, JButton $this_apply, ActionEvent it) {
        $onClick.invoke((Object)$this_apply);
    }

    private static final Unit buildConnectingPanel$lambda$0$0$0(Function0 $cancelAction, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $cancelAction.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit buildConnectingPanel$lambda$0$1$0(Ref.ObjectRef $redirectWithCode, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        if (string == null) {
            string = "";
        }
        $redirectWithCode.element = string;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit buildConnectingPanel$lambda$0$1$1(Ref.ObjectRef $redirectWithCode, AbstractSpaceGatewayContext $context, ActionEvent it) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String processedRest = StringsKt.substringAfter$default((String)((String)$redirectWithCode.element), (String)"?", null, (int)2, null);
        Map $this$mapValues$iv = RemoteDevProtocolUtil.INSTANCE.parseParamsString(processedRest);
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            List list = CollectionsKt.listOf(it2.getValue());
            map4.put(k, list);
        }
        Map parameters2 = destination$iv$iv$iv;
        $context.workspaceComponent().spaceOAuthService().handleOAuthServerCallback("", parameters2);
        return Unit.INSTANCE;
    }

    private static final Unit buildConnectingPanel$lambda$0$0(AbstractSpaceGatewayContext $context, String $server, Function0 $cancelAction, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$server};
        $this$row.label($context.bundle().message("login.panel.connecting.to.server.label", objectArray));
        String string = IdeBundle.message((String)"button.cancel", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> SpaceGatewayLoginComponents.buildConnectingPanel$lambda$0$0$0($cancelAction, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit buildConnectingPanel$lambda$0$1(Ref.ObjectRef $redirectWithCode, AbstractSpaceGatewayContext $context, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("Login with redirect url:");
        $this$row.textField().onChanged(arg_0 -> SpaceGatewayLoginComponents.buildConnectingPanel$lambda$0$1$0($redirectWithCode, arg_0));
        $this$row.button("Log in", arg_0 -> SpaceGatewayLoginComponents.buildConnectingPanel$lambda$0$1$1($redirectWithCode, $context, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit buildConnectingPanel$lambda$0(AbstractSpaceGatewayContext $context, String $server, Function0 $cancelAction, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SpaceGatewayLoginComponents.buildConnectingPanel$lambda$0$0($context, $server, $cancelAction, arg_0), (int)1, null);
        if (PluginManagerCore.isRunningFromSources()) {
            Ref.ObjectRef redirectWithCode = new Ref.ObjectRef();
            redirectWithCode.element = "";
            Panel.row$default((Panel)$this$panel, null, arg_0 -> SpaceGatewayLoginComponents.buildConnectingPanel$lambda$0$1(redirectWithCode, $context, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }
}

