/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.ui;

import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.spaceport.ui.SpaceComponentDebugNameProvider;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000f\u001a\u00020\u00042\b\b\u0001\u0010\u0010\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\rH\u0007\u001a\u001c\u0010\u0015\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\rH\u0007\u00a8\u0006\u0016"}, d2={"debugName", "", "Ljavax/swing/JComponent;", "name", "", "Lorg/jetbrains/annotations/NonNls;", "requestFocus", "component", "Ljava/awt/Component;", "resizeIcon", "Ljavax/swing/Icon;", "icon", "size", "", "resizeIconScaled", "cleanupUrl", "url", "horizontalPanel", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "gap", "alignment", "verticalPanel", "intellij.spaceport"})
public final class UtilitiesKt {
    @ApiStatus.Internal
    public static final void debugName(@NotNull JComponent $this$debugName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$debugName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        UiInspectorUtil.registerProvider((JComponent)$this$debugName, (UiInspectorContextProvider)new SpaceComponentDebugNameProvider(name));
    }

    public static final void requestFocus(@Nullable Component component) {
        if (component != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> UtilitiesKt.requestFocus$lambda$0(component));
        }
    }

    @NotNull
    public static final Icon resizeIcon(@NotNull Icon icon, int size) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return UtilitiesKt.resizeIconScaled(icon, JBUI.scale((int)size));
    }

    @NotNull
    public static final Icon resizeIconScaled(@NotNull Icon icon, int size) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        float scale = (float)size / (float)icon.getIconWidth();
        return IconUtil.scale((Icon)icon, null, (float)scale);
    }

    @ApiStatus.Internal
    @NlsSafe
    @NotNull
    public static final String cleanupUrl(@NlsSafe @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)url, (CharSequence)"https://"), (CharSequence)"http://"), (CharSequence)"/");
    }

    @ApiStatus.Internal
    @NotNull
    public static final NonOpaquePanel horizontalPanel(int gap, int alignment) {
        return new NonOpaquePanel((LayoutManager)new HorizontalLayout(gap, alignment));
    }

    public static /* synthetic */ NonOpaquePanel horizontalPanel$default(int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return UtilitiesKt.horizontalPanel(n, n2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final NonOpaquePanel verticalPanel(int gap, int alignment) {
        return new NonOpaquePanel((LayoutManager)new VerticalLayout(gap, alignment));
    }

    public static /* synthetic */ NonOpaquePanel verticalPanel$default(int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return UtilitiesKt.verticalPanel(n, n2);
    }

    private static final void requestFocus$lambda$0(Component $component) {
        IdeFocusManager.getGlobalInstance().requestFocus($component, true);
    }
}

