/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.OptionPaneRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeToolState {
    private static final Logger LOG = Logger.getInstance(ScopeToolState.class);
    @NotNull
    private final String myScopeName;
    private NamedScope myScope;
    private InspectionToolWrapper<?, ?> myToolWrapper;
    private boolean myEnabled;
    private HighlightDisplayLevel myLevel;
    private String myEditorAttributesKey;
    private ConfigPanelState myAdditionalConfigPanelState;

    public ScopeToolState(@NotNull NamedScope scope, @NotNull InspectionToolWrapper<?, ?> toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            ScopeToolState.$$$reportNull$$$0(0);
        }
        if (toolWrapper == null) {
            ScopeToolState.$$$reportNull$$$0(1);
        }
        if (level == null) {
            ScopeToolState.$$$reportNull$$$0(2);
        }
        this(scope.getScopeId(), toolWrapper, enabled, level);
        this.myScope = scope;
    }

    public ScopeToolState(@NotNull String scopeName, @NotNull InspectionToolWrapper<?, ?> toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scopeName == null) {
            ScopeToolState.$$$reportNull$$$0(3);
        }
        if (toolWrapper == null) {
            ScopeToolState.$$$reportNull$$$0(4);
        }
        if (level == null) {
            ScopeToolState.$$$reportNull$$$0(5);
        }
        this.myScopeName = scopeName;
        this.myToolWrapper = toolWrapper;
        this.myEnabled = enabled;
        this.myLevel = level;
    }

    @NotNull
    public ScopeToolState copy() {
        return new ScopeToolState(this.myScopeName, this.myToolWrapper, this.myEnabled, this.myLevel);
    }

    @Nullable
    public NamedScope getScope(@Nullable Project project) {
        if (this.myScope == null && project != null) {
            this.myScope = NamedScopesHolder.getScope(project, this.myScopeName);
        }
        return this.myScope;
    }

    @NotNull
    public String getScopeName() {
        String string = this.myScopeName;
        if (string == null) {
            ScopeToolState.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public InspectionToolWrapper<?, ?> getTool() {
        InspectionToolWrapper<?, ?> inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            ScopeToolState.$$$reportNull$$$0(7);
        }
        return inspectionToolWrapper;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public HighlightDisplayLevel getLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myLevel;
        if (highlightDisplayLevel == null) {
            ScopeToolState.$$$reportNull$$$0(8);
        }
        return highlightDisplayLevel;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            ScopeToolState.$$$reportNull$$$0(9);
        }
        this.myLevel = level;
    }

    @Nullable
    public TextAttributesKey getEditorAttributesKey() {
        if (this.myEditorAttributesKey != null) {
            return TextAttributesKey.find((String)this.myEditorAttributesKey);
        }
        String externalName = this.myToolWrapper.getDefaultEditorAttributes();
        return externalName == null ? null : TextAttributesKey.find((String)externalName);
    }

    @Nullable
    public String getEditorAttributesExternalName() {
        return this.myEditorAttributesKey;
    }

    public void setEditorAttributesExternalName(@Nullable String textAttributesKey) {
        this.myEditorAttributesKey = textAttributesKey;
    }

    @Nullable
    public JComponent getAdditionalConfigPanel(@NotNull Disposable parent, @NotNull Project project) {
        if (parent == null) {
            ScopeToolState.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ScopeToolState.$$$reportNull$$$0(11);
        }
        if (this.myAdditionalConfigPanelState == null) {
            this.myAdditionalConfigPanelState = ConfigPanelState.of(OptionPaneRenderer.createOptionsPanel(this.myToolWrapper.getTool(), parent, project), this.myToolWrapper);
        }
        return this.myAdditionalConfigPanelState.getPanel(this.isEnabled());
    }

    public void resetConfigPanel() {
        this.myAdditionalConfigPanelState = null;
    }

    public void setTool(@NotNull InspectionToolWrapper<?, ?> tool) {
        if (tool == null) {
            ScopeToolState.$$$reportNull$$$0(12);
        }
        this.myToolWrapper = tool;
    }

    public boolean equalTo(@NotNull ScopeToolState state2) {
        if (state2 == null) {
            ScopeToolState.$$$reportNull$$$0(13);
        }
        if (this.isEnabled() != state2.isEnabled()) {
            return false;
        }
        if (this.getLevel() != state2.getLevel()) {
            return false;
        }
        if (!Objects.equals(this.getEditorAttributesExternalName(), state2.getEditorAttributesExternalName())) {
            return false;
        }
        InspectionToolWrapper<?, ?> toolWrapper = this.getTool();
        InspectionToolWrapper<?, ?> toolWrapper2 = state2.getTool();
        if (!toolWrapper.isInitialized() && !toolWrapper2.isInitialized()) {
            return true;
        }
        return ScopeToolState.areSettingsEqual(toolWrapper, toolWrapper2);
    }

    public static boolean areSettingsEqual(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull InspectionToolWrapper<?, ?> toolWrapper2) {
        if (toolWrapper == null) {
            ScopeToolState.$$$reportNull$$$0(14);
        }
        if (toolWrapper2 == null) {
            ScopeToolState.$$$reportNull$$$0(15);
        }
        try {
            @NonNls String tempRoot = "root";
            Element oldToolSettings = new Element(tempRoot);
            ScopeToolState.tryWriteSettings(toolWrapper.getTool(), oldToolSettings);
            Element newToolSettings = new Element(tempRoot);
            ScopeToolState.tryWriteSettings(toolWrapper2.getTool(), newToolSettings);
            return JDOMUtil.areElementsEqual((Element)oldToolSettings, (Element)newToolSettings);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public void scopesChanged() {
        this.myScope = null;
    }

    public static void tryReadSettings(@NotNull InspectionProfileEntry entry, @NotNull Element node) throws InvalidDataException {
        if (entry == null) {
            ScopeToolState.$$$reportNull$$$0(16);
        }
        if (node == null) {
            ScopeToolState.$$$reportNull$$$0(17);
        }
        try {
            entry.readSettings(node);
        }
        catch (ProcessCanceledException | InvalidDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidDataException("Can't read settings for tool #" + entry.getShortName(), (Throwable)e);
        }
    }

    public static void tryWriteSettings(@NotNull InspectionProfileEntry entry, @NotNull Element node) throws WriteExternalException {
        if (entry == null) {
            ScopeToolState.$$$reportNull$$$0(18);
        }
        if (node == null) {
            ScopeToolState.$$$reportNull$$$0(19);
        }
        try {
            entry.writeSettings(node);
        }
        catch (ProcessCanceledException | WriteExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't write settings for tool #" + entry.getShortName(), e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/ScopeToolState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper2";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/ScopeToolState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTool";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalConfigPanel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTool";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equalTo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areSettingsEqual";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryReadSettings";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryWriteSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static final class ConfigPanelState {
        private static final ConfigPanelState EMPTY = new ConfigPanelState(null, null);
        private final JComponent myOptionsPanel;
        private final Set<Component> myEnableRequiredComponent = new HashSet<Component>();
        private boolean myLastState = true;
        private boolean myDeafListeners;

        private ConfigPanelState(JComponent optionsPanel, InspectionToolWrapper<?, ?> wrapper) {
            this.myOptionsPanel = optionsPanel;
            if (this.myOptionsPanel != null) {
                ArrayDeque<Component> q = new ArrayDeque<Component>(1);
                q.addLast(optionsPanel);
                while (!q.isEmpty()) {
                    Component current = (Component)q.removeFirst();
                    current.addPropertyChangeListener("enabled", evt -> {
                        if (!this.myDeafListeners) {
                            boolean newValue = (Boolean)evt.getNewValue();
                            if (newValue) {
                                this.myEnableRequiredComponent.add(current);
                            } else {
                                String message = wrapper == null ? null : " tool = #" + wrapper.getShortName();
                                LOG.assertTrue(this.myEnableRequiredComponent.remove(current), (Object)message);
                            }
                        }
                    });
                    if (current.isEnabled()) {
                        this.myEnableRequiredComponent.add(current);
                    }
                    if (!(current instanceof Container)) continue;
                    Container container = (Container)current;
                    for (Component child : container.getComponents()) {
                        q.addLast(child);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JComponent getPanel(boolean currentState) {
            if (this.myOptionsPanel != null && this.myLastState != currentState) {
                this.myDeafListeners = true;
                try {
                    for (Component c : this.myEnableRequiredComponent) {
                        c.setEnabled(currentState);
                    }
                    this.myLastState = currentState;
                }
                finally {
                    this.myDeafListeners = false;
                }
            }
            return this.myOptionsPanel;
        }

        private static ConfigPanelState of(JComponent panel, InspectionToolWrapper<?, ?> toolWrapper) {
            return panel == null ? EMPTY : new ConfigPanelState(panel, toolWrapper);
        }
    }
}

