/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.util.MathUtil;
import java.awt.Color;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CaretVisualAttributes {
    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public static final CaretVisualAttributes DEFAULT = new CaretVisualAttributes(null, Weight.NORMAL, Shape.DEFAULT, 1.0f);
    @Nullable
    private final Color myColor;
    @NotNull
    private final Weight myWeight;
    @NotNull
    private final Shape myShape;
    private final float myThickness;

    public static CaretVisualAttributes getDefault() {
        return DEFAULT;
    }

    public CaretVisualAttributes(@Nullable Color color, @NotNull Weight weight) {
        if (weight == null) {
            CaretVisualAttributes.$$$reportNull$$$0(0);
        }
        this(color, weight, Shape.DEFAULT, 1.0f);
    }

    public CaretVisualAttributes(@Nullable Color color, @NotNull Weight weight, @NotNull Shape shape, float thickness) {
        if (weight == null) {
            CaretVisualAttributes.$$$reportNull$$$0(1);
        }
        if (shape == null) {
            CaretVisualAttributes.$$$reportNull$$$0(2);
        }
        this.myColor = color;
        this.myWeight = weight;
        this.myShape = shape;
        this.myThickness = MathUtil.clamp((float)thickness, (float)0.0f, (float)1.0f);
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    @NotNull
    public Shape getShape() {
        Shape shape = this.myShape;
        if (shape == null) {
            CaretVisualAttributes.$$$reportNull$$$0(3);
        }
        return shape;
    }

    public float getThickness() {
        return this.myThickness;
    }

    @NotNull
    public Weight getWeight() {
        Weight weight = this.myWeight;
        if (weight == null) {
            CaretVisualAttributes.$$$reportNull$$$0(4);
        }
        return weight;
    }

    public int getWidth(int defaultWidth) {
        return Math.max(1, defaultWidth + this.myWeight.delta);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weight";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/CaretVisualAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/CaretVisualAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShape";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWeight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static enum Shape {
        DEFAULT,
        BLOCK,
        BAR,
        UNDERSCORE,
        BOX;

    }

    public static enum Weight {
        THIN(-1),
        NORMAL(0),
        HEAVY(1);

        private final int delta;

        private Weight(int delta) {
            this.delta = delta;
        }

        public int getDelta() {
            return this.delta;
        }
    }
}

