/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.CodeStyleBundle;
import com.intellij.configurationStore.Property;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.ExcludedFiles;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsFactory;
import com.intellij.psi.codeStyle.ImportsLayoutSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettings;
import com.intellij.psi.codeStyle.SoftMargins;
import com.intellij.psi.codeStyle.StoredOptionsContainer;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.PresentableEnum;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CodeStyleSettings
extends LegacyCodeStyleSettings
implements Cloneable,
JDOMExternalizable,
ImportsLayoutSettings {
    public static final int CURR_VERSION = 173;
    private static final Logger LOG = Logger.getInstance(CodeStyleSettings.class);
    public static final String VERSION_ATTR = "version";
    @NonNls
    private static final String REPEAT_ANNOTATIONS = "REPEAT_ANNOTATIONS";
    @NonNls
    static final String ADDITIONAL_INDENT_OPTIONS = "ADDITIONAL_INDENT_OPTIONS";
    @NonNls
    private static final String FILETYPE = "fileType";
    private CommonCodeStyleSettingsManager myCommonSettingsManager = new CommonCodeStyleSettingsManager(this);
    private final CustomCodeStyleSettingsManager myCustomCodeStyleSettingsManager = new CustomCodeStyleSettingsManager(this);
    private final SoftMargins mySoftMargins = new SoftMargins();
    private final ExcludedFiles myExcludedFiles = new ExcludedFiles();
    private int myVersion = 173;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    private final StoredOptionsContainer myStoredOptions = new StoredOptionsContainer();
    public boolean AUTODETECT_INDENTS = true;
    public final CommonCodeStyleSettings.IndentOptions OTHER_INDENT_OPTIONS = new CommonCodeStyleSettings.IndentOptions();
    private final Map<FileType, CommonCodeStyleSettings.IndentOptions> myAdditionalIndentOptions = new LinkedHashMap<FileType, CommonCodeStyleSettings.IndentOptions>();
    private static final String ourSystemLineSeparator = System.lineSeparator();
    public String LINE_SEPARATOR;
    @Deprecated
    public String FIELD_NAME_PREFIX = "";
    @Deprecated(forRemoval=true)
    public String STATIC_FIELD_NAME_PREFIX = "";
    @Deprecated(forRemoval=true)
    public String PARAMETER_NAME_PREFIX = "";
    @Deprecated(forRemoval=true)
    public String LOCAL_VARIABLE_NAME_PREFIX = "";
    @Deprecated(forRemoval=true)
    public String FIELD_NAME_SUFFIX = "";
    @Deprecated(forRemoval=true)
    public String STATIC_FIELD_NAME_SUFFIX = "";
    @Deprecated(forRemoval=true)
    public String PARAMETER_NAME_SUFFIX = "";
    @Deprecated(forRemoval=true)
    public String LOCAL_VARIABLE_NAME_SUFFIX = "";
    @Deprecated(forRemoval=true)
    public boolean PREFER_LONGER_NAMES = true;
    @Deprecated(forRemoval=true)
    public boolean GENERATE_FINAL_LOCALS;
    @Deprecated(forRemoval=true)
    public boolean GENERATE_FINAL_PARAMETERS;
    @Deprecated(forRemoval=true)
    public String VISIBILITY = "public";
    @Deprecated(forRemoval=true)
    public boolean PARENTHESES_AROUND_METHOD_ARGUMENTS = true;
    @Deprecated(forRemoval=true)
    public boolean USE_EXTERNAL_ANNOTATIONS;
    @Deprecated(forRemoval=true)
    public boolean INSERT_OVERRIDE_ANNOTATION = true;
    @Deprecated(forRemoval=true)
    public boolean REPEAT_SYNCHRONIZED = true;
    private final List<String> myRepeatAnnotations = new ArrayList<String>();
    @Deprecated(forRemoval=true)
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
    @Deprecated(forRemoval=true)
    public boolean USE_FQ_CLASS_NAMES;
    @Deprecated(forRemoval=true)
    public boolean USE_FQ_CLASS_NAMES_IN_JAVADOC = true;
    @Deprecated(forRemoval=true)
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    @Deprecated(forRemoval=true)
    public boolean INSERT_INNER_CLASS_IMPORTS;
    @Deprecated(forRemoval=true)
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    @Deprecated(forRemoval=true)
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    @Deprecated(forRemoval=true)
    public int STATIC_FIELDS_ORDER_WEIGHT = 1;
    @Deprecated(forRemoval=true)
    public int FIELDS_ORDER_WEIGHT = 2;
    @Deprecated(forRemoval=true)
    public int CONSTRUCTORS_ORDER_WEIGHT = 3;
    @Deprecated(forRemoval=true)
    public int STATIC_METHODS_ORDER_WEIGHT = 4;
    @Deprecated(forRemoval=true)
    public int METHODS_ORDER_WEIGHT = 5;
    @Deprecated(forRemoval=true)
    public int STATIC_INNER_CLASSES_ORDER_WEIGHT = 6;
    @Deprecated(forRemoval=true)
    public int INNER_CLASSES_ORDER_WEIGHT = 7;
    @Property(externalName="max_line_length")
    @ApiStatus.Internal
    public int RIGHT_MARGIN = 120;
    @Property(externalName="wrap_on_typing")
    public boolean WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    @Deprecated(forRemoval=true)
    public boolean ENABLE_JAVADOC_FORMATTING = true;
    @Deprecated(forRemoval=true)
    public boolean JD_LEADING_ASTERISKS_ARE_ENABLED = true;
    @Deprecated(forRemoval=true)
    public boolean JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST;
    public boolean FORMATTER_TAGS_ENABLED = true;
    public String FORMATTER_ON_TAG = "@formatter:on";
    public String FORMATTER_OFF_TAG = "@formatter:off";
    public volatile boolean FORMATTER_TAGS_ACCEPT_REGEXP;
    private volatile Pattern myFormatterOffPattern;
    private volatile Pattern myFormatterOnPattern;
    private CodeStyleSettings myParentSettings;
    private boolean myLoadedAdditionalIndentOptions;

    @NotNull
    public static String generateConfigurableIdByLanguage(@NotNull Language language) {
        if (language == null) {
            CodeStyleSettings.$$$reportNull$$$0(0);
        }
        String string = "preferences.sourceCode." + language.getID();
        if (string == null) {
            CodeStyleSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Deprecated
    public CodeStyleSettings() {
        this(true, true);
    }

    protected CodeStyleSettings(boolean loadExtensions, boolean needsRegistration) {
        if (loadExtensions) {
            this.myCustomCodeStyleSettingsManager.initCustomSettings();
        }
        if (needsRegistration) {
            CodeStyleSettingsManager.registerSettings(this);
        }
    }

    public void setParentSettings(@NotNull CodeStyleSettings parent) {
        if (parent == null) {
            CodeStyleSettings.$$$reportNull$$$0(2);
        }
        this.myParentSettings = parent;
    }

    public CodeStyleSettings getParentSettings() {
        return this.myParentSettings;
    }

    @NotNull
    public <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> aClass) {
        if (aClass == null) {
            CodeStyleSettings.$$$reportNull$$$0(3);
        }
        T t = this.myCustomCodeStyleSettingsManager.getCustomSettings(aClass);
        if (t == null) {
            CodeStyleSettings.$$$reportNull$$$0(4);
        }
        return t;
    }

    @Nullable
    public <T extends CustomCodeStyleSettings> T getCustomSettingsIfCreated(@NotNull Class<T> aClass) {
        if (aClass == null) {
            CodeStyleSettings.$$$reportNull$$$0(5);
        }
        return this.myCustomCodeStyleSettingsManager.getCustomSettingsIfCreated(aClass);
    }

    @Deprecated
    public CodeStyleSettings clone() {
        CodeStyleSettings clone = new CodeStyleSettings(true, true);
        clone.copyFrom(this);
        return clone;
    }

    private void copyCustomSettingsFrom(@NotNull CodeStyleSettings from) {
        if (from == null) {
            CodeStyleSettings.$$$reportNull$$$0(6);
        }
        this.myCustomCodeStyleSettingsManager.copyFrom(from);
        this.OTHER_INDENT_OPTIONS.copyFrom(from.OTHER_INDENT_OPTIONS);
        this.myAdditionalIndentOptions.clear();
        for (Map.Entry<FileType, CommonCodeStyleSettings.IndentOptions> optionEntry : from.myAdditionalIndentOptions.entrySet()) {
            CommonCodeStyleSettings.IndentOptions options = optionEntry.getValue();
            this.myAdditionalIndentOptions.put(optionEntry.getKey(), (CommonCodeStyleSettings.IndentOptions)options.clone());
        }
        this.myCommonSettingsManager = from.myCommonSettingsManager.clone(this);
        this.myRepeatAnnotations.clear();
        this.myRepeatAnnotations.addAll(from.myRepeatAnnotations);
    }

    public void copyFrom(@NotNull CodeStyleSettings from) {
        if (from == null) {
            CodeStyleSettings.$$$reportNull$$$0(7);
        }
        CommonCodeStyleSettings.copyPublicFields(from, this);
        this.OTHER_INDENT_OPTIONS.copyFrom(from.OTHER_INDENT_OPTIONS);
        this.mySoftMargins.setValues(from.getDefaultSoftMargins());
        this.myExcludedFiles.setDescriptors(from.getExcludedFiles().getDescriptors());
        this.copyCustomSettingsFrom(from);
    }

    public String getLineSeparator() {
        return this.LINE_SEPARATOR != null ? this.LINE_SEPARATOR : ourSystemLineSeparator;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public List<String> getRepeatAnnotations() {
        List<String> list2 = this.myRepeatAnnotations;
        if (list2 == null) {
            CodeStyleSettings.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Deprecated(forRemoval=true)
    public void setRepeatAnnotations(@NotNull List<String> repeatAnnotations) {
        if (repeatAnnotations == null) {
            CodeStyleSettings.$$$reportNull$$$0(9);
        }
        this.myRepeatAnnotations.clear();
        this.myRepeatAnnotations.addAll(repeatAnnotations);
    }

    @Override
    @Deprecated
    public boolean isLayoutStaticImportsSeparately() {
        return this.LAYOUT_STATIC_IMPORTS_SEPARATELY;
    }

    @Override
    @Deprecated
    public void setLayoutStaticImportsSeparately(boolean value) {
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = value;
    }

    @Override
    @Deprecated
    public int getNamesCountToUseImportOnDemand() {
        return this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    @Override
    @Deprecated
    public void setNamesCountToUseImportOnDemand(int value) {
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    @Override
    @Deprecated
    public int getClassCountToUseImportOnDemand() {
        return this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    @Override
    @Deprecated
    public void setClassCountToUseImportOnDemand(int value) {
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    @Override
    @Deprecated
    public boolean isInsertInnerClassImports() {
        return this.INSERT_INNER_CLASS_IMPORTS;
    }

    @Override
    @Deprecated
    public void setInsertInnerClassImports(boolean value) {
        this.INSERT_INNER_CLASS_IMPORTS = value;
    }

    @Override
    @Deprecated
    public boolean isUseSingleClassImports() {
        return this.USE_SINGLE_CLASS_IMPORTS;
    }

    @Override
    @Deprecated
    public void setUseSingleClassImports(boolean value) {
        this.USE_SINGLE_CLASS_IMPORTS = value;
    }

    @Override
    @Deprecated
    public boolean isUseFqClassNames() {
        return this.USE_FQ_CLASS_NAMES;
    }

    @Override
    @Deprecated
    public void setUseFqClassNames(boolean value) {
        this.USE_FQ_CLASS_NAMES = value;
    }

    @Nullable
    public Pattern getFormatterOffPattern() {
        if (this.myFormatterOffPattern == null && this.FORMATTER_TAGS_ENABLED && this.FORMATTER_TAGS_ACCEPT_REGEXP) {
            this.myFormatterOffPattern = this.getPatternOrDisableRegexp(this.FORMATTER_OFF_TAG);
        }
        return this.myFormatterOffPattern;
    }

    public void setFormatterOffPattern(@Nullable Pattern formatterOffPattern) {
        this.myFormatterOffPattern = formatterOffPattern;
    }

    @Nullable
    public Pattern getFormatterOnPattern() {
        if (this.myFormatterOffPattern == null && this.FORMATTER_TAGS_ENABLED && this.FORMATTER_TAGS_ACCEPT_REGEXP) {
            this.myFormatterOnPattern = this.getPatternOrDisableRegexp(this.FORMATTER_ON_TAG);
        }
        return this.myFormatterOnPattern;
    }

    public void setFormatterOnPattern(@Nullable Pattern formatterOnPattern) {
        this.myFormatterOnPattern = formatterOnPattern;
    }

    @Nullable
    private Pattern getPatternOrDisableRegexp(@NotNull String markerText) {
        if (markerText == null) {
            CodeStyleSettings.$$$reportNull$$$0(10);
        }
        try {
            return Pattern.compile(markerText);
        }
        catch (PatternSyntaxException pse) {
            LOG.error("Loaded regexp pattern is invalid: '" + markerText + "', error message: " + pse.getMessage());
            this.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            return null;
        }
    }

    private static void setVersion(@NotNull Element element, int version) {
        if (element == null) {
            CodeStyleSettings.$$$reportNull$$$0(11);
        }
        element.setAttribute(VERSION_ATTR, Integer.toString(version));
    }

    private static int getVersion(@NotNull Element element) {
        String versionStr;
        if (element == null) {
            CodeStyleSettings.$$$reportNull$$$0(12);
        }
        if ((versionStr = element.getAttributeValue(VERSION_ATTR)) == null) {
            return 0;
        }
        try {
            return Integer.parseInt(versionStr);
        }
        catch (NumberFormatException nfe) {
            return 173;
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CodeStyleSettings.$$$reportNull$$$0(13);
        }
        this.myVersion = CodeStyleSettings.getVersion(element);
        this.myCustomCodeStyleSettingsManager.notifySettingsBeforeLoading();
        this.myStoredOptions.processOptions(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.myRepeatAnnotations.clear();
        Element annotations = element.getChild(REPEAT_ANNOTATIONS);
        if (annotations != null) {
            for (Element anno : annotations.getChildren("ANNO")) {
                this.myRepeatAnnotations.add(anno.getAttributeValue("name"));
            }
        }
        this.myCustomCodeStyleSettingsManager.readExternal(element);
        List list2 = element.getChildren(ADDITIONAL_INDENT_OPTIONS);
        for (Element additionalIndentElement : list2) {
            String fileTypeId = additionalIndentElement.getAttributeValue(FILETYPE);
            if (StringUtil.isEmpty((String)fileTypeId)) continue;
            FileType target = FileTypeRegistry.getInstance().getFileTypeByExtension(fileTypeId);
            if (UnknownFileType.INSTANCE == target || target instanceof PlainTextLikeFileType || target.getDefaultExtension().isEmpty()) {
                target = new TempFileType(fileTypeId);
            }
            CommonCodeStyleSettings.IndentOptions options = CodeStyleSettings.getDefaultIndentOptions(target);
            options.readExternal(additionalIndentElement);
            this.registerAdditionalIndentOptions(target, options);
        }
        this.myCommonSettingsManager.readExternal(element);
        this.mySoftMargins.deserializeFrom(element);
        this.myExcludedFiles.deserializeFrom(element);
        this.migrateLegacySettings();
        this.myCustomCodeStyleSettingsManager.notifySettingsLoaded();
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CodeStyleSettings.$$$reportNull$$$0(14);
        }
        CodeStyleSettings.setVersion(element, this.myVersion);
        CodeStyleSettings defaultSettings = new CodeStyleSettings(true, false);
        DefaultJDOMExternalizer.write((Object)this, (Element)element, (Predicate)((Object)this.myStoredOptions.createDiffFilter(this, defaultSettings)));
        this.mySoftMargins.serializeInto(element);
        this.myExcludedFiles.serializeInto(element);
        this.myCustomCodeStyleSettingsManager.writeExternal(element, defaultSettings);
        if (!this.myAdditionalIndentOptions.isEmpty()) {
            FileType[] fileTypes = this.myAdditionalIndentOptions.keySet().toArray(FileType.EMPTY_ARRAY);
            Arrays.sort(fileTypes, Comparator.comparing(FileType::getDefaultExtension));
            for (FileType fileType : fileTypes) {
                Element additionalIndentOptions = new Element(ADDITIONAL_INDENT_OPTIONS);
                this.myAdditionalIndentOptions.get(fileType).serialize(additionalIndentOptions, CodeStyleSettings.getDefaultIndentOptions(fileType));
                additionalIndentOptions.setAttribute(FILETYPE, fileType.getDefaultExtension());
                if (additionalIndentOptions.getChildren().isEmpty()) continue;
                element.addContent(additionalIndentOptions);
            }
        }
        this.myCommonSettingsManager.writeExternal(element);
        if (!this.myRepeatAnnotations.isEmpty()) {
            Element annos = new Element(REPEAT_ANNOTATIONS);
            for (String annotation : this.myRepeatAnnotations) {
                annos.addContent(new Element("ANNO").setAttribute("name", annotation));
            }
            element.addContent(annos);
        }
    }

    @NotNull
    private static CommonCodeStyleSettings.IndentOptions getDefaultIndentOptions(@NotNull FileType fileType) {
        if (fileType == null) {
            CodeStyleSettings.$$$reportNull$$$0(15);
        }
        for (FileTypeIndentOptionsFactory fileTypeIndentOptionsFactory : CodeStyleSettingsService.getInstance().getFileTypeIndentOptionsFactories()) {
            if (!fileTypeIndentOptionsFactory.getFileType().equals((Object)fileType)) continue;
            return CodeStyleSettings.getFileTypeIndentOptions(fileTypeIndentOptionsFactory);
        }
        return new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.OTHER_INDENT_OPTIONS;
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(16);
        }
        return indentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@Nullable FileType fileType) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getLanguageIndentOptions(fileType);
        if (indentOptions != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
            if (indentOptions2 == null) {
                CodeStyleSettings.$$$reportNull$$$0(17);
            }
            return indentOptions2;
        }
        if (fileType == null) {
            CommonCodeStyleSettings.IndentOptions indentOptions3 = this.OTHER_INDENT_OPTIONS;
            if (indentOptions3 == null) {
                CodeStyleSettings.$$$reportNull$$$0(18);
            }
            return indentOptions3;
        }
        if (!this.myLoadedAdditionalIndentOptions) {
            this.loadAdditionalIndentOptions();
        }
        if ((indentOptions = this.myAdditionalIndentOptions.get(fileType)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions4 = indentOptions;
            if (indentOptions4 == null) {
                CodeStyleSettings.$$$reportNull$$$0(19);
            }
            return indentOptions4;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions5 = this.OTHER_INDENT_OPTIONS;
        if (indentOptions5 == null) {
            CodeStyleSettings.$$$reportNull$$$0(20);
        }
        return indentOptions5;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByDocument(@Nullable Project project, @NotNull Document document) {
        PsiFile file;
        if (document == null) {
            CodeStyleSettings.$$$reportNull$$$0(21);
        }
        PsiFile psiFile = file = project != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(document) : null;
        if (file != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptionsByFile(file);
            if (indentOptions == null) {
                CodeStyleSettings.$$$reportNull$$$0(22);
            }
            return indentOptions;
        }
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        FileType fileType = vFile != null ? vFile.getFileType() : null;
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(fileType);
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(23);
        }
        return indentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file) {
        if (file != null) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptionsByFile(file.getProject(), virtualFile, null);
                if (indentOptions == null) {
                    CodeStyleSettings.$$$reportNull$$$0(24);
                }
                return indentOptions;
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(file.getFileType());
            if (indentOptions == null) {
                CodeStyleSettings.$$$reportNull$$$0(25);
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.OTHER_INDENT_OPTIONS;
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(26);
        }
        return indentOptions;
    }

    @ApiStatus.Internal
    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@NotNull Project project, @NotNull VirtualFile file, @Nullable TextRange formatRange) {
        if (project == null) {
            CodeStyleSettings.$$$reportNull$$$0(27);
        }
        if (file == null) {
            CodeStyleSettings.$$$reportNull$$$0(28);
        }
        AccessToken ignored = ProjectLocator.withPreferredProject((VirtualFile)file, (Project)project);
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptionsByFile(project, file, formatRange, false, null);
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        if (indentOptions2 == null) {
            CodeStyleSettings.$$$reportNull$$$0(29);
        }
        return indentOptions2;
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@NotNull Project project, @NotNull VirtualFile file, @Nullable TextRange formatRange, boolean ignoreDocOptions, @Nullable Processor<? super FileIndentOptionsProvider> providerProcessor) {
        CommonCodeStyleSettings.IndentOptions options;
        Object options2;
        Document document;
        boolean isFullReformat;
        if (project == null) {
            CodeStyleSettings.$$$reportNull$$$0(30);
        }
        if (file == null) {
            CodeStyleSettings.$$$reportNull$$$0(31);
        }
        boolean bl = isFullReformat = (document = FileDocumentManager.getInstance().getCachedDocument(file)) == null || CodeStyleSettings.isFileFullyCoveredByRange(document, formatRange);
        if (!ignoreDocOptions && !isFullReformat && (options2 = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument(document)) != null) {
            FileIndentOptionsProvider provider = ((CommonCodeStyleSettings.IndentOptions)options2).getFileIndentOptionsProvider();
            if (providerProcessor != null && provider != null) {
                providerProcessor.process((Object)provider);
            }
            Object object = options2;
            if (object == null) {
                CodeStyleSettings.$$$reportNull$$$0(32);
            }
            return object;
        }
        for (FileIndentOptionsProvider provider : FileIndentOptionsProvider.EP_NAME.getExtensionList()) {
            CommonCodeStyleSettings.IndentOptions indentOptions;
            if (!provider.isAllowed(isFullReformat) || (indentOptions = provider.getIndentOptions(project, this, file)) == null) continue;
            if (providerProcessor != null) {
                providerProcessor.process((Object)provider);
            }
            indentOptions.setFileIndentOptionsProvider(provider);
            CodeStyleSettings.logIndentOptions(file, provider, indentOptions);
            CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
            if (indentOptions2 == null) {
                CodeStyleSettings.$$$reportNull$$$0(33);
            }
            return indentOptions2;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file, (FileType)file.getFileType());
        if (language != null && (options = this.getIndentOptions(language)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = options;
            if (indentOptions == null) {
                CodeStyleSettings.$$$reportNull$$$0(34);
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(file.getFileType());
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(35);
        }
        return indentOptions;
    }

    private static boolean isFileFullyCoveredByRange(@NotNull Document document, @Nullable TextRange formatRange) {
        if (document == null) {
            CodeStyleSettings.$$$reportNull$$$0(36);
        }
        return formatRange != null && formatRange.equals((Object)new TextRange(0, document.getTextLength()));
    }

    private static void logIndentOptions(@NotNull VirtualFile file, @NotNull FileIndentOptionsProvider provider, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (file == null) {
            CodeStyleSettings.$$$reportNull$$$0(37);
        }
        if (provider == null) {
            CodeStyleSettings.$$$reportNull$$$0(38);
        }
        if (options == null) {
            CodeStyleSettings.$$$reportNull$$$0(39);
        }
        LOG.debug("Indent options returned by " + provider.getClass().getName() + " for " + file.getName() + ": indent size=" + options.INDENT_SIZE + ", use tabs=" + options.USE_TAB_CHARACTER + ", tab size=" + options.TAB_SIZE);
    }

    @Nullable
    private CommonCodeStyleSettings.IndentOptions getLanguageIndentOptions(@Nullable FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language lang = ((LanguageFileType)fileType).getLanguage();
        return this.getIndentOptions(lang);
    }

    public CommonCodeStyleSettings.IndentOptions getLanguageIndentOptions(@NotNull Language language) {
        CommonCodeStyleSettings.IndentOptions langOptions;
        if (language == null) {
            CodeStyleSettings.$$$reportNull$$$0(40);
        }
        return (langOptions = this.getIndentOptions(language)) != null ? langOptions : this.OTHER_INDENT_OPTIONS;
    }

    @Nullable
    private CommonCodeStyleSettings.IndentOptions getIndentOptions(Language lang) {
        CommonCodeStyleSettings settings = this.myCommonSettingsManager.getCommonSettings(lang);
        return settings != null ? settings.getIndentOptions() : null;
    }

    public boolean isSmartTabs(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).SMART_TABS;
    }

    public int getIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).INDENT_SIZE;
    }

    public int getContinuationIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).CONTINUATION_INDENT_SIZE;
    }

    public int getTabSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).TAB_SIZE;
    }

    public boolean useTabCharacter(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).USE_TAB_CHARACTER;
    }

    void registerAdditionalIndentOptions(FileType fileType, CommonCodeStyleSettings.IndentOptions options) {
        FileType registered = this.findRegisteredFileType(fileType);
        if (registered == null || registered instanceof TempFileType) {
            this.myAdditionalIndentOptions.put(fileType, options);
        }
    }

    @Nullable
    private FileType findRegisteredFileType(@NotNull FileType provided) {
        if (provided == null) {
            CodeStyleSettings.$$$reportNull$$$0(41);
        }
        for (FileType existing : this.myAdditionalIndentOptions.keySet()) {
            if (!Comparing.strEqual((String)existing.getDefaultExtension(), (String)provided.getDefaultExtension())) continue;
            return existing;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAdditionalIndentOptions() {
        Map<FileType, CommonCodeStyleSettings.IndentOptions> map = this.myAdditionalIndentOptions;
        synchronized (map) {
            this.myLoadedAdditionalIndentOptions = true;
            for (FileTypeIndentOptionsFactory fileTypeIndentOptionsFactory : CodeStyleSettingsService.getInstance().getFileTypeIndentOptionsFactories()) {
                if (this.myAdditionalIndentOptions.containsKey(fileTypeIndentOptionsFactory.getFileType())) continue;
                this.registerAdditionalIndentOptions(fileTypeIndentOptionsFactory.getFileType(), CodeStyleSettings.getFileTypeIndentOptions(fileTypeIndentOptionsFactory));
            }
        }
    }

    void unregisterAdditionalIndentOptions(@NotNull FileType fileType) {
        FileType registered;
        if (fileType == null) {
            CodeStyleSettings.$$$reportNull$$$0(42);
        }
        if ((registered = this.findRegisteredFileType(fileType)) != null && !(registered instanceof TempFileType)) {
            TempFileType tempFileType = new TempFileType(fileType.getDefaultExtension());
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myAdditionalIndentOptions.get(fileType);
            this.myAdditionalIndentOptions.remove(fileType);
            this.myAdditionalIndentOptions.put(tempFileType, indentOptions);
        }
    }

    @NotNull
    private static CommonCodeStyleSettings.IndentOptions getFileTypeIndentOptions(@NotNull FileTypeIndentOptionsFactory factory) {
        CommonCodeStyleSettings.IndentOptions indentOptions;
        if (factory == null) {
            CodeStyleSettings.$$$reportNull$$$0(43);
        }
        try {
            indentOptions = factory.createIndentOptions();
        }
        catch (AbstractMethodError error) {
            LOG.error((Throwable)PluginException.createByClass((String)"Plugin uses obsolete API", null, factory.getClass()));
            return new CommonCodeStyleSettings.IndentOptions();
        }
        if (indentOptions == null) {
            CodeStyleSettings.$$$reportNull$$$0(44);
        }
        return indentOptions;
    }

    @TestOnly
    public void clearCodeStyleSettings() {
        CodeStyleSettings cleanSettings = new CodeStyleSettings(true, false);
        this.copyFrom(cleanSettings);
        this.myAdditionalIndentOptions.clear();
        this.myLoadedAdditionalIndentOptions = false;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@Nullable Language lang) {
        CommonCodeStyleSettings settings = this.myCommonSettingsManager.getCommonSettings(lang);
        if (settings == null) {
            settings = this.myCommonSettingsManager.getDefaults();
        }
        CommonCodeStyleSettings commonCodeStyleSettings = settings;
        if (commonCodeStyleSettings == null) {
            CodeStyleSettings.$$$reportNull$$$0(45);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@NotNull String langName) {
        if (langName == null) {
            CodeStyleSettings.$$$reportNull$$$0(46);
        }
        CommonCodeStyleSettings commonCodeStyleSettings = this.myCommonSettingsManager.getCommonSettings(langName);
        if (commonCodeStyleSettings == null) {
            CodeStyleSettings.$$$reportNull$$$0(47);
        }
        return commonCodeStyleSettings;
    }

    public int getRightMargin(@Nullable Language language) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && langSettings.RIGHT_MARGIN >= 0) {
            return langSettings.RIGHT_MARGIN;
        }
        return this.getDefaultRightMargin();
    }

    public void setRightMargin(@Nullable Language language, int rightMargin) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null) {
            langSettings.RIGHT_MARGIN = rightMargin;
            return;
        }
        this.setDefaultRightMargin(rightMargin);
    }

    public int getDefaultRightMargin() {
        return this.RIGHT_MARGIN;
    }

    public void setDefaultRightMargin(int rightMargin) {
        this.RIGHT_MARGIN = rightMargin;
    }

    public boolean isWrapOnTyping(@Nullable Language language) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && langSettings.WRAP_ON_TYPING != CommonCodeStyleSettings.WrapOnTyping.DEFAULT.intValue) {
            return langSettings.WRAP_ON_TYPING == CommonCodeStyleSettings.WrapOnTyping.WRAP.intValue;
        }
        return this.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CodeStyleSettings)) {
            return false;
        }
        if (!ReflectionUtil.comparePublicNonFinalFields((Object)this, (Object)obj)) {
            return false;
        }
        if (!this.mySoftMargins.equals(((CodeStyleSettings)obj).mySoftMargins)) {
            return false;
        }
        if (!this.myExcludedFiles.equals(((CodeStyleSettings)obj).getExcludedFiles())) {
            return false;
        }
        if (!this.OTHER_INDENT_OPTIONS.equals(((CodeStyleSettings)obj).OTHER_INDENT_OPTIONS)) {
            return false;
        }
        if (!this.myCommonSettingsManager.equals(((CodeStyleSettings)obj).myCommonSettingsManager)) {
            return false;
        }
        for (CustomCodeStyleSettings customSettings : this.myCustomCodeStyleSettingsManager.getAllSettings()) {
            if (customSettings.equals(((CodeStyleSettings)obj).getCustomSettings(customSettings.getClass()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static CodeStyleSettings getDefaults() {
        CodeStyleSettings codeStyleSettings = DefaultsHolder.myDefaults;
        if (codeStyleSettings == null) {
            CodeStyleSettings.$$$reportNull$$$0(48);
        }
        return codeStyleSettings;
    }

    private void migrateLegacySettings() {
        if (this.myVersion < 173) {
            for (CustomCodeStyleSettings settings : this.myCustomCodeStyleSettingsManager.getAllSettings()) {
                settings.importLegacySettings(this);
            }
            this.myVersion = 173;
        }
    }

    public void resetDeprecatedFields() {
        CodeStyleSettings defaults = CodeStyleSettings.getDefaults();
        ReflectionUtil.copyFields((Field[])this.getClass().getFields(), (Object)defaults, (Object)this, (DifferenceFilter)new DifferenceFilter<CodeStyleSettings>(this, this, defaults){

            public boolean test(@NotNull Field field) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                return field.getAnnotation(Deprecated.class) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/codeStyle/CodeStyleSettings$1", "test"));
            }
        });
        this.myRepeatAnnotations.clear();
    }

    public int getVersion() {
        return this.myVersion;
    }

    @NotNull
    public List<Integer> getSoftMargins(@Nullable Language language) {
        CommonCodeStyleSettings languageSettings;
        if (language != null && (languageSettings = this.myCommonSettingsManager.getCommonSettings(language)) != null && !languageSettings.getSoftMargins().isEmpty()) {
            List<Integer> list2 = languageSettings.getSoftMargins();
            if (list2 == null) {
                CodeStyleSettings.$$$reportNull$$$0(49);
            }
            return list2;
        }
        List<Integer> list3 = this.getDefaultSoftMargins();
        if (list3 == null) {
            CodeStyleSettings.$$$reportNull$$$0(50);
        }
        return list3;
    }

    public void setSoftMargins(@NotNull Language language, @NotNull List<Integer> softMargins) {
        if (language == null) {
            CodeStyleSettings.$$$reportNull$$$0(51);
        }
        if (softMargins == null) {
            CodeStyleSettings.$$$reportNull$$$0(52);
        }
        CommonCodeStyleSettings languageSettings = this.myCommonSettingsManager.getCommonSettings(language);
        assert (languageSettings != null) : "Settings for language " + language.getDisplayName() + " do not exist";
        languageSettings.setSoftMargins(softMargins);
    }

    @NotNull
    public List<Integer> getDefaultSoftMargins() {
        List<Integer> list2 = this.mySoftMargins.getValues();
        if (list2 == null) {
            CodeStyleSettings.$$$reportNull$$$0(53);
        }
        return list2;
    }

    public void setDefaultSoftMargins(@NotNull List<Integer> softMargins) {
        if (softMargins == null) {
            CodeStyleSettings.$$$reportNull$$$0(54);
        }
        this.mySoftMargins.setValues(softMargins);
    }

    @NotNull
    public ExcludedFiles getExcludedFiles() {
        ExcludedFiles excludedFiles = this.myExcludedFiles;
        if (excludedFiles == null) {
            CodeStyleSettings.$$$reportNull$$$0(55);
        }
        return excludedFiles;
    }

    @NotNull
    public SimpleModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            CodeStyleSettings.$$$reportNull$$$0(56);
        }
        return simpleModificationTracker;
    }

    @ApiStatus.Internal
    public void removeCommonSettings(@NotNull LanguageCodeStyleProvider provider) {
        if (provider == null) {
            CodeStyleSettings.$$$reportNull$$$0(57);
        }
        this.myCommonSettingsManager.removeLanguageSettings(provider);
    }

    @ApiStatus.Internal
    public void registerCommonSettings(@NotNull LanguageCodeStyleProvider provider) {
        if (provider == null) {
            CodeStyleSettings.$$$reportNull$$$0(58);
        }
        this.myCommonSettingsManager.addLanguageSettings(provider);
    }

    @ApiStatus.Internal
    public void removeCustomSettings(@NotNull CustomCodeStyleSettingsFactory factory) {
        if (factory == null) {
            CodeStyleSettings.$$$reportNull$$$0(59);
        }
        this.myCustomCodeStyleSettingsManager.unregisterCustomSettings(factory);
    }

    @ApiStatus.Internal
    public void registerCustomSettings(@NotNull CustomCodeStyleSettingsFactory factory) {
        if (factory == null) {
            CodeStyleSettings.$$$reportNull$$$0(60);
        }
        this.myCustomCodeStyleSettingsManager.registerCustomSettings(this, factory);
    }

    @NotNull
    CustomCodeStyleSettingsManager getCustomCodeStyleSettingsManager() {
        CustomCodeStyleSettingsManager customCodeStyleSettingsManager = this.myCustomCodeStyleSettingsManager;
        if (customCodeStyleSettingsManager == null) {
            CodeStyleSettings.$$$reportNull$$$0(61);
        }
        return customCodeStyleSettingsManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 8, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 29, 32, 33, 34, 35, 44, 45, 47, 48, 49, 50, 53, 55, 56, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repeatAnnotations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerText";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILETYPE;
                break;
            }
            case 21: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provided";
                break;
            }
            case 43: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langName";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "softMargins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConfigurableIdByLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepeatAnnotations";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByDocument";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByFile";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeIndentOptions";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaults";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftMargins";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSoftMargins";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedFiles";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomCodeStyleSettingsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateConfigurableIdByLanguage";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 61: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setParentSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettingsIfCreated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyCustomSettingsFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setRepeatAnnotations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPatternOrDisableRegexp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultIndentOptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsByDocument";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsByFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isFileFullyCoveredByRange";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "logIndentOptions";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageIndentOptions";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredFileType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAdditionalIndentOptions";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeIndentOptions";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSettings";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setSoftMargins";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultSoftMargins";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonSettings";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "registerCommonSettings";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomSettings";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 8, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 29, 32, 33, 34, 35, 44, 45, 47, 48, 49, 50, 53, 55, 56, 61 -> new IllegalStateException(string);
        };
    }

    private static final class TempFileType
    implements FileType {
        private final String myExtension;

        private TempFileType(@NotNull String extension) {
            if (extension == null) {
                TempFileType.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
        }

        @NotNull
        public String getName() {
            return "TempFileType";
        }

        @NotNull
        @NonNls
        public String getDescription() {
            return "TempFileType";
        }

        @NotNull
        public String getDefaultExtension() {
            String string = this.myExtension;
            if (string == null) {
                TempFileType.$$$reportNull$$$0(1);
            }
            return string;
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isBinary() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class DefaultsHolder {
        private static final CodeStyleSettings myDefaults = (CodeStyleSettings)Cancellation.forceNonCancellableSectionInClassInitializer(() -> new CodeStyleSettings(true, false));

        private DefaultsHolder() {
        }
    }

    public static enum QuoteStyle implements PresentableEnum
    {
        Single("'", CodeStyleBundle.messagePointer("quote.style.single", new Object[0])),
        Double("\"", CodeStyleBundle.messagePointer("quote.style.double", new Object[0])),
        None("", CodeStyleBundle.messagePointer("quote.style.none", new Object[0]));

        public final String quote;
        private final Supplier<@NlsContexts.Label String> myDescription;

        private QuoteStyle(String quote, Supplier<String> description) {
            if (quote == null) {
                QuoteStyle.$$$reportNull$$$0(0);
            }
            if (description == null) {
                QuoteStyle.$$$reportNull$$$0(1);
            }
            this.quote = quote;
            this.myDescription = description;
        }

        @NlsContexts.Label
        @NotNull
        public String getPresentableText() {
            String string = this.myDescription.get();
            if (string == null) {
                QuoteStyle.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quote";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettings$QuoteStyle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettings$QuoteStyle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static enum HtmlTagNewLineStyle implements PresentableEnum
    {
        Never("Never", CodeStyleBundle.messagePointer("html.tag.new.line.never", new Object[0])),
        WhenMultiline("When multiline", CodeStyleBundle.messagePointer("html.tag.new.line.when.multiline", new Object[0]));

        private final String myValue;
        private final Supplier<@NlsContexts.Label String> myDescription;

        private HtmlTagNewLineStyle(String value, Supplier<String> description) {
            if (value == null) {
                HtmlTagNewLineStyle.$$$reportNull$$$0(0);
            }
            if (description == null) {
                HtmlTagNewLineStyle.$$$reportNull$$$0(1);
            }
            this.myValue = value;
            this.myDescription = description;
        }

        public String toString() {
            return this.myValue;
        }

        @NlsContexts.Label
        @NotNull
        public String getPresentableText() {
            String string = this.myDescription.get();
            if (string == null) {
                HtmlTagNewLineStyle.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettings$HtmlTagNewLineStyle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettings$HtmlTagNewLineStyle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static enum WrapStyle implements PresentableEnum
    {
        DO_NOT_WRAP(0, CodeStyleBundle.messagePointer("wrapping.do.not.wrap", new Object[0])),
        WRAP_AS_NEEDED(1, CodeStyleBundle.messagePointer("wrapping.wrap.if.long", new Object[0])),
        WRAP_ON_EVERY_ITEM(4, CodeStyleBundle.messagePointer("wrapping.chop.down.if.long", new Object[0])),
        WRAP_ALWAYS(2, CodeStyleBundle.messagePointer("wrapping.wrap.always", new Object[0]));

        private final int myId;
        private final @NotNull Supplier<@NlsContexts.Label String> myDescription;

        private WrapStyle(int id, Supplier<String> description) {
            if (description == null) {
                WrapStyle.$$$reportNull$$$0(0);
            }
            this.myId = id;
            this.myDescription = description;
        }

        public int getId() {
            return this.myId;
        }

        @NlsContexts.Label
        @NotNull
        public String getPresentableText() {
            String string = this.myDescription.get();
            if (string == null) {
                WrapStyle.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public static WrapStyle forWrapping(int wrappingStyleID) {
            for (WrapStyle style : WrapStyle.values()) {
                if (style.myId != wrappingStyleID) continue;
                WrapStyle wrapStyle = style;
                if (wrapStyle == null) {
                    WrapStyle.$$$reportNull$$$0(2);
                }
                return wrapStyle;
            }
            LOG.error("Invalid wrapping option index: " + wrappingStyleID);
            WrapStyle wrapStyle = DO_NOT_WRAP;
            if (wrapStyle == null) {
                WrapStyle.$$$reportNull$$$0(3);
            }
            return wrapStyle;
        }

        public static int getId(@Nullable WrapStyle wrapStyle) {
            return Optional.ofNullable(wrapStyle).orElse((WrapStyle)WrapStyle.DO_NOT_WRAP).myId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettings$WrapStyle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettings$WrapStyle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forWrapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

