/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PresentableId;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SshConfigCredentialsHolder {
    @NonNls
    private static final String SSH_CREDENTIALS_ID = "SSH_CREDENTIALS_ID";
    @NonNls
    private static final String SSH_CONFIG_NAME = "SSH_CONFIG_NAME";
    @NonNls
    private static final String SSH_CONFIG_ID = "SSH_CONFIG_ID";
    @NonNls
    public static final String SSH_CONFIG_PREFIX = "sshConfig://";
    @NotNull
    private String myCredentialsId;
    @Nullable
    private PresentableId mySshId;

    public SshConfigCredentialsHolder() {
        this(null);
    }

    public SshConfigCredentialsHolder(@Nullable PresentableId presentableId) {
        this.mySshId = presentableId;
        this.myCredentialsId = this.constructCredentialsId();
    }

    @NotNull
    public String getCredentialsId() {
        String string = this.myCredentialsId;
        if (string == null) {
            SshConfigCredentialsHolder.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public PresentableId getSshId() {
        return this.mySshId;
    }

    public void setSshId(@Nullable PresentableId sshId) {
        this.mySshId = sshId;
    }

    public void save(@NotNull Element element) {
        if (element == null) {
            SshConfigCredentialsHolder.$$$reportNull$$$0(1);
        }
        if (this.mySshId != null) {
            if (this.mySshId.getId() != null) {
                element.setAttribute(SSH_CONFIG_ID, this.mySshId.getId());
            }
            if (this.mySshId.getName() != null) {
                element.setAttribute(SSH_CONFIG_NAME, this.mySshId.getName());
            }
        }
        element.setAttribute(SSH_CREDENTIALS_ID, StringUtil.notNullize((String)this.myCredentialsId));
    }

    public void load(@NotNull Element element) {
        if (element == null) {
            SshConfigCredentialsHolder.$$$reportNull$$$0(2);
        }
        this.mySshId = PresentableId.createId(element.getAttributeValue(SSH_CONFIG_ID), element.getAttributeValue(SSH_CONFIG_NAME));
        String credentialsId = element.getAttributeValue(SSH_CREDENTIALS_ID);
        this.myCredentialsId = credentialsId == null ? this.constructCredentialsId() : credentialsId;
    }

    public void cleanConfigData() {
        this.mySshId = null;
        this.myCredentialsId = this.constructCredentialsId();
    }

    @NonNls
    @NotNull
    private String constructCredentialsId() {
        String string = SSH_CONFIG_PREFIX + (this.mySshId == null || this.mySshId.getName() == null ? "<unknown>" : this.mySshId.getName());
        if (string == null) {
            SshConfigCredentialsHolder.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void copyFrom(SshConfigCredentialsHolder credentials) {
        this.myCredentialsId = credentials.myCredentialsId;
        this.mySshId = credentials.mySshId == null ? null : credentials.mySshId.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SshConfigCredentialsHolder)) {
            return false;
        }
        SshConfigCredentialsHolder holder = (SshConfigCredentialsHolder)o;
        return this.myCredentialsId.equals(holder.myCredentialsId) && Objects.equals(this.mySshId, holder.mySshId);
    }

    public int hashCode() {
        int result2 = this.myCredentialsId.hashCode();
        result2 = 31 * result2 + Objects.hashCode(this.mySshId);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/SshConfigCredentialsHolder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/SshConfigCredentialsHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "constructCredentialsId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

