/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VagrantBasedCredentialsHolder {
    @NonNls
    private static final String VAGRANT_FOLDER = "VAGRANT_FOLDER";
    @NonNls
    private static final String MACHINE_NAME = "MACHINE_NAME";
    @NotNull
    private String myVagrantFolder;
    private String myMachineName;

    public VagrantBasedCredentialsHolder() {
        this.myVagrantFolder = "";
    }

    public VagrantBasedCredentialsHolder(@NotNull String vagrantFolder, @Nullable String machineName) {
        if (vagrantFolder == null) {
            VagrantBasedCredentialsHolder.$$$reportNull$$$0(0);
        }
        this.myVagrantFolder = vagrantFolder;
        this.myMachineName = machineName;
    }

    public void setVagrantFolder(@NotNull String vagrantFolder) {
        if (vagrantFolder == null) {
            VagrantBasedCredentialsHolder.$$$reportNull$$$0(1);
        }
        this.myVagrantFolder = vagrantFolder;
    }

    @NotNull
    public String getVagrantFolder() {
        String string = this.myVagrantFolder;
        if (string == null) {
            VagrantBasedCredentialsHolder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getMachineName() {
        return this.myMachineName;
    }

    public void setMachineName(String machineName) {
        this.myMachineName = machineName;
    }

    public void load(Element element) {
        String folder = StringUtil.notNullize((String)element.getAttributeValue(VAGRANT_FOLDER));
        this.setVagrantFolder(PathUtil.toSystemDependentName((String)folder));
        this.setMachineName(element.getAttributeValue(MACHINE_NAME));
    }

    public void save(Element element) {
        element.setAttribute(VAGRANT_FOLDER, PathUtil.toSystemIndependentName((String)this.getVagrantFolder()));
        if (StringUtil.isNotEmpty((String)this.getMachineName())) {
            element.setAttribute(MACHINE_NAME, this.getMachineName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VagrantBasedCredentialsHolder holder = (VagrantBasedCredentialsHolder)o;
        if (!this.myVagrantFolder.equals(holder.myVagrantFolder)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myMachineName) || StringUtil.isNotEmpty((String)holder.myMachineName)) {
            return StringUtil.equals((CharSequence)this.myMachineName, (CharSequence)holder.myMachineName);
        }
        return true;
    }

    public int hashCode() {
        int result2 = this.myVagrantFolder.hashCode();
        result2 = 31 * result2 + (this.myMachineName != null ? this.myMachineName.hashCode() : 0);
        return result2;
    }

    @NonNls
    public String toString() {
        return "VagrantBasedCredentialsHolder{myVagrantFolder='" + this.myVagrantFolder + "', myMachineName='" + this.myMachineName + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/VagrantBasedCredentialsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/VagrantBasedCredentialsHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setVagrantFolder";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

