/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion;

import com.intellij.codeInsight.inline.completion.InlineCompletionEditorInsertHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/inline/completion/InlineCompletionEditorInsertHandlerImpl;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEditorInsertHandler;", "<init>", "()V", "insert", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "textToInsert", "", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "isApplicable", "", "intellij.platform.inline.completion"})
public final class InlineCompletionEditorInsertHandlerImpl
implements InlineCompletionEditorInsertHandler {
    @RequiresWriteLock
    public void insert(@NotNull Editor editor, @NotNull String textToInsert, int offset, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textToInsert, (String)"textToInsert");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertWriteAccess();
        editor.getDocument().insertString(offset, (CharSequence)textToInsert);
        editor.getCaretModel().moveToOffset(textToInsert.length() + offset);
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
    }

    public boolean isApplicable(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return true;
    }
}

