/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFileIndexFacade
extends FileIndexFacade {
    private final ProjectFileIndex myFileIndex;
    private final WorkspaceFileIndexEx myWorkspaceFileIndex;

    @NonInjectable
    @ApiStatus.Internal
    public ProjectFileIndexFacade(Project project, ProjectFileIndex projectFileIndex, WorkspaceFileIndexEx workspaceFileIndex) {
        super(project);
        this.myFileIndex = projectFileIndex;
        this.myWorkspaceFileIndex = workspaceFileIndex;
    }

    @ApiStatus.Internal
    public ProjectFileIndexFacade(@NotNull Project project) {
        if (project == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(0);
        }
        super(project);
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myWorkspaceFileIndex = (WorkspaceFileIndexEx)WorkspaceFileIndex.getInstance(project);
    }

    public boolean isInContent(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(1);
        }
        return this.myFileIndex.isInContent(file);
    }

    public boolean isInSource(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(2);
        }
        return this.myFileIndex.isInSource(file);
    }

    public boolean isInSourceContent(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(3);
        }
        return this.myFileIndex.isInSourceContent(file);
    }

    public boolean isInLibrary(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(4);
        }
        return this.myFileIndex.isInLibrary(file);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(5);
        }
        return this.myFileIndex.isInLibraryClasses(file);
    }

    public boolean isInLibrarySource(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(6);
        }
        return this.myFileIndex.isInLibrarySource(file);
    }

    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(7);
        }
        return this.myFileIndex.isExcluded(file);
    }

    @ApiStatus.Internal
    public boolean isUnderSourceRootOfType(@NotNull VirtualFile file, @NotNull Set<?> rootTypes) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(8);
        }
        if (rootTypes == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(9);
        }
        return this.myFileIndex.isUnderSourceRootOfType(file, rootTypes);
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(10);
        }
        return this.myFileIndex.isUnderIgnored(file);
    }

    @ApiStatus.Experimental
    public boolean isIndexable(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(11);
        }
        return this.myWorkspaceFileIndex.isIndexable(file);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(12);
        }
        return this.myFileIndex.getModuleForFile(file);
    }

    public boolean isValidAncestor(@NotNull VirtualFile baseDir, @NotNull VirtualFile childDir) {
        if (baseDir == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(13);
        }
        if (childDir == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(14);
        }
        if (!childDir.isDirectory()) {
            childDir = childDir.getParent();
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        while (childDir != null) {
            if (childDir.equals(baseDir)) {
                return true;
            }
            if (!fileIndex.isInProject(childDir)) {
                return false;
            }
            childDir = childDir.getParent();
        }
        return false;
    }

    @NotNull
    public ModificationTracker getRootModificationTracker() {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        if (projectRootManager == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(15);
        }
        return projectRootManager;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        Collection collection = ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescriptions();
        if (collection == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(16);
        }
        return collection;
    }

    public boolean isInProjectScope(@NotNull VirtualFile file) {
        WorkspaceFileInternalInfo fileInfo;
        if (file == null) {
            ProjectFileIndexFacade.$$$reportNull$$$0(17);
        }
        if ((fileInfo = this.myWorkspaceFileIndex.getFileInfo(file, true, true, true, true, false, false)) instanceof WorkspaceFileInternalInfo.NonWorkspace) {
            return false;
        }
        return fileInfo.findFileSet(it -> it.getKind() == WorkspaceFileKind.EXTERNAL) == null || this.myFileIndex.isInSourceContent(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDir";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectFileIndexFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectFileIndexFacade";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModificationTracker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModuleDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInSource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnderIgnored";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIndexable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValidAncestor";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16 -> new IllegalStateException(string);
        };
    }
}

