/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleRelatedRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.NonIncrementalContributors;
import com.intellij.workspaceModel.core.fileIndex.impl.SdkEntityFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetRecognizer;", "", "<init>", "()V", "getModuleForContent", "Lcom/intellij/openapi/module/Module;", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "getEntityPointer", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "getLibraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "getSdkId", "Lcom/intellij/platform/workspace/jps/entities/SdkId;", "isFromAdditionalLibraryRootsProvider", "", "isSourceRoot", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFileSetRecognizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFileSetRecognizer.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetRecognizer\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n19#2:61\n19#2:62\n19#2:64\n23#3:63\n*S KotlinDebug\n*F\n+ 1 WorkspaceFileSetRecognizer.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetRecognizer\n*L\n20#1:61\n24#1:62\n50#1:64\n43#1:63\n*E\n"})
public final class WorkspaceFileSetRecognizer {
    @NotNull
    public static final WorkspaceFileSetRecognizer INSTANCE = new WorkspaceFileSetRecognizer();

    private WorkspaceFileSetRecognizer() {
    }

    @Nullable
    public final Module getModuleForContent(@NotNull WorkspaceFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        if (fileSet.getKind() != WorkspaceFileKind.CONTENT && fileSet.getKind() != WorkspaceFileKind.TEST_CONTENT) {
            return null;
        }
        WorkspaceFileSet $this$asSafely$iv = fileSet;
        boolean $i$f$asSafely = false;
        WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
        if (!(workspaceFileSet instanceof WorkspaceFileSetWithCustomData)) {
            workspaceFileSet = null;
        }
        WorkspaceFileSetWithCustomData workspaceFileSetWithCustomData = (WorkspaceFileSetWithCustomData)workspaceFileSet;
        Object $this$asSafely$iv2 = workspaceFileSetWithCustomData != null ? workspaceFileSetWithCustomData.getData() : null;
        boolean $i$f$asSafely2 = false;
        Object d = $this$asSafely$iv2;
        if (!(d instanceof ModuleRelatedRootData)) {
            d = null;
        }
        ModuleRelatedRootData moduleRelatedRootData = (ModuleRelatedRootData)d;
        return moduleRelatedRootData != null ? moduleRelatedRootData.getModule() : null;
    }

    @Nullable
    public final EntityPointer<?> getEntityPointer(@NotNull WorkspaceFileSet fileSet) {
        EntityPointer<WorkspaceEntity> entityReference;
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        WorkspaceFileSet $this$asSafely$iv = fileSet;
        boolean $i$f$asSafely = false;
        WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
        if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
            workspaceFileSet = null;
        }
        WorkspaceFileSetImpl workspaceFileSetImpl = (WorkspaceFileSetImpl)workspaceFileSet;
        Object object = entityReference = workspaceFileSetImpl != null ? workspaceFileSetImpl.getEntityPointer() : null;
        if (entityReference == null) {
            return null;
        }
        if (NonIncrementalContributors.Companion.isPlaceholderReference(entityReference)) {
            return null;
        }
        return entityReference;
    }

    @Nullable
    public final LibraryId getLibraryId(@NotNull WorkspaceFileSet fileSet, @NotNull EntityStorage storage) {
        LibraryRootFileSetData libraryRootFileSetData;
        WorkspaceFileSetImpl fileSetImpl;
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        WorkspaceFileSetImpl workspaceFileSetImpl = fileSetImpl = fileSet instanceof WorkspaceFileSetImpl ? (WorkspaceFileSetImpl)fileSet : null;
        if (fileSetImpl == null) {
            return null;
        }
        WorkspaceFileSetData workspaceFileSetData = fileSetImpl.getData();
        LibraryRootFileSetData libraryRootFileSetData2 = libraryRootFileSetData = workspaceFileSetData instanceof LibraryRootFileSetData ? (LibraryRootFileSetData)workspaceFileSetData : null;
        if (libraryRootFileSetData == null) {
            return null;
        }
        LibraryId libraryId = LibraryRootFileIndexContributor.Util.INSTANCE.getLibraryId$intellij_platform_projectModel_impl(fileSetImpl.getData());
        if (libraryId != null) {
            return libraryId;
        }
        LibraryId moduleLibraryId = LibraryRootFileIndexContributor.Util.INSTANCE.getModuleLibraryId$intellij_platform_projectModel_impl(fileSetImpl, storage);
        WorkspaceFileSetRecognizer $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WorkspaceFileSetRecognizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.assertTrue(moduleLibraryId != null, () -> WorkspaceFileSetRecognizer.getLibraryId$lambda$0(fileSet));
        return moduleLibraryId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final SdkId getSdkId(@NotNull WorkspaceFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        WorkspaceFileSet $this$asSafely$iv = fileSet;
        boolean $i$f$asSafely = false;
        WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
        if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
            workspaceFileSet = null;
        }
        WorkspaceFileSetImpl workspaceFileSetImpl = (WorkspaceFileSetImpl)workspaceFileSet;
        Object object = workspaceFileSetImpl;
        if (workspaceFileSetImpl == null) return null;
        WorkspaceFileSetData workspaceFileSetData = ((WorkspaceFileSetImpl)object).getData();
        object = workspaceFileSetData;
        if (workspaceFileSetData == null) return null;
        Object $this$asSafely$iv2 = object;
        boolean $i$f$asSafely2 = false;
        Object object2 = $this$asSafely$iv2;
        if (!(object2 instanceof SdkEntityFileIndexContributor.SdkRootFileSetData)) {
            object2 = null;
        }
        SdkEntityFileIndexContributor.SdkRootFileSetData sdkRootFileSetData = (SdkEntityFileIndexContributor.SdkRootFileSetData)object2;
        object = sdkRootFileSetData;
        if (sdkRootFileSetData == null) return null;
        SdkId sdkId = ((SdkEntityFileIndexContributor.SdkRootFileSetData)object).getSdkId$intellij_platform_projectModel_impl();
        return sdkId;
    }

    public final boolean isFromAdditionalLibraryRootsProvider(@NotNull WorkspaceFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        return NonIncrementalContributors.Companion.isFromAdditionalLibraryRootsProvider$intellij_platform_projectModel_impl(fileSet);
    }

    public final boolean isSourceRoot(@NotNull WorkspaceFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        WorkspaceFileSetImpl workspaceFileSetImpl = fileSet instanceof WorkspaceFileSetImpl ? (WorkspaceFileSetImpl)fileSet : null;
        return (workspaceFileSetImpl != null ? workspaceFileSetImpl.getData() : null) instanceof ModuleSourceRootData;
    }

    private static final String getLibraryId$lambda$0(WorkspaceFileSet $fileSet) {
        return "Failed to find libraryId for " + $fileSet;
    }
}

