/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.completion.spec.impl;

import com.intellij.terminal.completion.spec.ShellCommandResult;
import com.intellij.terminal.completion.spec.ShellDataGeneratorProcessBuilder;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellDataGeneratorProcessExecutor;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellDataGeneratorProcessOptionsImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u001c\u0010\f\u001a\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellDataGeneratorProcessBuilderImpl;", "Lcom/intellij/terminal/completion/spec/ShellDataGeneratorProcessBuilder;", "executable", "", "defaultWorkingDirectory", "executor", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellDataGeneratorProcessExecutor;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellDataGeneratorProcessExecutor;)V", "args", "", "workingDirectory", "env", "", "execute", "Lcom/intellij/terminal/completion/spec/ShellCommandResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.terminal"})
public final class ShellDataGeneratorProcessBuilderImpl
implements ShellDataGeneratorProcessBuilder {
    @NotNull
    private final String executable;
    @NotNull
    private final ShellDataGeneratorProcessExecutor executor;
    @NotNull
    private List<String> args;
    @NotNull
    private String workingDirectory;
    @NotNull
    private Map<String, String> env;

    public ShellDataGeneratorProcessBuilderImpl(@NotNull String executable, @NotNull String defaultWorkingDirectory, @NotNull ShellDataGeneratorProcessExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)defaultWorkingDirectory, (String)"defaultWorkingDirectory");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executable = executable;
        this.executor = executor;
        this.args = CollectionsKt.emptyList();
        this.workingDirectory = defaultWorkingDirectory;
        this.env = MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public ShellDataGeneratorProcessBuilder args(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.args = args;
        return this;
    }

    @Override
    @NotNull
    public ShellDataGeneratorProcessBuilder workingDirectory(@NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        this.workingDirectory = workingDirectory;
        return this;
    }

    @Override
    @NotNull
    public ShellDataGeneratorProcessBuilder env(@NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter(env, (String)"env");
        this.env = env;
        return this;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super ShellCommandResult> $completion) {
        ShellDataGeneratorProcessOptionsImpl options = new ShellDataGeneratorProcessOptionsImpl(this.executable, this.args, this.workingDirectory, this.env);
        return this.executor.executeProcess(options, $completion);
    }
}

