/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.view.shellIntegration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandBlock;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"getTypedCommandText", "", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalCommandBlock;", "model", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "getOutputText", "wasExecuted", "", "getWasExecuted", "(Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalCommandBlock;)Z", "intellij.terminal"})
public final class TerminalBlocksKt {
    @ApiStatus.Experimental
    @Nullable
    public static final String getTypedCommandText(@NotNull TerminalCommandBlock $this$getTypedCommandText, @NotNull TerminalOutputModel model) {
        TerminalOffset end;
        Intrinsics.checkNotNullParameter((Object)$this$getTypedCommandText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        TerminalOffset terminalOffset = $this$getTypedCommandText.getCommandStartOffset();
        if (terminalOffset == null) {
            return null;
        }
        TerminalOffset start2 = terminalOffset;
        TerminalOffset terminalOffset2 = $this$getTypedCommandText.getOutputStartOffset();
        if (terminalOffset2 == null) {
            terminalOffset2 = end = $this$getTypedCommandText.getEndOffset();
        }
        if (start2.compareTo(model.getStartOffset()) < 0 || start2.compareTo(model.getEndOffset()) > 0 || end.compareTo(model.getStartOffset()) < 0 || end.compareTo(model.getEndOffset()) > 0 || start2.compareTo(end) > 0) {
            return null;
        }
        return ((Object)StringsKt.trimEnd((CharSequence)((Object)model.getText(start2, end)).toString())).toString();
    }

    @ApiStatus.Experimental
    @Nullable
    public static final String getOutputText(@NotNull TerminalCommandBlock $this$getOutputText, @NotNull TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)$this$getOutputText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        TerminalOffset terminalOffset = $this$getOutputText.getOutputStartOffset();
        if (terminalOffset == null || (terminalOffset = (TerminalOffset)RangesKt.coerceAtLeast((Comparable)terminalOffset, (Comparable)model.getStartOffset())) == null) {
            return null;
        }
        TerminalOffset start2 = terminalOffset;
        TerminalOffset end = $this$getOutputText.getEndOffset();
        if (start2.compareTo(model.getStartOffset()) < 0 || start2.compareTo(model.getEndOffset()) > 0 || end.compareTo(model.getStartOffset()) < 0 || end.compareTo(model.getEndOffset()) > 0 || start2.compareTo(end) > 0) {
            return null;
        }
        return ((Object)StringsKt.trimEnd((CharSequence)((Object)model.getText(start2, end)).toString())).toString();
    }

    @ApiStatus.Experimental
    public static final boolean getWasExecuted(@NotNull TerminalCommandBlock $this$wasExecuted) {
        Intrinsics.checkNotNullParameter((Object)$this$wasExecuted, (String)"<this>");
        return $this$wasExecuted.getOutputStartOffset() != null;
    }
}

