/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.ProxySimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J0\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0000H\u0014J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/diff/merge/TextMergeViewer;", "Lcom/intellij/diff/merge/MergeTool$MergeViewer;", "mergeContext", "Lcom/intellij/diff/merge/MergeContext;", "mergeRequest", "Lcom/intellij/diff/merge/TextMergeRequest;", "<init>", "(Lcom/intellij/diff/merge/MergeContext;Lcom/intellij/diff/merge/TextMergeRequest;)V", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "getViewer", "()Lcom/intellij/diff/merge/MergeThreesideViewer;", "cancelResolveAction", "Ljavax/swing/Action;", "kotlin.jvm.PlatformType", "leftResolveAction", "rightResolveAction", "acceptResolveAction", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "init", "Lcom/intellij/diff/merge/MergeTool$ToolbarComponents;", "getResolveAction", "result", "Lcom/intellij/diff/merge/MergeResult;", "dispose", "", "loadThreeSideViewer", "context", "Lcom/intellij/diff/DiffContext;", "request", "Lcom/intellij/diff/requests/ContentDiffRequest;", "mergeViewer", "createMergeThreesideViewer", "Companion", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public class TextMergeViewer
implements MergeTool.MergeViewer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MergeContext mergeContext;
    @NotNull
    private final TextMergeRequest mergeRequest;
    @NotNull
    private final MergeThreesideViewer viewer;
    private final Action cancelResolveAction;
    private final Action leftResolveAction;
    private final Action rightResolveAction;
    private final Action acceptResolveAction;

    public TextMergeViewer(@NotNull MergeContext mergeContext, @NotNull TextMergeRequest mergeRequest) {
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        Intrinsics.checkNotNullParameter((Object)mergeRequest, (String)"mergeRequest");
        this.mergeContext = mergeContext;
        this.mergeRequest = mergeRequest;
        this.viewer = this.createMergeThreesideViewer(this.mergeContext, this.mergeRequest);
        this.cancelResolveAction = this.viewer.getLoadedResolveAction(MergeResult.CANCEL);
        this.leftResolveAction = this.viewer.getLoadedResolveAction(MergeResult.LEFT);
        this.rightResolveAction = this.viewer.getLoadedResolveAction(MergeResult.RIGHT);
        this.acceptResolveAction = this.viewer.getLoadedResolveAction(MergeResult.RESOLVED);
    }

    @NotNull
    public final MergeThreesideViewer getViewer() {
        return this.viewer;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.viewer.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.viewer.getPreferredFocusedComponent();
    }

    @NotNull
    public MergeTool.ToolbarComponents init() {
        MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
        FrameDiffTool.ToolbarComponents toolbarComponents = this.viewer.init();
        Intrinsics.checkNotNullExpressionValue((Object)toolbarComponents, (String)"init(...)");
        FrameDiffTool.ToolbarComponents init2 = toolbarComponents;
        components.statusPanel = init2.statusPanel;
        components.toolbarActions = init2.toolbarActions;
        components.closeHandler = () -> TextMergeViewer.init$lambda$0(this);
        return components;
    }

    @Nullable
    public Action getResolveAction(@NotNull MergeResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
            case 1 -> this.cancelResolveAction;
            case 2 -> this.leftResolveAction;
            case 3 -> this.rightResolveAction;
            case 4 -> this.acceptResolveAction;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.viewer));
    }

    @NotNull
    protected MergeThreesideViewer loadThreeSideViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull MergeContext mergeContext, @NotNull TextMergeRequest mergeRequest, @NotNull TextMergeViewer mergeViewer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        Intrinsics.checkNotNullParameter((Object)mergeRequest, (String)"mergeRequest");
        Intrinsics.checkNotNullParameter((Object)mergeViewer, (String)"mergeViewer");
        return new MergeThreesideViewer(context, request, mergeContext, mergeRequest, mergeViewer);
    }

    private final MergeThreesideViewer createMergeThreesideViewer(MergeContext mergeContext, TextMergeRequest mergeRequest) {
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(mergeContext);
        ProxySimpleDiffRequest diffRequest = new ProxySimpleDiffRequest(mergeRequest.getTitle(), TextMergeViewer.Companion.getDiffContents(mergeRequest), TextMergeViewer.Companion.getDiffContentTitles(mergeRequest), (UserDataHolder)mergeRequest);
        boolean[] blArray = new boolean[]{true, false, true};
        diffRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)blArray);
        return this.loadThreeSideViewer(diffContext, (ContentDiffRequest)diffRequest, mergeContext, mergeRequest, this);
    }

    private static final boolean init$lambda$0(TextMergeViewer this$0) {
        boolean bl;
        boolean it = bl = MergeUtil.showExitWithoutApplyingChangesDialog(this$0, (MergeRequest)this$0.mergeRequest, this$0.mergeContext, this$0.viewer.isContentModified());
        boolean bl2 = false;
        this$0.viewer.logMergeCancelled(this$0.viewer.myContentModified, it);
        return bl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diff/merge/TextMergeViewer$Companion;", "", "<init>", "()V", "getDiffContents", "", "Lcom/intellij/diff/contents/DiffContent;", "mergeRequest", "Lcom/intellij/diff/merge/TextMergeRequest;", "getDiffContentTitles", "", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final List<DiffContent> getDiffContents(TextMergeRequest mergeRequest) {
            List list = mergeRequest.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
            List contents = list;
            DocumentContent left = (DocumentContent)ThreeSide.LEFT.select(contents);
            DocumentContent right = (DocumentContent)ThreeSide.RIGHT.select(contents);
            DocumentContent documentContent = mergeRequest.getOutputContent();
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"getOutputContent(...)");
            DocumentContent output = documentContent;
            Object[] objectArray = new DiffContent[]{left, output, right};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final List<String> getDiffContentTitles(TextMergeRequest mergeRequest) {
            List<String> list = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
            Intrinsics.checkNotNullExpressionValue(list, (String)"notNullizeContentTitles(...)");
            List<String> titles = list;
            titles.set(ThreeSide.BASE.getIndex(), DiffBundle.message((String)"merge.version.title.merged.result", (Object[])new Object[0]));
            return titles;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MergeResult.values().length];
            try {
                nArray[MergeResult.CANCEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MergeResult.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MergeResult.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MergeResult.RESOLVED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

