/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtilKmp;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FreezableArrayList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.MergingCharSequence;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public class StringUtil {
    public static final String ELLIPSIS = "\u2026";
    public static final String THREE_DOTS = "...";
    public static final String NON_BREAK_SPACE = "\u00a0";
    public static final Function<String, String> QUOTER = s -> "\"" + s + "\"";
    public static final Function<String, String> SINGLE_QUOTER = s -> "'" + s + "'";
    private static final String[] ourLowerCaseWords = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "in", "into", "near", "nor", "of", "on", "onto", "or", "out", "over", "per", "so", "the", "to", "until", "unto", "up", "upon", "via", "with"};
    private static final String[] ourOtherNonCapitalizableWords = new String[]{"iOS", "iPhone", "iPad", "iMac", "macOS"};
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public StringUtil() {
    }

    @Contract(pure=true)
    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        return new MergingCharSequence(new MergingCharSequence(new CharSequenceSubSequence(charSeq, 0, start), replacement), new CharSequenceSubSequence(charSeq, end, charSeq.length()));
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> getWordsInStringLongestFirst(@NotNull String find) {
        if (find == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        List<String> words = StringUtil.getWordsIn(find);
        List<String> list = ContainerUtil.sorted(words, (o1, o2) -> o2.length() - o1.length());
        if (list == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapePattern(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        return StringUtil.replace(StringUtil.replace(text, "'", "''"), "{", "'{'");
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull String oldS, @NotNull String newS) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        String string = StringUtil.replace(text, oldS, newS, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String replaceIgnoreCase(@NotNull String text, @NotNull String oldS, @NotNull String newS) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        String string = StringUtil.replace(text, oldS, newS, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        String string = buffer.replace(oldChar, newChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull String oldS, @NotNull String newS, boolean ignoreCase) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        if (text.length() < oldS.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text, oldS, i) : text.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newText == null) {
                if (text.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text.length() - i);
            }
            newText.append(text, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where2, @NotNull String what, int fromIndex) {
        if (where2 == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        return Strings.indexOfIgnoreCase(where2, what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where2, @NotNull CharSequence what, int fromIndex) {
        if (where2 == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        return Strings.indexOfIgnoreCase(where2, what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where2, char what, int fromIndex) {
        if (where2 == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        return Strings.indexOfIgnoreCase(where2, what, fromIndex);
    }

    @Contract(pure=true)
    public static int lastIndexOfIgnoreCase(@NotNull String where2, char c, int fromIndex) {
        if (where2 == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        for (int i = Math.min(fromIndex, where2.length() - 1); i >= 0; --i) {
            if (!StringUtil.charsEqualIgnoreCase(where2.charAt(i), c)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where2, @NotNull String what) {
        if (where2 == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(25);
        }
        return StringUtil.indexOfIgnoreCase(where2, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        return Strings.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return StringUtilRt.startsWithIgnoreCase((String)str, (String)prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        return StringUtil.stripHtml(html, convertBreaks ? "\n\n" : null);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, @Nullable String breaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        if (breaks != null) {
            html = HtmlPatterns.BREAKS_PATTERN.matcher(html).replaceAll(breaks);
        }
        String string = HtmlPatterns.HTML_PATTERN.matcher(html).replaceAll("");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return Strings.toLowerCase(str);
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(33);
        }
        return StringUtil.getPackageName(fqName, '.');
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String getPackageName(@NotNull String fqName, char separator) {
        int lastPointIdx;
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(34);
        }
        if ((lastPointIdx = fqName.lastIndexOf(separator)) >= 0) {
            String string = fqName.substring(0, lastPointIdx);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        return StringUtilKmp.getLineBreakCount(text);
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(37);
        }
        return StringUtilKmp.containsLineBreak(text);
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return StringUtilKmp.isLineBreak(c);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeLineBreak(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        StringBuilder buffer = new StringBuilder(text.length());
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        return (len = text.length()) > 0 && StringUtil.isLineBreak(text.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text, int line, int col) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text, int offset) {
        LineColumn lineColumn;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        return (lineColumn = StringUtil.offsetToLineColumn(text, offset)) != null ? lineColumn.line : -1;
    }

    @Contract(pure=true)
    public static LineColumn offsetToLineColumn(@NotNull CharSequence text, int offset) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        int curLine = 0;
        int curLineStart = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text.length()) {
                return null;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                curLineStart = curOffset + 1;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset < text.length() - 1 && text.charAt(curOffset + 1) == '\n') {
                ++curOffset;
            }
            curLineStart = curOffset + 1;
        }
        return LineColumn.of(curLine, offset - curLineStart);
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @Contract(pure=true)
    @NotNull
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(46);
        }
        return StringUtil.fixCapitalization(s, ourLowerCaseWords, true, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(47);
        }
        return StringUtil.fixCapitalization(s, ArrayUtilRt.EMPTY_STRING_ARRAY, false, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(48);
        }
        return StringUtil.fixCapitalization(s, ArrayUtilRt.EMPTY_STRING_ARRAY, true, false);
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, String @NotNull [] wordsToIgnore, boolean title, boolean mnemonics) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(49);
        }
        if (wordsToIgnore == null) {
            StringUtil.$$$reportNull$$$0(50);
        }
        StringBuilder buffer = null;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char prevPrevChar;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            int start = i++;
            while (i < length) {
                char c = s.charAt(i);
                if ((!mnemonics || c != '&' && c != '_') && !Character.isLetterOrDigit(c)) break;
                ++i;
            }
            if (!title && i > start + 1 && !Character.isLowerCase(s.charAt(start + 1))) continue;
            char c = prevPrevChar = start > 1 ? s.charAt(start - 2) : (char)'\u0000';
            if (prevChar == '.' && (prevPrevChar == ' ' || prevPrevChar == '*') || prevChar == '~' && prevPrevChar == ' ' || StringUtil.isPreposition(s, start, i - 1, ourOtherNonCapitalizableWords)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            if (!title) {
                buffer.setCharAt(start, StringUtil.toLowerCase(currChar));
                continue;
            }
            boolean firstWord = start == 0 || StringUtil.isPunctuation(prevPrevChar);
            boolean lastWord = i >= length - 1 || StringUtil.isPunctuation(s.charAt(i + 1));
            buffer.setCharAt(start, firstWord || lastWord || !StringUtil.isPreposition(s, start, i - 1, wordsToIgnore) ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        String string = buffer == null ? s : buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    private static boolean isPunctuation(char c) {
        return c == '.' || c == '!' || c == ':' || c == '?' || c == '\u2026';
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, String @NotNull [] prepositions) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(52);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(53);
        }
        block0: for (String preposition : prepositions) {
            if (lastChar - firstChar + 1 != preposition.length()) continue;
            for (int j = 0; j < preposition.length(); ++j) {
                if (StringUtil.toLowerCase(s.charAt(firstChar + j)) != StringUtil.toLowerCase(preposition.charAt(j))) continue block0;
            }
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public static NotNullFunction<String, String> escaper(boolean escapeSlash, @Nullable String additionalChars) {
        NotNullFunction<String, String> notNullFunction = dom -> {
            StringBuilder builder = new StringBuilder(dom.length());
            StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
            return builder.toString();
        };
        if (notNullFunction == null) {
            StringUtil.$$$reportNull$$$0(54);
        }
        return notNullFunction;
    }

    @Contract(mutates="param3")
    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(55);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(56);
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @Contract(mutates="param4")
    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(57);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(58);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    @Contract(mutates="param5")
    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
    }

    @Contract(mutates="param6")
    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        String hexCode = StringUtil.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append((CharSequence)hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19 && block != Character.UnicodeBlock.VARIATION_SELECTORS && block != Character.UnicodeBlock.VARIATION_SELECTORS_SUPPLEMENT;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        return (ch = s.charAt(ind)) == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        return StringUtilRt.isQuotedString((String)s);
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        String string = StringUtilRt.unquoteString((String)s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        String string = StringUtilRt.unquoteString((String)s, (char)quotationChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    @ApiStatus.Internal
    @Contract(mutates="param3")
    public static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeAnsiStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        int length = s.length();
        int count = 0;
        int radix = 0;
        int suffixLen = 0;
        boolean decode = false;
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            block30: {
                char ch = s.charAt(idx);
                if (!escaped) {
                    if (ch == '\\') {
                        escaped = true;
                        continue;
                    }
                    buffer.append(ch);
                    continue;
                }
                switch (ch) {
                    case '\'': {
                        buffer.append('\'');
                        break;
                    }
                    case '\"': {
                        buffer.append('\"');
                        break;
                    }
                    case '?': {
                        buffer.append('?');
                        break;
                    }
                    case '\\': {
                        buffer.append('\\');
                        break;
                    }
                    case 'a': {
                        buffer.append('\u0007');
                        break;
                    }
                    case 'b': {
                        buffer.append('\b');
                        break;
                    }
                    case 'f': {
                        buffer.append('\f');
                        break;
                    }
                    case 'n': {
                        buffer.append('\n');
                        break;
                    }
                    case 'r': {
                        buffer.append('\r');
                        break;
                    }
                    case 't': {
                        buffer.append('\t');
                        break;
                    }
                    case 'v': {
                        buffer.append('\u000b');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        count = 3;
                        radix = 8;
                        suffixLen = 0;
                        decode = true;
                        break;
                    }
                    case 'x': {
                        count = -1;
                        radix = 16;
                        suffixLen = 1;
                        decode = true;
                        break;
                    }
                    case 'u': {
                        count = 4;
                        radix = 16;
                        suffixLen = 1;
                        decode = true;
                        break;
                    }
                    case 'U': {
                        count = 8;
                        radix = 16;
                        suffixLen = 1;
                        decode = true;
                        break;
                    }
                    default: {
                        buffer.append(ch);
                    }
                }
                if (decode) {
                    decode = false;
                    boolean arbitraryLength = count == -1;
                    StringBuilder sb = new StringBuilder(arbitraryLength ? 8 : count);
                    for (int pos = idx + suffixLen; pos < length && (arbitraryLength || count > 0); ++pos) {
                        char chl = s.charAt(pos);
                        if (!(radix == 16 && StringUtil.isHexDigit(chl) || radix == 8 && StringUtil.isOctalDigit(chl))) break;
                        sb.append(chl);
                        if (arbitraryLength) continue;
                        --count;
                    }
                    if (sb.length() != 0) {
                        try {
                            int code = Integer.parseInt(sb.toString(), radix);
                            if (Character.isValidCodePoint(code)) {
                                idx += sb.length() + suffixLen - 1;
                                buffer.append(Character.toChars(code));
                                break block30;
                            }
                            buffer.append('\\').append(ch);
                        }
                        catch (NumberFormatException e) {
                            buffer.append('\\').append(ch);
                        }
                    } else {
                        buffer.append('\\').append(ch);
                    }
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String pluralize(@NotNull String word) {
        if (word == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        String string = Strings.pluralize(word);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(81);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWords(@NotNull String text, boolean allWords) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(82);
        }
        return StringUtil.capitalizeWords(text, " \t\n\r\f([<", allWords, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWords(@NotNull String text, @NotNull String tokenizerDelimiters, boolean allWords, boolean leaveOriginalDelimiters) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(83);
        }
        if (tokenizerDelimiters == null) {
            StringUtil.$$$reportNull$$$0(84);
        }
        StringTokenizer tokenizer = new StringTokenizer(text, tokenizerDelimiters, leaveOriginalDelimiters);
        StringBuilder out = new StringBuilder(text.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelimiters && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(85);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String decapitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(86);
        }
        String string = Introspector.decapitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        String string = Strings.capitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return Strings.isCapitalized(s);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean canBeCapitalized(@Nullable String s) {
        return StringUtil.isNotEmpty(s) && Character.isLowerCase(s.charAt(0));
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(90);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(91);
            }
            return string;
        }
        return StringUtil.capitalize(s);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(92);
        }
        return Strings.stringHashCode(chars);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(93);
        }
        return Strings.stringHashCode(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        return Strings.stringHashCode(chars, from, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        return Strings.stringHashCode(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(char @NotNull [] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(95);
        }
        return Strings.stringHashCodeInsensitive(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(96);
        }
        return Strings.stringHashCodeInsensitive(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        return Strings.stringHashCodeInsensitive(chars, from, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(98);
        }
        return Strings.stringHashCodeInsensitive(chars);
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        return Strings.stringHashCodeIgnoreWhitespaces(chars);
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(100);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return Strings.trim(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(103);
        }
        String string = Strings.trimEnd(s, suffix);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(106);
        }
        String string = Strings.trimEnd(s, suffix, ignoreCase);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        String string = Strings.trimEnd(s, suffix);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLog(@NotNull String text, int limit) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(110);
        }
        if (limit > 5 && text.length() > limit) {
            String string = text.substring(0, limit - 5) + " ...\n";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(111);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(112);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(113);
        }
        String string2 = StringUtil.trimLeading((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence trimLeading(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        CharSequence charSequence = string.subSequence(index, string.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(116);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(117);
        }
        for (index = 0; index < string.length() && string.charAt(index) == symbol; ++index) {
        }
        String string2 = string.substring(index);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        return string2;
    }

    @Contract(mutates="param1")
    @NotNull
    public static StringBuilder trimLeading(@NotNull StringBuilder builder, char symbol) {
        int index;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(119);
        }
        for (index = 0; index < builder.length() && builder.charAt(index) == symbol; ++index) {
        }
        if (index > 0) {
            builder.delete(0, index);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(120);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(121);
        }
        String string2 = StringUtil.trimTrailing((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(122);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence trimTrailing(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(123);
        }
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        CharSequence charSequence = string.subSequence(0, index + 1);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(124);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(125);
        }
        for (index = string.length() - 1; index >= 0 && string.charAt(index) == symbol; --index) {
        }
        String string2 = string.substring(0, index + 1);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(126);
        }
        return string2;
    }

    @Contract(mutates="param1")
    @NotNull
    public static StringBuilder trimTrailing(@NotNull StringBuilder builder, char symbol) {
        int index;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(127);
        }
        for (index = builder.length() - 1; index >= 0 && builder.charAt(index) == symbol; --index) {
        }
        builder.setLength(index + 1);
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(128);
        }
        return stringBuilder;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    public static CharSequence trim(@Nullable CharSequence s) {
        int endIndex;
        int startIndex;
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length == 0) {
            return s;
        }
        for (startIndex = 0; startIndex < length && Character.isWhitespace(s.charAt(startIndex)); ++startIndex) {
        }
        if (startIndex == length) {
            return Strings.EMPTY_CHAR_SEQUENCE;
        }
        for (endIndex = length - 1; endIndex >= startIndex && Character.isWhitespace(s.charAt(endIndex)); --endIndex) {
        }
        if (startIndex > 0 || ++endIndex < length) {
            return s.subSequence(startIndex, endIndex);
        }
        return s;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return Strings.endsWithChar(s, suffix);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(129);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(130);
        }
        String string = Strings.trimStart(s, prefix);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(131);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimExtensions(@NotNull String name) {
        int index;
        if (name == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        String string = (index = name.indexOf(46)) < 0 ? name : name.substring(0, index);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String pluralize(@NotNull String base, int count) {
        if (base == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        if (count == 1) {
            String string = base;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(135);
            }
            return string;
        }
        return StringUtil.pluralize(base);
    }

    @Contract(mutates="param1")
    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(136);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return Strings.isNotEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return Strings.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return Strings.isEmpty(cs);
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s) {
        String string = Strings.notNullize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(137);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        String string = Strings.notNullize(s, defaultValue);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(139);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s) {
        return Strings.nullize(s, false);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, @Nullable String defaultValue) {
        return Strings.nullize(s, defaultValue);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        return Strings.nullize(s, nullizeSpaces);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return Strings.isEmptyOrSpaces(s);
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return Strings.isWhiteSpace(c);
    }

    @Contract(pure=true)
    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        String string = ExceptionUtil.getThrowableText(aThrowable);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        return ExceptionUtil.getMessage(e);
    }

    @Contract(pure=true)
    @NotNull
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        return new String(buffer);
    }

    @Contract(pure=true)
    @NotNull
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(143);
        }
        if (count == 0) {
            return "";
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(144);
        }
        return string;
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        List<String> list = Collections.unmodifiableList(StringUtilRt.splitHonorQuotes((String)s, (char)separator));
        if (list == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        return list;
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(148);
        }
        return StringUtil.split(s, separator, true);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(149);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        return StringUtil.split(s, separator, true, true);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(151);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(152);
        }
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        if (separator.length() == 0) {
            List<CharSequence> list = Collections.singletonList(s);
            if (list == null) {
                StringUtil.$$$reportNull$$$0(157);
            }
            return list;
        }
        FreezableArrayList<CharSequence> result = new FreezableArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        List<CharSequence> list = result.emptyOrFrozen();
        if (list == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        return list;
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> split(@NotNull String s, @NotNull CharFilter separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(159);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(160);
        }
        return StringUtil.split((CharSequence)s, separator, excludeSeparator, excludeEmptyStrings);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<CharSequence> split(@NotNull CharSequence s, @NotNull CharFilter separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(162);
        }
        FreezableArrayList<CharSequence> result = new FreezableArrayList<CharSequence>();
        int pos = 0;
        for (int index = 0; index < s.length(); ++index) {
            if (!separator.accept(s.charAt(index))) continue;
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : index + 1);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = index + 1;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        List<CharSequence> list = result.emptyOrFrozen();
        if (list == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        return StringUtil.tokenize(new StringTokenizer(s, separators));
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(final @NotNull StringTokenizer tokenizer) {
        if (tokenizer == null) {
            StringUtil.$$$reportNull$$$0(166);
        }
        Iterable<String> iterable = () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(167);
        }
        return iterable;
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> getWordsIn(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(168);
        }
        FreezableArrayList<String> result = null;
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1) {
                if (result == null) {
                    result = new FreezableArrayList();
                }
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result == null) {
                result = new FreezableArrayList<String>();
            }
            result.add(text.substring(start, i));
            start = -1;
        }
        if (result == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                StringUtil.$$$reportNull$$$0(169);
            }
            return list;
        }
        List<String> list = result.emptyOrFrozen();
        if (list == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        return list;
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<TextRange> getWordIndicesIn(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(171);
        }
        return StringUtil.getWordIndicesIn(text, null);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<TextRange> getWordIndicesIn(@NotNull String text, @Nullable Set<Character> separatorsSet) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(172);
        }
        FreezableArrayList<TextRange> result = new FreezableArrayList<TextRange>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            boolean isIdentifierPart;
            char c = text.charAt(i);
            boolean bl = separatorsSet == null ? Character.isJavaIdentifierPart(c) : (isIdentifierPart = !separatorsSet.contains(Character.valueOf(c)));
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1) {
                result.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(new TextRange(start, i));
            start = -1;
        }
        List<TextRange> list = result.emptyOrFrozen();
        if (list == null) {
            StringUtil.$$$reportNull$$$0(173);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String @NotNull [] strings, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(174);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(175);
        }
        return StringUtil.join(strings, 0, strings.length, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String @NotNull [] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(176);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(177);
        }
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(178);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] zip(String @NotNull [] strings1, String @NotNull [] strings2, String separator) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(179);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        return result;
    }

    @Contract(pure=true)
    public static String @NotNull [] surround(String @NotNull [] strings, @NotNull String prefix, @NotNull String suffix) {
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(182);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        String[] result = ArrayUtil.newStringArray(strings.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings[i] + suffix;
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        return result;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(T @NotNull [] items, @NotNull com.intellij.util.Function<? super T, String> f, @NotNull String separator) {
        if (f == null) {
            StringUtil.$$$reportNull$$$0(186);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(187);
        }
        if (items == null) {
            StringUtil.$$$reportNull$$$0(188);
        }
        String string = Strings.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(189);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull com.intellij.util.Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(190);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(191);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        String string = Strings.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(194);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        String string = Strings.join(items, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull com.intellij.util.Function<? super T, ? extends CharSequence> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        String string = Strings.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        return string;
    }

    @Contract(mutates="param4")
    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull com.intellij.util.Function<? super T, ? extends CharSequence> f, @NotNull String separator, @NotNull StringBuilder result) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        Strings.join(items, f, separator, result);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        String string = Strings.join(strings, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        return string;
    }

    @Contract(mutates="param3")
    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(208);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(209);
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(210);
        }
        Strings.join(strings, separator, result);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(int @NotNull [] strings, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        String string = Strings.join(strings, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String ... strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(214);
        }
        String string = Strings.join(strings);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(215);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<CharSequence, ?, String> joining() {
        Collector<CharSequence, ?, String> collector = Collectors.joining(", ");
        if (collector == null) {
            StringUtil.$$$reportNull$$$0(216);
        }
        return collector;
    }

    @Contract(pure=true)
    @NotNull
    public static String stripQuotesAroundValue(@NotNull String text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(217);
        }
        if ((len = text.length()) > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                String string = text.substring(from, to);
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(218);
                }
                return string;
            }
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(219);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize) {
        String string = Formats.formatFileSize(fileSize);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(220);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(221);
        }
        String string2 = Formats.formatFileSize(fileSize, (String)unitSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(222);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration) {
        String string = Formats.formatDuration(duration);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(223);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(@NotNull Duration duration) {
        if (duration == null) {
            StringUtil.$$$reportNull$$$0(224);
        }
        String string = Formats.formatDuration(duration);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(225);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String unpluralize(@NotNull String word) {
        if (word == null) {
            StringUtil.$$$reportNull$$$0(226);
        }
        return Strings.unpluralize(word);
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(227);
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(228);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(229);
        }
        return Strings.containsAnyChar(value, chars);
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        return Strings.containsAnyChar(value, chars, start, end);
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(232);
        }
        return Strings.containsChar(value, ch);
    }

    @Contract(pure=true)
    @NotNull
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(235);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trim(@NotNull String s, @NotNull CharFilter filter) {
        char ch;
        int start;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(237);
        }
        int end = s.length();
        for (start = 0; start < end && !filter.accept(ch = s.charAt(start)); ++start) {
        }
        while (start < end && !filter.accept(ch = s.charAt(end - 1))) {
            --end;
        }
        String string = s.substring(start, end);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(238);
        }
        return string;
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(239);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(240);
        }
        return StringUtil.findMatches(s, pattern, 1);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(241);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(242);
        }
        FreezableArrayList<String> result = new FreezableArrayList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result.add(group);
        }
        List<String> list = result.emptyOrFrozen();
        if (list == null) {
            StringUtil.$$$reportNull$$$0(243);
        }
        return list;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(244);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(245);
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(246);
        }
        if (range == null) {
            StringUtil.$$$reportNull$$$0(247);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(248);
        }
        String string2 = range.replace(string, replacement);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(249);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(250);
        }
        return !text.isEmpty() && Character.isWhitespace(text.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(251);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(252);
        }
        return StringUtilRt.startsWith((CharSequence)text, (CharSequence)prefix);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        return Strings.startsWith(text, startIndex, prefix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(255);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(256);
        }
        return Strings.endsWith(text, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, int start, int end, @NotNull CharSequence suffix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        if (start < 0 || end > text.length()) {
            throw new IllegalArgumentException("invalid offsets: start=" + start + "; end=" + end + "; text.length()=" + text.length());
        }
        int suffixLen = suffix.length();
        int delta = end - suffixLen;
        if (delta < start) {
            return false;
        }
        for (int i = 0; i < suffixLen; ++i) {
            if (text.charAt(delta + i) == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(259);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(260);
        }
        String string = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(261);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(262);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(263);
        }
        return StringUtil.commonPrefixLength(s1, s2, false);
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2, boolean ignoreCase) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(264);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(265);
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && Strings.charsMatch(s1.charAt(i), s2.charAt(i), ignoreCase); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    @NotNull
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(266);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(267);
        }
        String string = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(268);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(269);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(270);
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(271);
        }
        return Strings.contains(s, start, end, c);
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(272);
        }
        return Strings.indexOf(s, c);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(273);
        }
        return Strings.indexOf(s, c, start);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(274);
        }
        return Strings.indexOf(s, c, start, end);
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(275);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        return Strings.contains(sequence, infix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(277);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(278);
        }
        return Strings.indexOf(sequence, infix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(279);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(280);
        }
        return Strings.indexOf(sequence, infix, start);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        return Strings.indexOf(sequence, infix, start, end);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        return Strings.indexOf(s, c, start, end, caseSensitive);
    }

    @Contract(pure=true)
    public static int indexOf(char @NotNull [] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        return Strings.indexOf(s, c, start, end, caseSensitive);
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(285);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(286);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(287);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(288);
        }
        return Strings.indexOfAny(s, chars);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(289);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(290);
        }
        return Strings.indexOfAny(s, chars);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(291);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(292);
        }
        return Strings.indexOfAny(s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(293);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(294);
        }
        return Strings.indexOfAny(s, chars, start, end);
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(295);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(296);
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    @Nullable
    public static String substringBefore(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(297);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(298);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return null;
        }
        return text.substring(0, i);
    }

    @Contract(pure=true)
    @NotNull
    public static String substringBeforeLast(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(299);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(300);
        }
        if ((i = text.lastIndexOf(subString)) == -1) {
            String string = text;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(301);
            }
            return string;
        }
        String string = text.substring(0, i);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(302);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String substringBeforeLast(@NotNull String text, @NotNull String subString, boolean includeLast) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(303);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(304);
        }
        if ((i = text.lastIndexOf(subString)) == -1) {
            String string = text;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(305);
            }
            return string;
        }
        String string = includeLast ? text.substring(0, i + subString.length()) : text.substring(0, i);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(306);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String substringAfter(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(307);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(308);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    @Nullable
    public static String substringAfterLast(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(309);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        if ((i = text.lastIndexOf(subString)) == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(311);
        }
        return StringUtilRt.lastIndexOf((CharSequence)s, (char)c, (int)start, (int)end);
    }

    @Contract(pure=true)
    @NotNull
    public static String first(@NotNull String text, int maxLength, boolean appendEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        String string = text.length() > maxLength ? text.substring(0, maxLength) + (appendEllipsis ? THREE_DOTS : "") : text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(313);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence first(@NotNull CharSequence text, int length, boolean appendEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(314);
        }
        if (text.length() <= length) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(315);
            }
            return charSequence;
        }
        if (appendEllipsis) {
            String string = text.subSequence(0, length) + THREE_DOTS;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(316);
            }
            return string;
        }
        CharSequence charSequence = text.subSequence(0, length);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(317);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence last(@NotNull CharSequence text, int length, boolean prependEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(318);
        }
        if (text.length() <= length) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(319);
            }
            return charSequence;
        }
        if (prependEllipsis) {
            String string = THREE_DOTS + text.subSequence(text.length() - length, text.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(320);
            }
            return string;
        }
        CharSequence charSequence = text.subSequence(text.length() - length, text.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(321);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static String firstLast(@NotNull String text, int length) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(322);
        }
        String string = text.length() > length ? text.subSequence(0, length / 2) + ELLIPSIS + text.subSequence(text.length() - length / 2 - 1, text.length()) : text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(323);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeChar(@NotNull String str, char character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(324);
        }
        return StringUtil.escapeChars(str, character);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeChars(@NotNull String str, char ... character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(325);
        }
        if (character == null) {
            StringUtil.$$$reportNull$$$0(326);
        }
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(327);
        }
        return string;
    }

    @Contract(mutates="param1")
    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(328);
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(329);
        }
        return StringUtil.escapeChar(str, '\"');
    }

    @Contract(mutates="param1")
    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(330);
        }
        StringUtil.escapeChar(buf, '\"');
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(331);
        }
        return StringUtil.escapeChar(str, '/');
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(332);
        }
        return StringUtil.escapeChar(str, '\\');
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(333);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(334);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(335);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(336);
        }
        return string;
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(337);
        }
        if (str == null) {
            StringUtil.$$$reportNull$$$0(338);
        }
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    @Contract(mutates="param1")
    public static void quote(@NotNull StringBuilder builder) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(339);
        }
        StringUtil.quote(builder, '\"');
    }

    @Contract(mutates="param1")
    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(340);
        }
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @Contract(pure=true)
    @NotNull
    public static String wrapWithDoubleQuote(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(341);
        }
        String string = '\"' + str + "\"";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(342);
        }
        return string;
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text) {
        return text == null ? null : StringUtil.unescapeXmlEntities(text);
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text) {
        return text == null ? null : StringUtil.escapeXmlEntities(text);
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeXmlEntities(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(343);
        }
        String string = Strings.unescapeXmlEntities(text);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(344);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeXmlEntities(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(345);
        }
        String string = Strings.escapeXmlEntities(text);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(346);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(347);
        }
        return StringUtil.removeHtmlTags(htmlString, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString, boolean isRemoveStyleTag) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(348);
        }
        if (StringUtil.isEmpty(htmlString)) {
            return "";
        }
        MyHtml2Text parser = isRemoveStyleTag ? new MyHtml2Text(true) : new MyHtml2Text(false);
        try {
            parser.parse(new StringReader(htmlString));
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
        String string = parser.getText();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(349);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String removeEllipsisSuffix(@NotNull @Nls String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(350);
        }
        if (s.endsWith(THREE_DOTS)) {
            String string = s.substring(0, s.length() - THREE_DOTS.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(351);
            }
            return string;
        }
        if (s.endsWith(ELLIPSIS)) {
            String string = s.substring(0, s.length() - ELLIPSIS.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(352);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(353);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeMnemonics(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(354);
        }
        return StringUtil.replace(text, MN_CHARS, MN_QUOTED);
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String htmlEmphasize(@NotNull @Nls String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(355);
        }
        String string = HtmlChunk.tag("code").addText(text).wrapWith("b").toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(356);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeToRegexp(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(357);
        }
        StringBuilder result = new StringBuilder(text.length());
        String string = StringUtil.escapeToRegexp(text, result).toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(358);
        }
        return string;
    }

    @Contract(mutates="param2")
    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text, @NotNull StringBuilder builder) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(359);
        }
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(360);
        }
        StringBuilder stringBuilder = Strings.escapeToRegexp(text, builder);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(361);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text, int startOffset, int backslashOffset) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(362);
        }
        if (text.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text.charAt(i) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull List<String> from, @NotNull List<String> to) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(363);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(365);
        }
        String string = Strings.replace(text, from, to);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(366);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] filterEmptyStrings(String @NotNull [] strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(367);
        }
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            if (strings == null) {
                StringUtil.$$$reportNull$$$0(368);
            }
            return strings;
        }
        String[] result = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result[count++] = string;
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(369);
        }
        return result;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        return StringUtil.countChars(text, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        return Strings.countChars(text, c);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int offset, boolean stopAtOtherChar) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(372);
        }
        return Strings.countChars(text, c, offset, stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int start, int end, boolean stopAtOtherChar) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(373);
        }
        return Strings.countChars(text, c, start, end, stopAtOtherChar);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    @Nullable
    public static String joinOrNull(String ... args) {
        if (args == null) {
            StringUtil.$$$reportNull$$$0(374);
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Contract(pure=true)
    @Nullable
    public static String getPropertyName(@NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(375);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    private static boolean isJavaIdentifierStart(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || Character.isJavaIdentifierStart(cp);
    }

    @Contract(pure=true)
    private static boolean isJavaIdentifierPart(int cp) {
        return cp >= 48 && cp <= 57 || cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || Character.isJavaIdentifierPart(cp);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(376);
        }
        if ((len = text.length()) == 0) {
            return false;
        }
        int point = text.codePointAt(0);
        if (!StringUtil.isJavaIdentifierStart(point)) {
            return false;
        }
        for (int i = Character.charCount(point); i < len; i += Character.charCount(point)) {
            point = text.codePointAt(i);
            if (StringUtil.isJavaIdentifierPart(point)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull CharSequence str, int startIncl, int endExcl) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(377);
        }
        if (str.length() == 0) {
            return false;
        }
        Ref.BooleanRef isFirst = new Ref.BooleanRef();
        isFirst.element = true;
        return StringUtil.processCodePoints(str, startIncl, endExcl, codePoint -> {
            if (isFirst.element) {
                isFirst.element = false;
                if (!StringUtil.isJavaIdentifierStart(codePoint)) {
                    return false;
                }
            } else if (!StringUtil.isJavaIdentifierPart(codePoint)) {
                return false;
            }
            return true;
        });
    }

    private static boolean processCodePoints(@NotNull CharSequence str, int startIncl, int endExcl, CodePointProcessor processor) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(378);
        }
        int i = startIncl;
        while (i < endExcl) {
            char c1;
            if (!Character.isHighSurrogate(c1 = str.charAt(i++)) || i >= endExcl) {
                if (processor.acceptCodePoint(c1)) continue;
                return false;
            }
            char c2 = str.charAt(i);
            if (Character.isLowSurrogate(c2)) {
                ++i;
                if (processor.acceptCodePoint(Character.toCodePoint(c1, c2))) continue;
                return false;
            }
            if (processor.acceptCodePoint(c2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        if (input == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string = escaped.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(380);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getQualifiedName(@Nullable String packageName, @NotNull String className) {
        if (className == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        if (packageName == null || packageName.isEmpty()) {
            String string = className;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(382);
            }
            return string;
        }
        String string = packageName + '.' + className;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(383);
        }
        return string;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? Integer.valueOf(p1).compareTo(Integer.valueOf(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts2;
            boolean left = part1.length > idx;
            String[] stringArray = parts2 = left ? part1 : part2;
            while (idx < parts2.length) {
                String p = parts2[idx];
                int cmp = p.matches("\\d+") ? Integer.valueOf(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, char c) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(384);
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, @NotNull String s) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(385);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(386);
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    @NotNull
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(387);
        }
        if (StringUtil.isEmptyOrSpaces(name)) {
            String string = name;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(388);
            }
            return string;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            String string = "an" + Character.toUpperCase(c) + name.substring(1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(389);
            }
            return string;
        }
        String string = "a" + Character.toUpperCase(c) + name.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(390);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result.append("_");
            }
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        return string;
    }

    @Contract(pure=true)
    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(393);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(394);
        }
        String string = idx >= s.length() ? "" : s.substring(idx);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(395);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(396);
        }
        return StringUtil.splitByLines(string, true);
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string, boolean excludeEmptyStrings) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(397);
        }
        String[] stringArray = (excludeEmptyStrings ? Splitters.EOL_SPLIT_PATTERN : Splitters.EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(398);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesDontTrim(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(399);
        }
        String[] stringArray = Splitters.EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(400);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesKeepSeparators(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(401);
        }
        String[] stringArray = Splitters.EOL_SPLIT_KEEP_SEPARATORS.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(402);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(403);
        }
        FreezableArrayList<Pair> result = new FreezableArrayList<Pair>();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                result.add(Pair.create((Object)name.toString(), (Object)startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        List<Pair<String, Integer>> list = result.emptyOrFrozen();
        if (list == null) {
            StringUtil.$$$reportNull$$$0(404);
        }
        return list;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return Strings.isDecimalDigit(c);
    }

    @Contract(value="null -> false")
    public static boolean isNotNegativeNumber(@Nullable CharSequence s) {
        return Strings.isNotNegativeNumber(s);
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (Strings.areSameInstance(s1, s2)) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int compare(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean ignoreCase) {
        return Strings.compare(s1, s2, ignoreCase);
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal((CharSequence)s1, (CharSequence)s2, (boolean)true);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal((CharSequence)s1, (CharSequence)s2, (boolean)false);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return Strings.equalsIgnoreWhitespaces(s1, s2);
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(405);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(406);
        }
        return Strings.equalsTrimWhitespaces(s1, s2);
    }

    @Contract(pure=true)
    @NotNull
    public static String collapseWhiteSpace(@NotNull CharSequence s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(407);
        }
        StringBuilder result = null;
        int length = s.length();
        int i = 0;
        while (i < length) {
            char ch = s.charAt(i);
            int ni = StringUtil.skipWhitespaceOrNewLineForward(s, i);
            if (ni == i + 1 && (i == 0 || ch != ' ' || ni == length) || ni > i + 1) {
                if (result == null) {
                    result = new StringBuilder(length);
                    result.append(s, 0, i);
                }
                if (i != 0 && ni != length) {
                    result.append(' ');
                }
                i = ni;
                continue;
            }
            if (result != null) {
                result.append(ch);
            }
            ++i;
        }
        String string = result == null ? s.toString() : result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(408);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where2) {
        if (where2 == null) {
            StringUtil.$$$reportNull$$$0(409);
        }
        for (String string : where2) {
            if (!StringUtil.equalsIgnoreCase(toFind, string)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        return Strings.compare(c1, c2, ignoreCase);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatLinks(@NotNull String message) {
        if (message == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z\\d./\\-+]+");
        StringBuffer result = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result);
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimMiddle(@NotNull String text, int maxLength) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(413);
        }
        return StringUtil.shortenTextWithEllipsis(text, maxLength, maxLength >> 1, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, @NotNull String symbol) {
        int textLength;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(414);
        }
        if (symbol == null) {
            StringUtil.$$$reportNull$$$0(415);
        }
        if ((textLength = text.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength >= 0);
            String string = text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(416);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(417);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(418);
        }
        String symbol = useEllipsisSymbol ? ELLIPSIS : THREE_DOTS;
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, symbol);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength, boolean useEllipsisSymbol) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(419);
        }
        return StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(420);
        }
        return StringUtil.shortenPathWithEllipsis(path, maxLength, false);
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return Strings.charsEqualIgnoreCase(a, b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return Strings.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return Strings.toUpperCase(s);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return Strings.toLowerCase(a);
    }

    @Contract(pure=true)
    public static boolean isUpperCase(@NotNull CharSequence sequence) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(421);
        }
        for (int i = 0; i < sequence.length(); ++i) {
            if (Character.isUpperCase(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isLowerCase(@NotNull CharSequence sequence) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(422);
        }
        for (int i = 0; i < sequence.length(); ++i) {
            if (Character.isLowerCase(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text) {
        int index;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(423);
        }
        if ((index = StringUtil.indexOfAny(text, "\n\r")) == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text, index);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Contract(pure=true)
    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text, int index) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(424);
        }
        if (index < 0 || index >= text.length()) {
            return null;
        }
        char ch = text.charAt(index);
        if (ch == '\r') {
            return index + 1 < text.length() && text.charAt(index + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(425);
        }
        String string = Strings.convertLineSeparators(text);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(426);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        String string = StringUtilRt.convertLineSeparators((String)text, (String)newSeparator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(429);
        }
        return string;
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string, int defaultValue) {
        return StringUtilRt.parseInt((String)string, (int)defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        return StringUtilRt.parseLong((String)string, (long)defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string, double defaultValue) {
        return StringUtilRt.parseDouble((String)string, (double)defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(430);
        }
        if (clazz == null) {
            StringUtil.$$$reportNull$$$0(431);
        }
        try {
            return string.isEmpty() ? defaultValue : Enum.valueOf(clazz, string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull Class<?> aClass) {
        if (aClass == null) {
            StringUtil.$$$reportNull$$$0(432);
        }
        String string = StringUtilRt.getShortName(aClass);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(433);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(434);
        }
        String string = StringUtilRt.getShortName((String)fqName);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(435);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(436);
        }
        String string = StringUtilRt.getShortName((String)fqName, (char)separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isShortNameOf(@NotNull String fqName, @NotNull String shortName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        if (shortName == null) {
            StringUtil.$$$reportNull$$$0(439);
        }
        if (fqName.length() < shortName.length()) {
            return false;
        }
        if (fqName.length() == shortName.length()) {
            return fqName.equals(shortName);
        }
        int diff = fqName.length() - shortName.length();
        if (fqName.charAt(diff - 1) != '.') {
            return false;
        }
        return fqName.regionMatches(diff, shortName, 0, shortName.length());
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence, long delayMillis) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(440);
        }
        final long myTime = System.currentTimeMillis() + delayMillis;
        return new BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    @Contract(mutates="param1")
    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(441);
        }
        if (end == null) {
            StringUtil.$$$reportNull$$$0(442);
        }
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string, @NotNull String smallPart, @NotNull String bigPart) {
        String s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(443);
        }
        if (smallPart == null) {
            StringUtil.$$$reportNull$$$0(444);
        }
        if (bigPart == null) {
            StringUtil.$$$reportNull$$$0(445);
        }
        return (s = StringUtil.toLowerCase(string)).startsWith(StringUtil.toLowerCase(smallPart)) && StringUtil.toLowerCase(bigPart).startsWith(s);
    }

    @Contract(pure=true)
    public static boolean hasUpperCaseChar(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(446);
        }
        for (char c : s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean hasLowerCaseChar(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(447);
        }
        for (char c : s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static String replaceUnicodeEscapeSequences(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        StringBuilder sb = new StringBuilder(text.length());
        block0: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                int j;
                boolean escape = true;
                for (j = i + 1; j < length && (c = text.charAt(j)) == '\\'; ++j) {
                    escape = !escape;
                }
                if (!escape || c != 'u') {
                    sb.append(text, i, j);
                    i = j - 1;
                    continue;
                }
                while (j < length && text.charAt(j) == 'u') {
                    ++j;
                }
                if (j > length - 4) {
                    sb.append(text, i, j);
                    i = j - 1;
                    continue;
                }
                for (int k = 0; k < 4; ++k) {
                    if (StringUtil.isHexDigit(text.charAt(j + k))) continue;
                    sb.append(text, i, j + k);
                    i = j + k - 1;
                    continue block0;
                }
                char d = (char)Integer.parseInt(text.substring(j, j + 4), 16);
                sb.append(d);
                i = j + 3;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(byte @NotNull [] bytes) {
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(448);
        }
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(449);
        }
        return string;
    }

    @Contract(pure=true)
    public static byte @NotNull [] parseHexString(@NotNull String str) {
        int len;
        if (str == null) {
            StringUtil.$$$reportNull$$$0(450);
        }
        if ((len = str.length()) % 2 != 0) {
            throw new IllegalArgumentException("Non-even-length: " + str);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(451);
        }
        return bytes;
    }

    @Contract(pure=true)
    public static boolean isLatinAlphanumeric(@Nullable CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isNumeric(@Nullable CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null; !null->!null", pure=true)
    public static String internEmptyString(String s) {
        return s == null ? null : (s.isEmpty() ? "" : s);
    }

    @Contract(pure=true)
    public static int skipWhitespaceForward(@NotNull CharSequence text, int pos) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(452);
        }
        int length = text.length();
        while (pos < length && StringUtil.isWhitespaceOrTab(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    @Contract(pure=true)
    public static int skipWhitespaceOrNewLineForward(@NotNull CharSequence text, int pos) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(453);
        }
        int length = text.length();
        while (pos < length && StringUtil.isWhitespaceTabOrNewLine(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    @Contract(pure=true)
    public static int skipWhitespaceBackward(@NotNull CharSequence text, int pos) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(454);
        }
        while (pos > 0 && StringUtil.isWhitespaceOrTab(text.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    @Contract(pure=true)
    public static int skipWhitespaceOrNewLineBackward(@NotNull CharSequence text, int pos) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(455);
        }
        while (pos > 0 && StringUtil.isWhitespaceTabOrNewLine(text.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    private static boolean isWhitespaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private static boolean isWhitespaceTabOrNewLine(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    @Contract(value="null,!null,_ -> false; !null,null,_ -> false; null,null,_ -> true")
    public static boolean equal(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean caseSensitive) {
        return StringUtilRt.equal((CharSequence)s1, (CharSequence)s2, (boolean)caseSensitive);
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(456);
        }
        String string = StringUtilRt.convertLineSeparators((String)text, (boolean)keepCarriageReturn);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(457);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence convertLineSeparators(@NotNull CharSequence text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(458);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(459);
        }
        CharSequence charSequence = StringUtilRt.convertLineSeparators((CharSequence)text, (String)newSeparator);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(460);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, int @Nullable [] offsetsToKeep) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(461);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(462);
        }
        String string = StringUtilRt.convertLineSeparators((String)text, (String)newSeparator, (int[])offsetsToKeep);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(463);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, int @Nullable [] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(464);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(465);
        }
        String string = StringUtilRt.convertLineSeparators((String)text, (String)newSeparator, (int[])offsetsToKeep, (boolean)keepCarriageReturn);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(466);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, int startOffset, @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(467);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(468);
        }
        return StringUtilRt.startsWithIgnoreCase((String)str, (int)startOffset, (String)prefix);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(469);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(470);
        }
        return StringUtilRt.endsWithIgnoreCase((CharSequence)text, (CharSequence)suffix);
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String unitSeparator, int n) {
        void rank;
        if (unitSeparator == null) {
            StringUtil.$$$reportNull$$$0(471);
        }
        String string = StringUtilRt.formatFileSize((long)fileSize, (String)unitSeparator, (int)rank);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(472);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String unitSeparator, int rank, boolean bl) {
        void fixedFractionPrecision;
        if (unitSeparator == null) {
            StringUtil.$$$reportNull$$$0(473);
        }
        String string = StringUtilRt.formatFileSize((long)fileSize, (String)unitSeparator, (int)rank, (boolean)fixedFractionPrecision);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(474);
        }
        return string;
    }

    @Contract(pure=true)
    public static int rankForFileSize(long fileSize) {
        return StringUtilRt.rankForFileSize((long)fileSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 14: 
            case 32: 
            case 35: 
            case 39: 
            case 51: 
            case 54: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 144: 
            case 146: 
            case 157: 
            case 158: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 235: 
            case 238: 
            case 243: 
            case 249: 
            case 261: 
            case 268: 
            case 301: 
            case 302: 
            case 305: 
            case 306: 
            case 313: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 327: 
            case 334: 
            case 336: 
            case 342: 
            case 344: 
            case 346: 
            case 349: 
            case 351: 
            case 352: 
            case 353: 
            case 356: 
            case 358: 
            case 361: 
            case 366: 
            case 368: 
            case 369: 
            case 380: 
            case 382: 
            case 383: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 408: 
            case 411: 
            case 416: 
            case 417: 
            case 426: 
            case 429: 
            case 433: 
            case 435: 
            case 437: 
            case 449: 
            case 451: 
            case 457: 
            case 460: 
            case 463: 
            case 466: 
            case 472: 
            case 474: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 14: 
            case 32: 
            case 35: 
            case 39: 
            case 51: 
            case 54: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 144: 
            case 146: 
            case 157: 
            case 158: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 235: 
            case 238: 
            case 243: 
            case 249: 
            case 261: 
            case 268: 
            case 301: 
            case 302: 
            case 305: 
            case 306: 
            case 313: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 327: 
            case 334: 
            case 336: 
            case 342: 
            case 344: 
            case 346: 
            case 349: 
            case 351: 
            case 352: 
            case 353: 
            case 356: 
            case 358: 
            case 361: 
            case 366: 
            case 368: 
            case 369: 
            case 380: 
            case 382: 
            case 383: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 408: 
            case 411: 
            case 416: 
            case 417: 
            case 426: 
            case 429: 
            case 433: 
            case 435: 
            case 437: 
            case 449: 
            case 451: 
            case 457: 
            case 460: 
            case 463: 
            case 466: 
            case 472: 
            case 474: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 14: 
            case 32: 
            case 35: 
            case 39: 
            case 51: 
            case 54: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 144: 
            case 146: 
            case 157: 
            case 158: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 235: 
            case 238: 
            case 243: 
            case 249: 
            case 261: 
            case 268: 
            case 301: 
            case 302: 
            case 305: 
            case 306: 
            case 313: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 327: 
            case 334: 
            case 336: 
            case 342: 
            case 344: 
            case 346: 
            case 349: 
            case 351: 
            case 352: 
            case 353: 
            case 356: 
            case 358: 
            case 361: 
            case 366: 
            case 368: 
            case 369: 
            case 380: 
            case 382: 
            case 383: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 408: 
            case 411: 
            case 416: 
            case 417: 
            case 426: 
            case 429: 
            case 433: 
            case 435: 
            case 437: 
            case 449: 
            case 451: 
            case 457: 
            case 460: 
            case 463: 
            case 466: 
            case 472: 
            case 474: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 15: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 82: 
            case 83: 
            case 110: 
            case 168: 
            case 171: 
            case 172: 
            case 217: 
            case 250: 
            case 251: 
            case 253: 
            case 255: 
            case 257: 
            case 285: 
            case 297: 
            case 299: 
            case 303: 
            case 307: 
            case 309: 
            case 312: 
            case 314: 
            case 318: 
            case 322: 
            case 343: 
            case 345: 
            case 354: 
            case 355: 
            case 357: 
            case 359: 
            case 362: 
            case 363: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 376: 
            case 384: 
            case 385: 
            case 412: 
            case 413: 
            case 414: 
            case 418: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 452: 
            case 453: 
            case 454: 
            case 455: 
            case 456: 
            case 458: 
            case 461: 
            case 464: 
            case 469: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 7: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 13: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 77: 
            case 136: 
            case 441: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 409: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 26: 
            case 28: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 324: 
            case 325: 
            case 329: 
            case 331: 
            case 332: 
            case 333: 
            case 335: 
            case 338: 
            case 341: 
            case 377: 
            case 378: 
            case 450: 
            case 467: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 27: 
            case 103: 
            case 106: 
            case 183: 
            case 256: 
            case 258: 
            case 470: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 29: 
            case 130: 
            case 182: 
            case 252: 
            case 254: 
            case 468: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 33: 
            case 34: 
            case 434: 
            case 436: 
            case 438: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 44: 
            case 259: 
            case 262: 
            case 264: 
            case 266: 
            case 269: 
            case 405: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 45: 
            case 260: 
            case 263: 
            case 265: 
            case 267: 
            case 270: 
            case 406: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 86: 
            case 88: 
            case 90: 
            case 102: 
            case 105: 
            case 108: 
            case 129: 
            case 143: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 159: 
            case 161: 
            case 164: 
            case 233: 
            case 236: 
            case 239: 
            case 241: 
            case 244: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 283: 
            case 284: 
            case 287: 
            case 289: 
            case 291: 
            case 293: 
            case 295: 
            case 311: 
            case 350: 
            case 386: 
            case 393: 
            case 394: 
            case 403: 
            case 407: 
            case 446: 
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordsToIgnore";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 80: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelimiters";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 229: 
            case 231: 
            case 288: 
            case 290: 
            case 292: 
            case 294: 
            case 296: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 100: 
            case 113: 
            case 115: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 246: 
            case 396: 
            case 397: 
            case 399: 
            case 401: 
            case 430: 
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 119: 
            case 127: 
            case 339: 
            case 340: 
            case 360: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 132: 
            case 387: 
            case 391: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 160: 
            case 162: 
            case 174: 
            case 176: 
            case 187: 
            case 192: 
            case 195: 
            case 199: 
            case 203: 
            case 206: 
            case 209: 
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 175: 
            case 177: 
            case 184: 
            case 205: 
            case 208: 
            case 212: 
            case 214: 
            case 367: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 186: 
            case 191: 
            case 198: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 188: 
            case 190: 
            case 194: 
            case 197: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 204: 
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 221: 
            case 471: 
            case 473: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
            case 227: 
            case 228: 
            case 230: 
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 234: 
            case 237: 
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 240: 
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 275: 
            case 277: 
            case 279: 
            case 281: 
            case 421: 
            case 422: 
            case 440: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 276: 
            case 278: 
            case 280: 
            case 282: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 286: 
            case 298: 
            case 300: 
            case 304: 
            case 308: 
            case 310: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 326: {
                objectArray2 = objectArray3;
                objectArray3[0] = "character";
                break;
            }
            case 328: 
            case 330: 
            case 337: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 347: 
            case 348: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlString";
                break;
            }
            case 364: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 365: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 374: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 375: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 379: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 381: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 410: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 415: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 419: 
            case 420: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 428: 
            case 459: 
            case 462: 
            case 465: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 431: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 432: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 439: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 445: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 448: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 8: 
            case 366: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 63: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 73: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeAnsiStringCharacters";
                break;
            }
            case 81: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 104: 
            case 107: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 114: 
            case 116: 
            case 118: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 122: 
            case 124: 
            case 126: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 137: 
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 157: 
            case 158: 
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 178: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 216: {
                objectArray = objectArray2;
                objectArray2[1] = "joining";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 220: 
            case 222: 
            case 472: 
            case 474: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 223: 
            case 225: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 235: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 243: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 261: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 268: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 301: 
            case 302: 
            case 305: 
            case 306: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 313: 
            case 315: 
            case 316: 
            case 317: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 319: 
            case 320: 
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 323: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 327: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 336: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 344: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeXmlEntities";
                break;
            }
            case 346: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeXmlEntities";
                break;
            }
            case 349: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHtmlTags";
                break;
            }
            case 351: 
            case 352: 
            case 353: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEllipsisSuffix";
                break;
            }
            case 356: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 358: 
            case 361: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 368: 
            case 369: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 380: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 382: 
            case 383: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 388: 
            case 389: 
            case 390: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 392: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 395: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 398: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 404: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseWhiteSpace";
                break;
            }
            case 411: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 416: 
            case 417: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 426: 
            case 429: 
            case 457: 
            case 460: 
            case 463: 
            case 466: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 433: 
            case 435: 
            case 437: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 449: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 14: 
            case 32: 
            case 35: 
            case 39: 
            case 51: 
            case 54: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 144: 
            case 146: 
            case 157: 
            case 158: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 235: 
            case 238: 
            case 243: 
            case 249: 
            case 261: 
            case 268: 
            case 301: 
            case 302: 
            case 305: 
            case 306: 
            case 313: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 327: 
            case 334: 
            case 336: 
            case 342: 
            case 344: 
            case 346: 
            case 349: 
            case 351: 
            case 352: 
            case 353: 
            case 356: 
            case 358: 
            case 361: 
            case 366: 
            case 368: 
            case 369: 
            case 380: 
            case 382: 
            case 383: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 408: 
            case 411: 
            case 416: 
            case 417: 
            case 426: 
            case 429: 
            case 433: 
            case 435: 
            case 437: 
            case 449: 
            case 451: 
            case 457: 
            case 460: 
            case 463: 
            case 466: 
            case 472: 
            case 474: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 363: 
            case 364: 
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 26: 
            case 27: 
            case 469: 
            case 470: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 28: 
            case 29: 
            case 467: 
            case 468: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineColumn";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 68: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "unescapeAnsiStringCharacters";
                break;
            }
            case 80: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 441: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 113: 
            case 115: 
            case 117: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 221: 
            case 471: 
            case 473: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 228: 
            case 229: 
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 233: 
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 239: 
            case 240: 
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 244: 
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 246: 
            case 247: 
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 255: 
            case 256: 
            case 257: 
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 262: 
            case 263: 
            case 264: 
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 269: 
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 271: 
            case 275: 
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 272: 
            case 273: 
            case 274: 
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 285: 
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 295: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 297: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 299: 
            case 300: 
            case 303: 
            case 304: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 307: 
            case 308: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 309: 
            case 310: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 311: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 312: 
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 318: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 322: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 324: 
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 325: 
            case 326: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 329: 
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 332: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 333: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 335: 
            case 337: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 339: 
            case 340: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 343: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 345: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 347: 
            case 348: {
                objectArray = objectArray;
                objectArray[2] = "removeHtmlTags";
                break;
            }
            case 350: {
                objectArray = objectArray;
                objectArray[2] = "removeEllipsisSuffix";
                break;
            }
            case 354: {
                objectArray = objectArray;
                objectArray[2] = "escapeMnemonics";
                break;
            }
            case 355: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 357: 
            case 359: 
            case 360: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 362: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 370: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 371: 
            case 372: 
            case 373: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 376: 
            case 377: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 378: {
                objectArray = objectArray;
                objectArray[2] = "processCodePoints";
                break;
            }
            case 379: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 381: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 384: 
            case 385: 
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 393: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 396: 
            case 397: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 403: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 405: 
            case 406: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "collapseWhiteSpace";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 410: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 412: 
            case 414: 
            case 415: 
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 413: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 419: 
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 421: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "isLowerCase";
                break;
            }
            case 423: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 424: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 425: 
            case 427: 
            case 428: 
            case 456: 
            case 458: 
            case 459: 
            case 461: 
            case 462: 
            case 464: 
            case 465: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 430: 
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 432: 
            case 434: 
            case 436: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 438: 
            case 439: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 440: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 443: 
            case 444: 
            case 445: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "hasUpperCaseChar";
                break;
            }
            case 447: {
                objectArray = objectArray;
                objectArray[2] = "hasLowerCaseChar";
                break;
            }
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 450: {
                objectArray = objectArray;
                objectArray[2] = "parseHexString";
                break;
            }
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceForward";
                break;
            }
            case 453: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceOrNewLineForward";
                break;
            }
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceBackward";
                break;
            }
            case 455: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceOrNewLineBackward";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 14: 
            case 32: 
            case 35: 
            case 39: 
            case 51: 
            case 54: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 144: 
            case 146: 
            case 157: 
            case 158: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 235: 
            case 238: 
            case 243: 
            case 249: 
            case 261: 
            case 268: 
            case 301: 
            case 302: 
            case 305: 
            case 306: 
            case 313: 
            case 315: 
            case 316: 
            case 317: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 327: 
            case 334: 
            case 336: 
            case 342: 
            case 344: 
            case 346: 
            case 349: 
            case 351: 
            case 352: 
            case 353: 
            case 356: 
            case 358: 
            case 361: 
            case 366: 
            case 368: 
            case 369: 
            case 380: 
            case 382: 
            case 383: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 398: 
            case 400: 
            case 402: 
            case 404: 
            case 408: 
            case 411: 
            case 416: 
            case 417: 
            case 426: 
            case 429: 
            case 433: 
            case 435: 
            case 437: 
            case 449: 
            case 451: 
            case 457: 
            case 460: 
            case 463: 
            case 466: 
            case 472: 
            case 474: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class HtmlPatterns {
        private static final Pattern HTML_PATTERN = Pattern.compile("(?><[^>]*>)", 8);
        private static final Pattern BREAKS_PATTERN = Pattern.compile("(?><[bB][rR](?>\\s*)/?\\s*>)");

        private HtmlPatterns() {
        }
    }

    private static final class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();
        private final boolean myIsSkipStyleTag;
        private boolean myIsStyleTagOpened;

        private MyHtml2Text(boolean isSkipStyleTag) {
            this.myIsSkipStyleTag = isSkipStyleTag;
        }

        void parse(@NotNull Reader in) throws IOException {
            if (in == null) {
                MyHtml2Text.$$$reportNull$$$0(0);
            }
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char @NotNull [] text, int pos) {
            if (text == null) {
                MyHtml2Text.$$$reportNull$$$0(1);
            }
            if (!this.myIsStyleTagOpened) {
                this.myBuffer.append(text);
            }
        }

        @Override
        public void handleStartTag(@NotNull HTML.Tag tag, MutableAttributeSet set, int i) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(2);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = true;
            }
            this.handleTag(tag);
        }

        @Override
        public void handleEndTag(@NotNull HTML.Tag tag, int pos) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(3);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(@NotNull HTML.Tag tag) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(4);
            }
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(System.lineSeparator());
            }
        }

        @NotNull
        String getText() {
            String string = this.myBuffer.toString();
            if (string == null) {
                MyHtml2Text.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleStartTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleEndTag";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTag";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface CodePointProcessor {
        public boolean acceptCodePoint(int var1);
    }

    private static final class Splitters {
        private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
        private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
        private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
        private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");

        private Splitters() {
        }
    }

    private static final class ChildBombedCharSequence
    extends BombedCharSequence {
        private final BombedCharSequence myBombedParent;

        ChildBombedCharSequence(CharSequence sequence, BombedCharSequence bombedParent) {
            super(sequence);
            this.myBombedParent = bombedParent;
        }

        @Override
        protected void check() {
            this.myBombedParent.check();
        }

        @Override
        protected void checkCanceled() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;
        private boolean myDefused;

        protected BombedCharSequence(@NotNull CharSequence sequence) {
            if (sequence == null) {
                BombedCharSequence.$$$reportNull$$$0(0);
            }
            this.delegate = sequence;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if (this.myDefused) {
                return;
            }
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        public final void defuse() {
            this.myDefused = true;
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            String string = this.delegate.toString();
            if (string == null) {
                BombedCharSequence.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected abstract void checkCanceled();

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            this.check();
            CharSequence subSequence = this.delegate.subSequence(start, end);
            BombedCharSequence bombedParent = this instanceof ChildBombedCharSequence ? ((ChildBombedCharSequence)this).myBombedParent : this;
            return new ChildBombedCharSequence(subSequence, bombedParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

