/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import com.intellij.vcs.log.data.SingleTaskController;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0014J%\u0010\u0013\u001a\u00028\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\b\u0010\u0016\u001a\u0004\u0018\u00018\u0001H&\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/BaseSingleTaskController;", "Request", "Result", "Lcom/intellij/vcs/log/data/SingleTaskController;", "name", "", "resultConsumer", "Lkotlin/Function1;", "", "disposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/util/CheckedDisposable;)V", "startNewBackgroundTask", "Lcom/intellij/vcs/log/data/SingleTaskController$SingleTask;", "doRun", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createProgressIndicator", "process", "requests", "", "previousResult", "(Ljava/util/List;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.platform.vcs.log.impl"})
public abstract class BaseSingleTaskController<Request, Result>
extends SingleTaskController<Request, Result> {
    public BaseSingleTaskController(@NotNull String name, @NotNull Function1<? super Result, Unit> resultConsumer, @NotNull CheckedDisposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(resultConsumer, (String)"resultConsumer");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        super(name, (Disposable)disposable2, arg_0 -> BaseSingleTaskController._init_$lambda$1(arg_0 -> BaseSingleTaskController._init_$lambda$0(disposable2, resultConsumer, arg_0), arg_0));
    }

    @Override
    @NotNull
    protected SingleTaskController.SingleTask startNewBackgroundTask() {
        ProgressIndicator indicator = this.createProgressIndicator();
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        Logger logger = SingleTaskController.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        Future<?> future = BaseSingleTaskControllerKt.submitSafe(executorService, logger, (Function0<Unit>)((Function0)() -> BaseSingleTaskController.startNewBackgroundTask$lambda$0(indicator, this)));
        return new SingleTaskController.SingleTaskImpl(future, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRun(ProgressIndicator indicator) {
        Object result = null;
        try {
            while (true) {
                List requests;
                indicator.checkCanceled();
                Intrinsics.checkNotNullExpressionValue(this.popRequests(), (String)"popRequests(...)");
                if (!requests.isEmpty()) {
                    result = this.process(requests, result);
                    continue;
                }
                break;
            }
        }
        finally {
            this.taskCompleted(result);
        }
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        return (ProgressIndicator)new EmptyProgressIndicator();
    }

    public abstract Result process(@NotNull List<? extends Request> var1, @Nullable Result var2);

    private static final Unit _init_$lambda$0$0(Function1 $resultConsumer, Object $it) {
        $resultConsumer.invoke($it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(CheckedDisposable $disposable, Function1 $resultConsumer, Object it) {
        BaseSingleTaskControllerKt.runInEdt($disposable, (Function0<Unit>)((Function0)() -> BaseSingleTaskController._init_$lambda$0$0($resultConsumer, it)));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void startNewBackgroundTask$lambda$0$0(BaseSingleTaskController this$0, ProgressIndicator $indicator) {
        this$0.doRun($indicator);
    }

    private static final Unit startNewBackgroundTask$lambda$0(ProgressIndicator $indicator, BaseSingleTaskController this$0) {
        ProgressManager.getInstance().runProcess(() -> BaseSingleTaskController.startNewBackgroundTask$lambda$0$0(this$0, $indicator), $indicator);
        return Unit.INSTANCE;
    }
}

