/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0018\u0019B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\rH\u0004J\u000f\u0010\u0011\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00018\u0000H$\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0014\u001a\u0004\u0018\u00018\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\tR\u0010\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00018\u00008\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/ui/filter/FilterModel;", "Filter", "", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "<init>", "(Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;)V", "listeners", "", "Ljava/lang/Runnable;", "_filter", "Ljava/lang/Object;", "setFilter", "", "filter", "(Ljava/lang/Object;)V", "notifyFiltersChanged", "getFilter", "()Ljava/lang/Object;", "saveFilterToProperties", "getFilterFromProperties", "updateFilterFromProperties", "addSetFilterListener", "runnable", "SingleFilterModel", "MultipleFilterModel", "intellij.platform.vcs.log.impl"})
public abstract class FilterModel<Filter> {
    @JvmField
    @NotNull
    protected final MainVcsLogUiProperties uiProperties;
    @NotNull
    private final List<Runnable> listeners;
    @JvmField
    @Nullable
    protected Filter _filter;

    public FilterModel(@NotNull MainVcsLogUiProperties uiProperties) {
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        this.uiProperties = uiProperties;
        this.listeners = new ArrayList();
    }

    public void setFilter(@Nullable Filter filter) {
        this._filter = filter;
        this.saveFilterToProperties(filter);
        this.notifyFiltersChanged();
    }

    protected final void notifyFiltersChanged() {
        for (Runnable listener2 : this.listeners) {
            listener2.run();
        }
    }

    @Nullable
    public Filter getFilter() {
        if (this._filter == null) {
            this._filter = this.getFilterFromProperties();
        }
        return this._filter;
    }

    protected abstract void saveFilterToProperties(@Nullable Filter var1);

    @Nullable
    protected abstract Filter getFilterFromProperties();

    public final void updateFilterFromProperties() {
        this.setFilter(this.getFilterFromProperties());
    }

    public final void addSetFilterListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.listeners.add(runnable);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000e\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0014J'\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\n\b\u0001\u0010\u0016*\u0004\u0018\u00010\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0005\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u0012H$J$\u0010\u001b\u001a\u0004\u0018\u00010\u00122\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011H$J:\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0\u001e\"\n\b\u0001\u0010\u001f*\u0004\u0018\u00010\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u00052\b\b\u0002\u0010 \u001a\u00020!H\u0004R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/log/ui/filter/FilterModel$MultipleFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel;", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "keys", "", "Lcom/intellij/vcs/log/VcsLogFilterCollection$FilterKey;", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "initialFilters", "<init>", "(Ljava/util/Collection;Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "setFilter", "", "filter", "saveFilterToProperties", "getFilterFromProperties", "filtersList", "", "Lcom/intellij/vcs/log/VcsLogFilter;", "getFiltersList", "()Ljava/util/List;", "getFilter", "T", "key", "(Lcom/intellij/vcs/log/VcsLogFilterCollection$FilterKey;)Lcom/intellij/vcs/log/VcsLogFilter;", "getFilterValues", "", "createFilter", "values", "filterProperty", "Lkotlin/properties/ReadWriteProperty;", "F", "exclusive", "", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterModel.kt\ncom/intellij/vcs/log/ui/filter/FilterModel$MultipleFilterModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,150:1\n1#2:151\n1#2:163\n1#2:179\n1642#3,10:152\n1915#3:162\n1916#3:164\n1652#3:165\n1642#3,10:168\n1915#3:178\n1916#3:180\n1652#3:181\n37#4,2:166\n*S KotlinDebug\n*F\n+ 1 FilterModel.kt\ncom/intellij/vcs/log/ui/filter/FilterModel$MultipleFilterModel\n*L\n114#1:163\n121#1:179\n114#1:152,10\n114#1:162\n114#1:164\n114#1:165\n121#1:168,10\n121#1:178\n121#1:180\n121#1:181\n118#1:166,2\n*E\n"})
    public static abstract class MultipleFilterModel
    extends FilterModel<VcsLogFilterCollection> {
        @NotNull
        private final Collection<VcsLogFilterCollection.FilterKey<?>> keys;

        public MultipleFilterModel(@NotNull Collection<? extends VcsLogFilterCollection.FilterKey<?>> keys, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection initialFilters) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
            super(uiProperties);
            this.keys = keys;
            if (initialFilters != null) {
                this.saveFilterToProperties(initialFilters);
            }
        }

        @Override
        public void setFilter(@Nullable VcsLogFilterCollection filter) {
            boolean anyFilterDiffers = false;
            for (VcsLogFilterCollection.FilterKey<?> key : this.keys) {
                VcsLogFilterCollection vcsLogFilterCollection = filter;
                VcsLogFilter newFilter = vcsLogFilterCollection != null ? vcsLogFilterCollection.get(key) : null;
                VcsLogFilterCollection vcsLogFilterCollection2 = (VcsLogFilterCollection)this._filter;
                if (Intrinsics.areEqual((Object)newFilter, (Object)(vcsLogFilterCollection2 != null ? vcsLogFilterCollection2.get(key) : null))) continue;
                if (newFilter != null) {
                    VcsLogUsageTriggerCollector.triggerFilterSet(key.getName());
                }
                anyFilterDiffers = true;
            }
            if (anyFilterDiffers) {
                super.setFilter(filter);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void saveFilterToProperties(@Nullable VcsLogFilterCollection filter) {
            for (VcsLogFilterCollection.FilterKey<?> key : this.keys) {
                List<String> list;
                VcsLogFilterCollection vcsLogFilterCollection = filter;
                VcsLogFilter f = vcsLogFilterCollection != null ? vcsLogFilterCollection.get(key) : null;
                MainVcsLogUiProperties mainVcsLogUiProperties = this.uiProperties;
                String string = key.getName();
                if (f != null) {
                    void it;
                    String string2 = string;
                    MainVcsLogUiProperties mainVcsLogUiProperties2 = mainVcsLogUiProperties;
                    boolean bl = false;
                    List<String> list2 = this.getFilterValues((VcsLogFilter)it);
                    mainVcsLogUiProperties = mainVcsLogUiProperties2;
                    string = string2;
                    list = list2;
                } else {
                    list = null;
                }
                mainVcsLogUiProperties.saveFilterValues(string, list);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected VcsLogFilterCollection getFilterFromProperties() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.keys;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VcsLogFilter vcsLogFilter;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VcsLogFilterCollection.FilterKey key = (VcsLogFilterCollection.FilterKey)element$iv$iv;
                boolean bl2 = false;
                if (this.uiProperties.getFilterValues(key.getName()) != null) {
                    List<String> it;
                    boolean bl3 = false;
                    vcsLogFilter = this.createFilter(key, it);
                } else {
                    vcsLogFilter = null;
                }
                if (vcsLogFilter == null) continue;
                VcsLogFilter it$iv$iv = vcsLogFilter;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List filters = (List)destination$iv$iv;
            if (filters.isEmpty()) {
                return null;
            }
            Collection $this$toTypedArray$iv = filters;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            VcsLogFilter[] vcsLogFilterArray = thisCollection$iv.toArray(new VcsLogFilter[0]);
            return VcsLogFilterObject.collection(Arrays.copyOf(vcsLogFilterArray, vcsLogFilterArray.length));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VcsLogFilter> getFiltersList() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.keys;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VcsLogFilter it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VcsLogFilterCollection.FilterKey it = (VcsLogFilterCollection.FilterKey)element$iv$iv;
                boolean bl2 = false;
                VcsLogFilterCollection vcsLogFilterCollection = (VcsLogFilterCollection)this.getFilter();
                if ((vcsLogFilterCollection != null ? vcsLogFilterCollection.get(it) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final <T extends VcsLogFilter> T getFilter(@NotNull VcsLogFilterCollection.FilterKey<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            if (!this.keys.contains(key)) {
                return null;
            }
            VcsLogFilterCollection vcsLogFilterCollection = (VcsLogFilterCollection)this.getFilter();
            return (T)(vcsLogFilterCollection != null ? vcsLogFilterCollection.get(key) : null);
        }

        @Nullable
        protected abstract List<String> getFilterValues(@NotNull VcsLogFilter var1);

        @Nullable
        protected abstract VcsLogFilter createFilter(@NotNull VcsLogFilterCollection.FilterKey<?> var1, @NotNull List<String> var2);

        @NotNull
        protected final <F extends VcsLogFilter> ReadWriteProperty<MultipleFilterModel, F> filterProperty(@NotNull VcsLogFilterCollection.FilterKey<F> key, boolean exclusive) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return new ReadWriteProperty<MultipleFilterModel, F>(key, this, exclusive){
                final /* synthetic */ VcsLogFilterCollection.FilterKey<F> $key;
                final /* synthetic */ MultipleFilterModel this$0;
                final /* synthetic */ boolean $exclusive;
                {
                    this.$key = $key;
                    this.this$0 = $receiver;
                    this.$exclusive = $exclusive;
                }

                public F getValue(MultipleFilterModel thisRef, KProperty<?> property) {
                    Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                    Intrinsics.checkNotNullParameter(property, (String)"property");
                    return thisRef.getFilter(this.$key);
                }

                public void setValue(MultipleFilterModel thisRef, KProperty<?> property, F value) {
                    VcsLogFilterCollection vcsLogFilterCollection;
                    Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                    Intrinsics.checkNotNullParameter(property, (String)"property");
                    VcsLogFilterCollection oldFilter = (VcsLogFilterCollection)this.this$0.getFilter();
                    if (value == null) {
                        VcsLogFilterCollection vcsLogFilterCollection2 = oldFilter;
                        vcsLogFilterCollection = vcsLogFilterCollection2 != null ? VcsLogFiltersKt.without(vcsLogFilterCollection2, this.$key) : null;
                    } else if (this.$exclusive || oldFilter == null) {
                        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{value};
                        vcsLogFilterCollection = VcsLogFilterObject.collection(vcsLogFilterArray);
                    } else {
                        vcsLogFilterCollection = VcsLogFiltersKt.with(oldFilter, value);
                    }
                    VcsLogFilterCollection newFilter = vcsLogFilterCollection;
                    this.this$0.setFilter(newFilter);
                }
            };
        }

        public static /* synthetic */ ReadWriteProperty filterProperty$default(MultipleFilterModel multipleFilterModel, VcsLogFilterCollection.FilterKey filterKey, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filterProperty");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return multipleFilterModel.filterProperty(filterKey, bl);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000*\n\b\u0001\u0010\u0001*\u0004\u0018\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003B+\b\u0000\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u0004\u0018\u00018\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H$\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0018\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010\u0019R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/ui/filter/FilterModel$SingleFilterModel;", "Filter", "Lcom/intellij/vcs/log/VcsLogFilter;", "Lcom/intellij/vcs/log/ui/filter/FilterModel;", "filterKey", "Lcom/intellij/vcs/log/VcsLogFilterCollection$FilterKey;", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "initialFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "<init>", "(Lcom/intellij/vcs/log/VcsLogFilterCollection$FilterKey;Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "setFilter", "", "filter", "(Lcom/intellij/vcs/log/VcsLogFilter;)V", "createFilter", "values", "", "", "(Ljava/util/List;)Lcom/intellij/vcs/log/VcsLogFilter;", "getFilterValues", "(Lcom/intellij/vcs/log/VcsLogFilter;)Ljava/util/List;", "saveFilterToProperties", "getFilterFromProperties", "()Lcom/intellij/vcs/log/VcsLogFilter;", "intellij.platform.vcs.log.impl"})
    public static abstract class SingleFilterModel<Filter extends VcsLogFilter>
    extends FilterModel<Filter> {
        @NotNull
        private final VcsLogFilterCollection.FilterKey<? extends Filter> filterKey;

        public SingleFilterModel(@NotNull VcsLogFilterCollection.FilterKey<? extends Filter> filterKey, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection initialFilters) {
            Intrinsics.checkNotNullParameter(filterKey, (String)"filterKey");
            Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
            super(uiProperties);
            this.filterKey = filterKey;
            if (initialFilters != null) {
                this.saveFilterToProperties((Filter)initialFilters.get(this.filterKey));
            }
        }

        @Override
        public void setFilter(@Nullable Filter filter) {
            if (Intrinsics.areEqual((Object)this._filter, filter)) {
                return;
            }
            if (filter != null) {
                VcsLogUsageTriggerCollector.triggerFilterSet(this.filterKey.getName());
            }
            super.setFilter(filter);
        }

        @Nullable
        protected abstract Filter createFilter(@NotNull List<String> var1);

        @NotNull
        protected abstract List<String> getFilterValues(Filter var1);

        @Override
        protected void saveFilterToProperties(@Nullable Filter filter) {
            Filter Filter2 = filter;
            this.uiProperties.saveFilterValues(this.filterKey.getName(), Filter2 == null ? null : this.getFilterValues(Filter2));
        }

        @Override
        @Nullable
        protected Filter getFilterFromProperties() {
            List<String> list = this.uiProperties.getFilterValues(this.filterKey.getName());
            if (list == null) {
                return null;
            }
            List<String> values = list;
            return this.createFilter(values);
        }
    }
}

