/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dualView;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dualView.CellWrapper;
import com.intellij.ui.dualView.DualTreeElement;
import com.intellij.ui.dualView.DualViewColumnInfo;
import com.intellij.ui.dualView.TableCellRendererWrapper;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DualView
extends JPanel {
    private static final String TREE = "TREE";
    private static final String FLAT = "FLAT";
    private final CardLayout myCardLayout;
    private TreeTableView myTreeView;
    private JBTable myCurrentView;
    private TableView<?> myFlatView;
    private boolean myRootVisible;
    private CellWrapper myCellWrapper;
    private final String myFlatStorePrefix;
    private final Project project;
    private final String myTreeStorePrefix;
    private final PropertyChangeListener myPropertyChangeListener;
    private boolean myZipByHeight;
    private boolean mySuppressStore;

    public DualView(Object root, DualViewColumnInfo[] columns, @NonNls String columnServiceKey, @NotNull Project project) {
        if (project == null) {
            DualView.$$$reportNull$$$0(0);
        }
        super(new CardLayout());
        this.myTreeStorePrefix = columnServiceKey + "_tree";
        this.myFlatStorePrefix = columnServiceKey + "_flat";
        this.project = project;
        this.myCardLayout = (CardLayout)this.getLayout();
        this.add(this.createTreeComponent(columns, (TreeNode)root), TREE);
        this.add(this.createFlatComponent(columns), FLAT);
        this.myTreeView.getTreeViewModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                DualView.this.refreshFlatModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                DualView.this.refreshFlatModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                DualView.this.refreshFlatModel();
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DualView.this.refreshFlatModel();
            }
        });
        this.setRootVisible(true);
        this.switchToTheFlatMode();
        this.restoreState();
        this.myPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DualView.this.mySuppressStore) {
                    return;
                }
                DualView.this.saveState();
            }
        };
        this.addWidthListenersTo(this.myTreeView);
        this.addWidthListenersTo(this.myFlatView);
    }

    private void addWidthListenersTo(JTable treeView) {
        TableColumnModel columnModel = treeView.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            columnModel.getColumn(i).addPropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    public void restoreState() {
        PropertiesComponent propertyComponent = PropertiesComponent.getInstance((Project)this.project);
        BaseTableView.restore(propertyComponent, this.myFlatStorePrefix, this.myFlatView);
        BaseTableView.restore(propertyComponent, this.myTreeStorePrefix, this.myTreeView);
    }

    private void refreshFlatModel() {
        ((ListTableModel)this.myFlatView.getModel()).setItems(new ArrayList<DualTreeElement>(this.myTreeView.getFlattenItems()));
    }

    private static ColumnInfo[] createTreeColumns(DualViewColumnInfo[] columns) {
        ArrayList<ColumnInfo> result2 = new ArrayList<ColumnInfo>();
        final DualViewColumnInfo firstColumn = columns[0];
        ColumnInfo firstTreeColumn = new ColumnInfo(firstColumn.getName()){

            public Object valueOf(Object object) {
                return firstColumn.valueOf(object);
            }

            public Class getColumnClass() {
                return TreeTableModel.class;
            }

            public boolean isCellEditable(Object o) {
                return true;
            }
        };
        result2.add(firstTreeColumn);
        for (int i = 1; i < columns.length; ++i) {
            DualViewColumnInfo column = columns[i];
            if (!column.shouldBeShownIsTheTree()) continue;
            result2.add(column);
        }
        return result2.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    public void switchToTheFlatMode() {
        if (this.myFlatView == this.myCurrentView) {
            return;
        }
        DualView.copySelection(this.myTreeView, this.myFlatView);
        this.changeViewTo(this.myFlatView);
        this.myCardLayout.show(this, FLAT);
    }

    private void changeViewTo(JBTable view) {
        this.myCurrentView = view;
        if (this.myCurrentView != null) {
            this.myCurrentView.setAutoResizeMode(3);
            this.myCurrentView.setShowGrid(false);
            int row = this.myCurrentView.getSelectedRow();
            this.myCurrentView.scrollRectToVisible(this.myCurrentView.getCellRect(row, 0, true));
        }
    }

    private static void copySelection(SelectionProvider from, SelectionProvider to) {
        to.clearSelection();
        for (Object aSelection : from.getSelection()) {
            to.addSelection(aSelection);
        }
    }

    public void switchToTheTreeMode() {
        if (this.myTreeView == this.myCurrentView) {
            return;
        }
        DualView.copySelection(this.myFlatView, this.myTreeView);
        this.changeViewTo(this.myTreeView);
        this.myCardLayout.show(this, TREE);
    }

    private Component createTreeComponent(DualViewColumnInfo[] columns, TreeNode root) {
        this.myTreeView = new TreeTableView(new ListTreeTableModelOnColumns(root, DualView.createTreeColumns(columns))){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return DualView.this.createWrappedRenderer(super.getCellRenderer(row, column));
            }

            @Override
            public void doLayout() {
                try {
                    DualView.this.mySuppressStore = true;
                    super.doLayout();
                }
                finally {
                    DualView.this.mySuppressStore = false;
                }
            }
        };
        this.myTreeView.getTree().getSelectionModel().setSelectionMode(4);
        JPanel result2 = new JPanel(new BorderLayout());
        result2.add((Component)ScrollPaneFactory.createScrollPane(this.myTreeView), "Center");
        return result2;
    }

    private Component createFlatComponent(DualViewColumnInfo[] columns) {
        ArrayList<DualViewColumnInfo> shownColumns = new ArrayList<DualViewColumnInfo>();
        for (DualViewColumnInfo column : columns) {
            if (!column.shouldBeShownIsTheTable()) continue;
            shownColumns.add(column);
        }
        ListTableModel flatModel = new ListTableModel((ColumnInfo[])shownColumns.toArray(ColumnInfo.EMPTY_ARRAY));
        this.myFlatView = new TableView(flatModel){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return DualView.this.createWrappedRenderer(super.getCellRenderer(row, column));
            }

            @Override
            @NotNull
            public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
                Component c;
                if (renderer == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((c = super.prepareRenderer(renderer, row, column)) instanceof JComponent && !DualView.this.myFlatView.getCellSelectionEnabled()) {
                    ((JComponent)c).setBorder(null);
                }
                Component component = c;
                if (component == null) {
                    5.$$$reportNull$$$0(1);
                }
                return component;
            }

            @Override
            public void doLayout() {
                try {
                    DualView.this.mySuppressStore = true;
                    super.doLayout();
                }
                finally {
                    DualView.this.mySuppressStore = false;
                }
            }

            @Override
            public void updateColumnSizes() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renderer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/dualView/DualView$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/dualView/DualView$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepareRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepareRenderer";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        this.myFlatView.setCellSelectionEnabled(false);
        this.myFlatView.setColumnSelectionAllowed(false);
        this.myFlatView.setRowSelectionAllowed(true);
        this.refreshFlatModel();
        JPanel result2 = new JPanel(new BorderLayout());
        result2.add((Component)ScrollPaneFactory.createScrollPane(this.myFlatView), "Center");
        return result2;
    }

    private TableCellRenderer createWrappedRenderer(TableCellRenderer renderer) {
        if (this.myCellWrapper == null) {
            return renderer;
        }
        return new MyTableCellRendererWrapper(renderer);
    }

    public void expandAll() {
        DualView.expandPath(this.myTreeView.getTree(), new TreePath(this.myTreeView.getTree().getModel().getRoot()));
    }

    public void collapseAll() {
        this.collapsePath(this.myTreeView.getTree(), new TreePath(this.myTreeView.getTree().getModel().getRoot()));
    }

    private static void expandPath(JTree tree, TreePath path) {
        tree.expandPath(path);
        TreeNode node = (TreeNode)path.getLastPathComponent();
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            DualView.expandPath(tree, path.pathByAddingChild(child));
        }
    }

    private void collapsePath(JTree tree, TreePath path) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            this.collapsePath(tree, path.pathByAddingChild(child));
        }
        if (path.getLastPathComponent() != tree.getModel().getRoot() || this.myRootVisible) {
            tree.collapsePath(path);
        }
    }

    public List getSelection() {
        SelectionProvider visibleTable = (SelectionProvider)((Object)this.getVisibleTable());
        return new ArrayList(visibleTable.getSelection());
    }

    private JTable getVisibleTable() {
        return this.myCurrentView;
    }

    public void setShowGrid(boolean aBoolean) {
        this.myTreeView.setShowGrid(aBoolean);
    }

    public void setSelectionInterval(int first, int last) {
        int flatRowCount;
        int treeRowCount = this.myTreeView.getModel().getRowCount();
        if (first < 0 || last < 0) {
            return;
        }
        if (first < treeRowCount && last < treeRowCount) {
            this.myTreeView.getSelectionModel().addSelectionInterval(first, last);
        }
        if (first < (flatRowCount = this.myFlatView.getRowCount()) && last < flatRowCount) {
            this.myFlatView.getSelectionModel().addSelectionInterval(first, last);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.myTreeView.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.myFlatView.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public Tree getTree() {
        return this.myTreeView.getTree();
    }

    public TreeTableView getTreeView() {
        return this.myTreeView;
    }

    public TableView getFlatView() {
        return this.myFlatView;
    }

    public void setViewBorder(Border border) {
        if (this.myTreeView != null) {
            ((JComponent)this.myTreeView.getParent().getParent()).setBorder(border);
        }
        if (this.myFlatView != null) {
            ((JComponent)this.myFlatView.getParent().getParent()).setBorder(border);
        }
    }

    public void setRootVisible(boolean aBoolean) {
        this.myRootVisible = aBoolean;
        this.myTreeView.setRootVisible(this.myRootVisible);
    }

    public void setTreeCellRenderer(TreeCellRenderer cellRenderer) {
        this.myTreeView.setTreeCellRenderer(cellRenderer);
    }

    public void setCellWrapper(CellWrapper wrapper) {
        this.myCellWrapper = wrapper;
    }

    public void installDoubleClickHandler(AnAction action) {
        action.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, this.myFlatView);
        action.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, (JComponent)this.myTreeView);
    }

    public void dispose() {
        this.saveState();
    }

    public void saveState() {
        PropertiesComponent propertyComponent = PropertiesComponent.getInstance((Project)this.project);
        BaseTableView.store(propertyComponent, this.myFlatStorePrefix, this.myFlatView);
        BaseTableView.store(propertyComponent, this.myTreeStorePrefix, this.myTreeView);
    }

    public void setRoot(TreeNode node, List<Object> selection) {
        List<?> currentlySelected = this.myFlatView.getSelectedObjects();
        List<Object> targetSelection = !currentlySelected.isEmpty() ? currentlySelected : selection;
        this.myTreeView.getTreeViewModel().setRoot(node);
        if (targetSelection != null && !targetSelection.isEmpty()) {
            List<?> items = this.myFlatView.getItems();
            for (Object selElement : targetSelection) {
                if (!items.contains(selElement)) continue;
                int idx = items.indexOf(selElement);
                this.setSelectionInterval(idx, idx);
            }
        }
    }

    public void rebuild() {
        ((AbstractTableModel)this.myFlatView.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this.myTreeView.getModel()).fireTableDataChanged();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension was = super.getPreferredSize();
        if (!this.myZipByHeight) {
            return was;
        }
        int tableHeight = this.myFlatView.getTableHeader().getHeight() + this.myFlatView.getTableViewModel().getRowCount() * this.myFlatView.getRowHeight();
        return new Dimension(was.width, tableHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.myZipByHeight ? this.getPreferredSize() : super.getMinimumSize();
    }

    public void setZipByHeight(boolean zipByHeight) {
        this.myZipByHeight = zipByHeight;
    }

    public void setEmptyText(@NlsContexts.StatusText @NotNull String text) {
        if (text == null) {
            DualView.$$$reportNull$$$0(1);
        }
        this.myTreeView.getEmptyText().setText(text);
        this.myFlatView.getEmptyText().setText(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/dualView/DualView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setEmptyText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTableCellRendererWrapper
    implements TableCellRendererWrapper {
        @NotNull
        private final TableCellRenderer myRenderer;

        MyTableCellRendererWrapper(TableCellRenderer renderer) {
            if (renderer == null) {
                MyTableCellRendererWrapper.$$$reportNull$$$0(0);
            }
            this.myRenderer = renderer;
        }

        @Override
        @NotNull
        public TableCellRenderer getBaseRenderer() {
            TableCellRenderer tableCellRenderer = this.myRenderer;
            if (tableCellRenderer == null) {
                MyTableCellRendererWrapper.$$$reportNull$$$0(1);
            }
            return tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result2 = this.myRenderer.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            Object treeNode = null;
            int modelRow = table.convertRowIndexToModel(row);
            if (DualView.this.myCurrentView == DualView.this.myTreeView) {
                TreePath path = DualView.this.myTreeView.getTree().getPathForRow(modelRow);
                if (path != null) {
                    treeNode = path.getLastPathComponent();
                }
            } else if (DualView.this.myCurrentView == DualView.this.myFlatView) {
                treeNode = DualView.this.myFlatView.getItems().get(modelRow);
            }
            DualView.this.myCellWrapper.wrap(result2, table, value2, isSelected, hasFocus, row, column, treeNode);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/dualView/DualView$MyTableCellRendererWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/dualView/DualView$MyTableCellRendererWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

