/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayoutStrategy;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ScrollableSingleRowLayout
extends SingleRowLayout {
    public static final int DEADZONE_FOR_DECLARE_TAB_HIDDEN = 10;
    private int myScrollOffset = 0;
    private final boolean myWithScrollBar;

    public ScrollableSingleRowLayout(JBTabsImpl tabs) {
        this(tabs, false);
    }

    public ScrollableSingleRowLayout(JBTabsImpl tabs, boolean isWithScrollBar) {
        super(tabs);
        this.myWithScrollBar = isWithScrollBar;
    }

    @Override
    public int getScrollOffset() {
        return this.myScrollOffset;
    }

    @Override
    public void scroll(int units) {
        this.myScrollOffset += units;
        this.clampScrollOffsetToBounds(this.lastSingRowLayout);
    }

    @Override
    protected boolean checkLayoutLabels(SingleRowPassInfo data) {
        return true;
    }

    private void clampScrollOffsetToBounds(@Nullable SingleRowPassInfo data) {
        if (data == null) {
            return;
        }
        if (data.requiredLength < data.toFitLength) {
            this.myScrollOffset = 0;
        } else {
            int max = data.requiredLength - data.toFitLength + this.getMoreRectAxisSize();
            Insets actionInsets = this.tabs.getActionsInsets();
            max += this.tabs.isHorizontalTabs() ? actionInsets.left + actionInsets.right : actionInsets.top + actionInsets.bottom;
            if (!ExperimentalUI.isNewUI() && this.getStrategy() instanceof SingleRowLayoutStrategy.Vertical) {
                max += data.entryPointAxisSize;
            }
            this.myScrollOffset = Math.max(0, Math.min(this.myScrollOffset, max));
        }
    }

    private void doScrollToSelectedTab(SingleRowPassInfo passInfo) {
        if (this.tabs.isMouseInsideTabsArea() || this.tabs.isScrollBarAdjusting$intellij_platform_ide() || this.tabs.isRecentlyActive()) {
            return;
        }
        int offset = -this.myScrollOffset;
        for (TabInfo info : passInfo.visibleInfos) {
            int length = this.getRequiredLength(info);
            if (info == this.tabs.getSelectedInfo()) {
                if (offset < 0) {
                    this.scroll(offset);
                    break;
                }
                int maxLength = passInfo.toFitLength - this.getMoreRectAxisSize();
                Insets actionInsets = this.tabs.getActionsInsets();
                if (this.tabs.getEntryPointPreferredSize().width == 0) {
                    maxLength -= this.tabs.isHorizontalTabs() ? actionInsets.left + actionInsets.right : actionInsets.top + actionInsets.bottom;
                }
                if (!ExperimentalUI.isNewUI() && this.getStrategy() instanceof SingleRowLayoutStrategy.Vertical) {
                    maxLength -= passInfo.entryPointAxisSize;
                }
                if (offset + length <= maxLength) break;
                if (length < maxLength) {
                    this.scroll(offset + length - maxLength);
                    break;
                }
                this.scroll(offset);
                break;
            }
            offset += length;
        }
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data) {
        this.calculateRequiredLength(data);
        this.clampScrollOffsetToBounds(data);
        this.doScrollToSelectedTab(data);
        this.clampScrollOffsetToBounds(data);
    }

    @Override
    protected void layoutMoreButton(SingleRowPassInfo data) {
        if (data.requiredLength > data.toFitLength) {
            data.moreRect = this.getStrategy().getMoreRect(data);
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label2, int length) {
        if (!(data.requiredLength <= data.toFitLength || label2.isPinned() && TabLayout.showPinnedTabsSeparately())) {
            length = this.getStrategy().getLengthIncrement(label2.getPreferredSize());
            int moreRectSize = this.getMoreRectAxisSize();
            if (data.entryPointAxisSize == 0) {
                Insets insets = this.tabs.getActionsInsets();
                moreRectSize += insets.left + insets.right;
            }
            if (data.position + length > data.toFitLength - moreRectSize) {
                if (this.getStrategy().drawPartialOverflowTabs()) {
                    int clippedLength = ExperimentalUI.isNewUI() && this.tabs.getTabsPosition().isSide() ? length : data.toFitLength - data.position - moreRectSize;
                    Rectangle rec = this.getStrategy().getLayoutRect(data, data.position, clippedLength);
                    this.tabs.layout(label2, rec);
                }
                label2.setAlignmentToCenter(false);
                return false;
            }
        }
        return super.applyTabLayout(data, label2, length);
    }

    @Override
    public boolean isTabHidden(@NotNull TabInfo info) {
        if (info == null) {
            ScrollableSingleRowLayout.$$$reportNull$$$0(0);
        }
        TabLabel label2 = this.tabs.getTabLabel(info);
        Rectangle bounds = Objects.requireNonNull(label2).getBounds();
        int deadzone = JBUI.scale((int)10);
        return this.getStrategy().getMinPosition(bounds) < -deadzone || bounds.width < label2.getPreferredSize().width - deadzone || bounds.height < label2.getPreferredSize().height - deadzone;
    }

    @Override
    @Nullable
    protected TabLabel findLastVisibleLabel(SingleRowPassInfo data) {
        for (int i = data.toLayout.size() - 1; i >= 0; --i) {
            TabInfo info = data.toLayout.get(i);
            TabLabel label2 = this.tabs.getTabLabel(info);
            if (Objects.requireNonNull(label2).getBounds().isEmpty()) continue;
            return label2;
        }
        return null;
    }

    private int getMoreRectAxisSize() {
        if (ExperimentalUI.isNewUI() && this.tabs.getTabsPosition().isSide()) {
            return 0;
        }
        return this.getStrategy().getMoreRectAxisSize();
    }

    @Override
    public boolean isScrollable() {
        return true;
    }

    @Override
    public boolean isWithScrollBar() {
        return this.myWithScrollBar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ui/tabs/impl/singleRow/ScrollableSingleRowLayout", "isTabHidden"));
    }
}

