/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.invoke.MethodHandles;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003H\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0007\u001a@\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"getValidBoundsForPopup", "Ljava/awt/Rectangle;", "popup", "Ljava/awt/Component;", "moveToFitChildPopupX", "", "childBounds", "parent", "getNearestTopLevelParentBounds", "component", "getNearestTopLevelAncestor", "fitValue", "", "location", "width", "start1", "end1", "start2", "end2", "preferLess", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nWaylandUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaylandUtil.kt\ncom/intellij/util/ui/WaylandUtilKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n60#2,5:148\n60#2,5:153\n60#2,5:158\n60#2,5:163\n60#2,5:168\n60#2,5:173\n60#2,5:178\n60#2,5:183\n60#2,5:188\n60#2,5:193\n60#2,5:198\n60#2,5:203\n60#2,5:208\n60#2,5:213\n60#2,5:218\n60#2,5:223\n60#2,5:228\n57#2:233\n35#2,2:234\n*S KotlinDebug\n*F\n+ 1 WaylandUtil.kt\ncom/intellij/util/ui/WaylandUtilKt\n*L\n32#1:148,5\n42#1:153,5\n54#1:158,5\n56#1:163,5\n60#1:168,5\n62#1:173,5\n76#1:178,5\n88#1:183,5\n107#1:188,5\n109#1:193,5\n113#1:198,5\n119#1:203,5\n124#1:208,5\n128#1:213,5\n132#1:218,5\n137#1:223,5\n141#1:228,5\n146#1:233\n146#1:234,2\n*E\n"})
public final class WaylandUtilKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    @Nullable
    public static final Rectangle getValidBoundsForPopup(@NotNull Component popup) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        if (!popup.isShowing()) {
            LOG.warn("Impossible to determine the valid bounds because the popup is not showing: " + popup);
            return null;
        }
        Rectangle rectangle = WaylandUtilKt.getNearestTopLevelParentBounds(popup);
        if (rectangle == null) {
            return null;
        }
        Rectangle validBounds = rectangle;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The allowed bounds in screen coordinates are " + validBounds, t$iv);
        }
        Container directParent = popup.getParent();
        if (directParent == null) {
            LOG.warn("Impossible to determine the valid bounds because the popup has no direct parent: " + popup);
            return null;
        }
        Point directParentLocation = directParent.getLocationOnScreen();
        validBounds.x -= directParentLocation.x;
        validBounds.y -= directParentLocation.y;
        Logger $this$debug_u24default$iv2 = LOG;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("The allowed bounds in parent coordinates are " + validBounds, t$iv2);
        }
        return validBounds;
    }

    @ApiStatus.Internal
    public static final void moveToFitChildPopupX(@NotNull Rectangle childBounds, @NotNull Component parent) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)childBounds, (String)"childBounds");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!parent.isShowing()) {
            LOG.warn("Impossible to fit the child popup to the main window because the parent is not showing: " + parent);
            return;
        }
        Point childLocation = childBounds.getLocation();
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The initial child bounds are " + childBounds, t$iv);
        }
        SwingUtilities.convertPointToScreen(childLocation, parent);
        $this$debug_u24default$iv = LOG;
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The initial child location relative to the screen is " + childLocation, t$iv);
        }
        Rectangle rectangle = WaylandUtilKt.getNearestTopLevelParentBounds(parent);
        if (rectangle == null) {
            return;
        }
        Rectangle topLevelBounds = rectangle;
        Logger $this$debug_u24default$iv2 = LOG;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("The relative parent location is " + parent.getLocation(), t$iv2);
        }
        Rectangle parentBounds = new Rectangle(parent.getLocationOnScreen(), parent.getSize());
        Logger $this$debug_u24default$iv3 = LOG;
        Throwable t$iv3 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug_u24default$iv3.isDebugEnabled()) {
            logger = $this$debug_u24default$iv3;
            boolean bl = false;
            logger.debug("The screen parent bounds are " + parentBounds, t$iv3);
        }
        childLocation.x = WaylandUtilKt.fitValue(childLocation.x, childBounds.width, topLevelBounds.x, parentBounds.x, parentBounds.x + parentBounds.width, topLevelBounds.x + topLevelBounds.width, childLocation.x < parentBounds.x + parentBounds.width / 2);
        SwingUtilities.convertPointFromScreen(childLocation, parent);
        childBounds.setLocation(childLocation);
        $this$debug_u24default$iv3 = LOG;
        t$iv3 = null;
        $i$f$debug3 = false;
        if ($this$debug_u24default$iv3.isDebugEnabled()) {
            logger = $this$debug_u24default$iv3;
            boolean bl = false;
            logger.debug("The final result is " + childBounds, t$iv3);
        }
    }

    private static final Rectangle getNearestTopLevelParentBounds(Component component) {
        Component topLevelWindow = WaylandUtilKt.getNearestTopLevelAncestor(component);
        if (!(topLevelWindow instanceof Window)) {
            LOG.warn("The top level parent isn't a window, but " + topLevelWindow);
            return null;
        }
        Rectangle topLevelBounds = new Rectangle(((Window)topLevelWindow).getLocationOnScreen(), ((Window)topLevelWindow).getSize());
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The top level bounds are " + topLevelBounds, t$iv);
        }
        return topLevelBounds;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Component getNearestTopLevelAncestor(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return ComponentUtil.findParentByCondition(component, arg_0 -> WaylandUtilKt.getNearestTopLevelAncestor$lambda$1(WaylandUtilKt::getNearestTopLevelAncestor$lambda$0, arg_0));
    }

    private static final int fitValue(int location, int width, int start1, int end1, int start2, int end2, boolean preferLess) {
        int result;
        Logger logger;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The available intervals are " + start1 + ".." + end1 + " and " + start2 + ".." + end2 + ", the popup size is " + width, t$iv);
        }
        if (location >= start1 && location + width < end1) {
            $this$debug_u24default$iv = LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("The initial location already fits within the first interval", t$iv);
            }
            return location;
        }
        if (location >= start2 && location + width < end2) {
            $this$debug_u24default$iv = LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("The initial location already fits within the second interval", t$iv);
            }
            return location;
        }
        int space1 = end1 - start1;
        int space2 = end2 - start2;
        if (space1 >= width && space2 >= width) {
            Logger $this$debug_u24default$iv2 = LOG;
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("We have enough space on both sides, preferring the " + (preferLess ? "first" : "second"), t$iv2);
            }
            return preferLess ? end1 - width : start2;
        }
        if (space1 >= width) {
            result = end1 - width;
            Logger $this$debug_u24default$iv3 = LOG;
            Throwable t$iv3 = null;
            boolean $i$f$debug3 = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                logger = $this$debug_u24default$iv3;
                boolean bl = false;
                logger.debug("We have enough space the first side: " + space1 + " >= " + width + ", the result is " + end1 + "-" + width + "=" + result, t$iv3);
            }
            return result;
        }
        if (space2 >= width) {
            Logger $this$debug_u24default$iv4 = LOG;
            Throwable t$iv4 = null;
            boolean $i$f$debug4 = false;
            if ($this$debug_u24default$iv4.isDebugEnabled()) {
                logger = $this$debug_u24default$iv4;
                boolean bl = false;
                logger.debug("We have enough space the first side: " + space2 + " >= " + width + ", the result is " + start2, t$iv4);
            }
            return start2;
        }
        if (space1 > 0 && space1 > space2) {
            Logger $this$debug_u24default$iv5 = LOG;
            Throwable t$iv5 = null;
            boolean $i$f$debug5 = false;
            if ($this$debug_u24default$iv5.isDebugEnabled()) {
                logger = $this$debug_u24default$iv5;
                boolean bl = false;
                logger.debug("We have more space the first side: " + space1 + " > " + space2 + ", the result is " + start1, t$iv5);
            }
            return start1;
        }
        if (space2 > 0) {
            result = end2 - width;
            Logger $this$debug_u24default$iv6 = LOG;
            Throwable t$iv6 = null;
            boolean $i$f$debug6 = false;
            if ($this$debug_u24default$iv6.isDebugEnabled()) {
                logger = $this$debug_u24default$iv6;
                boolean bl = false;
                logger.debug("We have more space the second side: " + space1 + " <= " + space2 + ", the result is " + end2 + "-" + width + "=" + result, t$iv6);
            }
            return result;
        }
        Logger $this$debug_u24default$iv7 = LOG;
        Throwable t$iv7 = null;
        boolean $i$f$debug7 = false;
        if ($this$debug_u24default$iv7.isDebugEnabled()) {
            logger = $this$debug_u24default$iv7;
            boolean bl = false;
            logger.debug("We don't have any space at all, falling back to the initial value", t$iv7);
        }
        return location;
    }

    private static final boolean getNearestTopLevelAncestor$lambda$0(Component c) {
        return c instanceof Window && ((Window)c).getType() != Window.Type.POPUP;
    }

    private static final boolean getNearestTopLevelAncestor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

