/*
 * Decompiled with CFR 0.152.
 */
package runtime.stringUtils;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.stringUtils.Symbols;
import runtime.stringUtils.UnicodeUtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0007\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0001\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u00012\n\u0010\f\u001a\u00020\r\"\u00020\u000e\u001a\u001c\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0007\u001a\u0015\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0007H\u0086\u0002\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0007\u001a\u0018\u0010\u001e\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010 \u001a\u00020\u0001\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u0001\u001a\u0010\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u0001\u001a\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u0001\u001a\u0010\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b*\u00020\u0001\u001a\u001c\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020,0+0\u000b*\u00020\u0001\u001a0\u0010-\u001a\b\u0012\u0004\u0012\u0002H.0\u000b\"\u0004\b\u0000\u0010.*\b\u0012\u0004\u0012\u0002H.0\u000b2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u00020,00\u001a@\u00101\u001a\u00020\u0001*\u00020\u00012\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00010+0\u000b2\u001a\b\u0002\u00103\u001a\u0014\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020504\u001a\u001a\u00106\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u000b2\b\b\u0002\u00107\u001a\u00020\u0001\u001a\n\u00108\u001a\u00020\u0001*\u00020\u0001\"\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\"\u000e\u0010(\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"getPostfix", "", "string", "prefix", "pluralize", "count", "", "", "", "singularize", "splitByCamelHumpsAndPunctuation", "", "letterLikeChars", "", "", "surround", "symbols", "reverseSuffix", "", "quoted", "quotation", "ellipsize", "maxLength", "times", "n", "removePrefixOrNull", "removeSuffixOrNull", "suffix", "withNbsp", "limitedView", "containsIgnoreCase", "", "element", "whitespaceRegex", "Lkotlin/text/Regex;", "getWhitespaceRegex", "()Lkotlin/text/Regex;", "removeWhitespace", "splitByWhitespace", "splitByWordBoundaries", "wordBoundaryRegex", "wordBoundaryIndexes", "splitByWhitespaceWithRanges", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "withoutIntersections", "T", "getRange", "Lkotlin/Function1;", "replace", "ranges", "mapTextBetweenRanges", "Lkotlin/Function2;", "", "joinWithOxfordComma", "conjunction", "nonEmptyName", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\nruntime/stringUtils/StringUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1179#2,2:201\n1755#3,3:203\n774#3:206\n865#3,2:207\n2953#3:209\n2853#3,3:210\n2856#3,6:214\n739#3,9:220\n774#3:229\n865#3:230\n866#3:232\n1#4:213\n1#4:231\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\nruntime/stringUtils/StringUtilsKt\n*L\n46#1:201,2\n111#1:203,3\n129#1:206\n129#1:207,2\n130#1:209\n130#1:210,3\n130#1:214,6\n131#1:220,9\n152#1:229\n152#1:230\n152#1:232\n130#1:213\n*E\n"})
public final class StringUtilsKt {
    @NotNull
    private static final Regex whitespaceRegex = new Regex("\\s");
    @NotNull
    private static final Regex wordBoundaryRegex = new Regex("\\b");

    @NotNull
    public static final String getPostfix(@NotNull String string, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        CharSequence charSequence = string;
        Regex regex = new Regex(prefix + "(.*)");
        String string2 = "$1";
        return regex.replaceFirst(charSequence, string2);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return StringUtilsKt.pluralize($this$pluralize, 2);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, double count) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return count == 1.0 ? $this$pluralize : (StringsKt.endsWith$default((String)$this$pluralize, (String)"s", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"ch", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"x", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"z", (boolean)false, (int)2, null) ? $this$pluralize + "es" : (StringsKt.endsWith$default((String)$this$pluralize, (String)"y", (boolean)false, (int)2, null) ? (StringsKt.endsWith$default((String)$this$pluralize, (String)"ay", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"ey", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"oy", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"uy", (boolean)false, (int)2, null) ? $this$pluralize + "s" : (StringsKt.endsWith$default((String)$this$pluralize, (String)"iy", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)$this$pluralize, (int)1) + "es" : StringsKt.dropLast((String)$this$pluralize, (int)1) + "ies")) : $this$pluralize + "s"));
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, int count) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return StringUtilsKt.pluralize($this$pluralize, (double)count);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, long count) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return StringUtilsKt.pluralize($this$pluralize, (double)count);
    }

    @NotNull
    public static final String singularize(@NotNull String $this$singularize) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$singularize, (String)"<this>");
        if (StringsKt.endsWith$default((String)$this$singularize, (String)"ies", (boolean)false, (int)2, null)) {
            object = StringsKt.dropLast((String)$this$singularize, (int)3) + "y";
        } else if (StringsKt.endsWith$default((String)$this$singularize, (String)"es", (boolean)false, (int)2, null)) {
            String string;
            String it = string = StringsKt.dropLast((String)$this$singularize, (int)2);
            boolean bl = false;
            object = StringsKt.endsWith$default((CharSequence)it, (char)'s', (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"ch", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)it, (char)'x', (boolean)false, (int)2, null) ? string : null;
            if (object == null) {
                object = StringsKt.dropLast((String)$this$singularize, (int)1);
            }
        } else {
            object = StringsKt.endsWith$default((CharSequence)$this$singularize, (char)'s', (boolean)false, (int)2, null) ? StringsKt.dropLast((String)$this$singularize, (int)1) : $this$singularize;
        }
        return object;
    }

    @NotNull
    public static final List<String> splitByCamelHumpsAndPunctuation(@NotNull String $this$splitByCamelHumpsAndPunctuation, char ... letterLikeChars) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByCamelHumpsAndPunctuation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)letterLikeChars, (String)"letterLikeChars");
        StringBuilder currentToken = new StringBuilder();
        List result2 = new ArrayList();
        boolean isPrevUpperCase = false;
        CharSequence $this$forEach$iv = $this$splitByCamelHumpsAndPunctuation;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            StringBuilder stringBuilder;
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            boolean isUpperCase = UnicodeUtilKt.isUpperCase(c);
            if (!UnicodeUtilKt.isAlphaNumeric(c) && !ArraysKt.contains((char[])letterLikeChars, (char)c)) {
                StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
                stringBuilder = Unit.INSTANCE;
            } else if (!isPrevUpperCase && isUpperCase) {
                StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
                stringBuilder = currentToken.append(c);
            } else {
                stringBuilder = currentToken.append(c);
            }
            isPrevUpperCase = isUpperCase;
        }
        StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
        return result2;
    }

    @NotNull
    public static final String surround(@NotNull String $this$surround, @NotNull String symbols, boolean reverseSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$surround, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        return symbols + $this$surround + (reverseSuffix ? ((Object)StringsKt.reversed((CharSequence)symbols)).toString() : symbols);
    }

    public static /* synthetic */ String surround$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringUtilsKt.surround(string, string2, bl);
    }

    @NotNull
    public static final String quoted(@NotNull String $this$quoted, @NotNull String quotation) {
        Intrinsics.checkNotNullParameter((Object)$this$quoted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)quotation, (String)"quotation");
        return StringUtilsKt.surround$default($this$quoted, quotation, false, 2, null);
    }

    public static /* synthetic */ String quoted$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "\"";
        }
        return StringUtilsKt.quoted(string, string2);
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        return $this$ellipsize + Symbols.Ellipsis;
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        return $this$ellipsize.length() > maxLength ? StringsKt.take((String)$this$ellipsize, (int)(maxLength - 1)) + Symbols.Ellipsis : StringsKt.take((String)$this$ellipsize, (int)maxLength);
    }

    @NotNull
    public static final String times(@NotNull String $this$times, int n) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        switch (n) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = $this$times;
                break;
            }
            default: {
                int i = 0;
                StringBuilder result2 = new StringBuilder($this$times);
                while (++i < n) {
                    result2.append($this$times);
                }
                String string2 = result2.toString();
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            }
        }
        return string;
    }

    @Nullable
    public static final String removePrefixOrNull(@NotNull String $this$removePrefixOrNull, @NotNull String prefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$removePrefixOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (StringsKt.startsWith$default((String)$this$removePrefixOrNull, (String)prefix, (boolean)false, (int)2, null)) {
            String string2 = $this$removePrefixOrNull.substring(prefix.length());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String removeSuffixOrNull(@NotNull String $this$removeSuffixOrNull, @NotNull String suffix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$removeSuffixOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        if (StringsKt.endsWith$default((String)$this$removeSuffixOrNull, (String)suffix, (boolean)false, (int)2, null)) {
            String string2 = $this$removeSuffixOrNull.substring(0, $this$removeSuffixOrNull.length() - suffix.length());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String withNbsp(@NotNull String $this$withNbsp) {
        Intrinsics.checkNotNullParameter((Object)$this$withNbsp, (String)"<this>");
        return StringsKt.replace$default((String)$this$withNbsp, (String)" ", (String)Symbols.Nbsp.toString(), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String limitedView(@NotNull String $this$limitedView, int maxLength) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$limitedView, (String)"<this>");
        if ($this$limitedView.length() > maxLength) {
            String string = $this$limitedView.substring(0, maxLength - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = string + "...";
        } else {
            object = $this$limitedView;
        }
        return object;
    }

    public static final boolean containsIgnoreCase(@NotNull Collection<String> $this$containsIgnoreCase, @NotNull String element) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$containsIgnoreCase, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Iterable $this$any$iv = $this$containsIgnoreCase;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)element, (String)it, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final Regex getWhitespaceRegex() {
        return whitespaceRegex;
    }

    @NotNull
    public static final String removeWhitespace(@NotNull String $this$removeWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$removeWhitespace, (String)"<this>");
        CharSequence charSequence = $this$removeWhitespace;
        Regex regex = whitespaceRegex;
        String string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final List<String> splitByWhitespace(@NotNull String $this$splitByWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByWhitespace, (String)"<this>");
        CharSequence charSequence = $this$splitByWhitespace;
        Regex regex = whitespaceRegex;
        int n = 0;
        return regex.split(charSequence, n);
    }

    @NotNull
    public static final List<String> splitByWordBoundaries(@NotNull String $this$splitByWordBoundaries) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByWordBoundaries, (String)"<this>");
        CharSequence charSequence = $this$splitByWordBoundaries;
        Regex regex = wordBoundaryRegex;
        int n = 0;
        return regex.split(charSequence, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Integer> wordBoundaryIndexes(@NotNull String $this$wordBoundaryIndexes) {
        List list2;
        List list3;
        void $this$scan$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$wordBoundaryIndexes, (String)"<this>");
        Iterable $this$filter$iv = StringUtilsKt.splitByWordBoundaries($this$wordBoundaryIndexes);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Integer initial$iv = 0;
        boolean $i$f$scan = false;
        void $this$runningFold$iv$iv = $this$scan$iv;
        boolean $i$f$runningFold = false;
        int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv$iv, (int)9);
        if (estimatedSize$iv$iv == 0) {
            list3 = CollectionsKt.listOf((Object)initial$iv);
        } else {
            Object element$iv$iv;
            Object $this$runningFold_u24lambda_u2421$iv$iv = element$iv$iv = new ArrayList(estimatedSize$iv$iv + 1);
            boolean bl = false;
            ((ArrayList)$this$runningFold_u24lambda_u2421$iv$iv).add((Integer)initial$iv);
            Object result$iv$iv = element$iv$iv;
            Integer accumulator$iv$iv = initial$iv;
            for (Object element$iv$iv2 : $this$runningFold$iv$iv) {
                void word;
                String string = (String)element$iv$iv2;
                int len = ((Number)accumulator$iv$iv).intValue();
                boolean bl3 = false;
                accumulator$iv$iv = len + word.length();
                ((ArrayList)result$iv$iv).add(accumulator$iv$iv);
            }
            list3 = (List)result$iv$iv;
        }
        List $this$dropLastWhile$iv = list3;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                int it = ((Number)iterator$iv.previous()).intValue();
                boolean bl = false;
                if (it >= $this$wordBoundaryIndexes.length()) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final List<Pair<String, IntRange>> splitByWhitespaceWithRanges(@NotNull String $this$splitByWhitespaceWithRanges) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByWhitespaceWithRanges, (String)"<this>");
        Ref.IntRef prevIndex = new Ref.IntRef();
        Sequence wordBoundaries2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super IntRange>, Continuation<? super Unit>, Object>($this$splitByWhitespaceWithRanges, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $this_splitByWhitespaceWithRanges;
            {
                this.$this_splitByWhitespaceWithRanges = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yieldAll(SequencesKt.map((Sequence)Regex.findAll$default((Regex)StringUtilsKt.getWhitespaceRegex(), (CharSequence)this.$this_splitByWhitespaceWithRanges, (int)0, (int)2, null), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(kotlin.text.MatchResult ), (Lkotlin/text/MatchResult;)Lkotlin/ranges/IntRange;)()), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = $this$sequence.yield((Object)new IntRange(this.$this_splitByWhitespaceWithRanges.length(), this.$this_splitByWhitespaceWithRanges.length()), (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super IntRange> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final IntRange invokeSuspend$lambda$0(MatchResult it) {
                return it.getRange();
            }
        }));
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)wordBoundaries2, arg_0 -> StringUtilsKt.splitByWhitespaceWithRanges$lambda$9(prevIndex, $this$splitByWhitespaceWithRanges, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> withoutIntersections(@NotNull List<? extends T> $this$withoutIntersections, @NotNull Function1<? super T, IntRange> getRange) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$withoutIntersections, (String)"<this>");
        Intrinsics.checkNotNullParameter(getRange, (String)"getRange");
        int lastRangeEndIx = 0;
        lastRangeEndIx = -1;
        Function1[] function1Array = new Function1[]{arg_0 -> StringUtilsKt.withoutIntersections$lambda$10(getRange, arg_0), arg_0 -> StringUtilsKt.withoutIntersections$lambda$11(getRange, arg_0)};
        Iterable $this$filter$iv = CollectionsKt.sortedWith((Iterable)$this$withoutIntersections, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            boolean $this$withoutIntersections_u24lambda_u2413_u24lambda_u2412 = bl = ((IntRange)getRange.invoke(it)).getFirst() > lastRangeEndIx;
            boolean bl3 = false;
            lastRangeEndIx = ((IntRange)getRange.invoke(it)).getLast();
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String replace(@NotNull String $this$replace, @NotNull List<Pair<IntRange, String>> ranges2, @NotNull Function2<? super CharSequence, ? super IntRange, ? extends CharSequence> mapTextBetweenRanges) {
        Intrinsics.checkNotNullParameter((Object)$this$replace, (String)"<this>");
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        Intrinsics.checkNotNullParameter(mapTextBetweenRanges, (String)"mapTextBetweenRanges");
        if (ranges2.isEmpty()) {
            return mapTextBetweenRanges.invoke((Object)$this$replace, (Object)StringsKt.getIndices((CharSequence)$this$replace)).toString();
        }
        Object result2 = "";
        int pos = 0;
        Pair pair2 = new Pair[]{StringUtilsKt::replace$lambda$15, StringUtilsKt::replace$lambda$16};
        for (Pair pair2 : CollectionsKt.sortedWith((Iterable)ranges2, (Comparator)ComparisonsKt.compareBy((Function1[])pair2))) {
            IntRange range3 = (IntRange)pair2.component1();
            String serverView = (String)pair2.component2();
            int n = $this$replace.length();
            int n2 = range3.getFirst();
            boolean bl = pos <= n2 ? n2 < n : false;
            if (!bl) continue;
            if (pos < range3.getFirst()) {
                result2 = (String)result2 + mapTextBetweenRanges.invoke((Object)$this$replace.subSequence(pos, range3.getFirst()), (Object)RangesKt.until((int)pos, (int)range3.getFirst()));
            }
            result2 = (String)result2 + serverView;
            pos = range3.getLast() + 1;
        }
        if (pos < $this$replace.length()) {
            result2 = (String)result2 + mapTextBetweenRanges.invoke((Object)$this$replace.subSequence(pos, $this$replace.length()), (Object)RangesKt.until((int)pos, (int)$this$replace.length()));
        }
        return result2;
    }

    public static /* synthetic */ String replace$default(String string, List list2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = StringUtilsKt::replace$lambda$14;
        }
        return StringUtilsKt.replace(string, list2, (Function2<? super CharSequence, ? super IntRange, ? extends CharSequence>)function2);
    }

    @NotNull
    public static final String joinWithOxfordComma(@NotNull List<String> $this$joinWithOxfordComma, @NotNull String conjunction) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$joinWithOxfordComma, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)conjunction, (String)"conjunction");
        List<String> list2 = $this$joinWithOxfordComma;
        StringBuilder $this$joinWithOxfordComma_u24lambda_u2417 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (list2.size() == 1) {
            $this$joinWithOxfordComma_u24lambda_u2417.append((String)CollectionsKt.single(list2));
        } else if (list2.size() == 2) {
            $this$joinWithOxfordComma_u24lambda_u2417.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)(" " + conjunction + " "), null, null, (int)0, null, null, (int)62, null));
        } else if (list2.size() > 2) {
            $this$joinWithOxfordComma_u24lambda_u2417.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)list2, (int)CollectionsKt.getLastIndex(list2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ", " + conjunction + " " + CollectionsKt.last(list2));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String joinWithOxfordComma$default(List list2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "or";
        }
        return StringUtilsKt.joinWithOxfordComma(list2, string);
    }

    @NotNull
    public static final String nonEmptyName(@NotNull String $this$nonEmptyName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$nonEmptyName, (String)"<this>");
        CharSequence charSequence2 = $this$nonEmptyName;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "Untitled";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final void splitByCamelHumpsAndPunctuation$flushToken(StringBuilder currentToken, List<String> result2) {
        if (((CharSequence)currentToken).length() > 0) {
            String string = currentToken.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            result2.add(string);
            StringsKt.clear((StringBuilder)currentToken);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Pair splitByWhitespaceWithRanges$lambda$9(Ref.IntRef $prevIndex, String $this_splitByWhitespaceWithRanges, IntRange range3) {
        IntRange intRange;
        IntRange intRange2;
        Intrinsics.checkNotNullParameter((Object)$prevIndex, (String)"$prevIndex");
        Intrinsics.checkNotNullParameter((Object)$this_splitByWhitespaceWithRanges, (String)"$this_splitByWhitespaceWithRanges");
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        IntRange it = intRange2 = range3;
        boolean bl = false;
        if (it.getFirst() <= $prevIndex.element) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        IntRange intRange3 = intRange2;
        IntRange intRange4 = intRange3;
        if (intRange4 == null) return null;
        IntRange it2 = intRange4;
        boolean bl3 = false;
        String string = $this_splitByWhitespaceWithRanges.substring($prevIndex.element, it2.getFirst());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        intRange2 = TuplesKt.to((Object)string, (Object)RangesKt.until((int)$prevIndex.element, (int)it2.getFirst()));
        if (intRange2 == null) return null;
        it2 = intRange = intRange2;
        boolean bl4 = false;
        $prevIndex.element = range3.getLast() + 1;
        IntRange intRange5 = intRange;
        return intRange5;
    }

    private static final Comparable withoutIntersections$lambda$10(Function1 $getRange, Object it) {
        Intrinsics.checkNotNullParameter((Object)$getRange, (String)"$getRange");
        return Integer.valueOf(((IntRange)$getRange.invoke(it)).getFirst());
    }

    private static final Comparable withoutIntersections$lambda$11(Function1 $getRange, Object it) {
        Intrinsics.checkNotNullParameter((Object)$getRange, (String)"$getRange");
        return Integer.valueOf(-((IntRange)$getRange.invoke(it)).getLast());
    }

    private static final CharSequence replace$lambda$14(CharSequence str, IntRange intRange) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)intRange, (String)"<unused var>");
        return str;
    }

    private static final Comparable replace$lambda$15(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(((IntRange)it.getFirst()).getFirst());
    }

    private static final Comparable replace$lambda$16(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(-((IntRange)it.getFirst()).getLast());
    }
}

