/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0014J\u0015\u0010\u001e\u001a\u00070\u0007\u00a2\u0006\u0002\b\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/changes/DirtBuilder;", "", "<init>", "()V", "scopesByVcs", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeBuilder;", "value", "", "isEverythingDirty", "()Z", "isEmpty", "markEverythingDirty", "", "addDirtyFiles", "vcsRoot", "Lcom/intellij/openapi/vcs/VcsRoot;", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "dirs", "addDirtyRoot", "buildScopes", "", "Lcom/intellij/openapi/vcs/changes/VcsModifiableDirtyScope;", "project", "Lcom/intellij/openapi/project/Project;", "isFileDirty", "filePath", "createDirtyScope", "Lorg/jetbrains/annotations/Nullable;", "vcs", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nDirtBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirtBuilder.kt\ncom/intellij/openapi/vcs/changes/DirtBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1586#2:78\n1661#2,3:79\n1807#2,3:82\n*S KotlinDebug\n*F\n+ 1 DirtBuilder.kt\ncom/intellij/openapi/vcs/changes/DirtBuilder\n*L\n71#1:78\n71#1:79,3\n74#1:82,3\n*E\n"})
public final class DirtBuilder {
    @NotNull
    private final Map<AbstractVcs, VcsDirtyScopeBuilder> scopesByVcs = new LinkedHashMap();
    private boolean isEverythingDirty;

    public final boolean isEverythingDirty() {
        return this.isEverythingDirty;
    }

    public final boolean isEmpty() {
        return !this.isEverythingDirty && this.scopesByVcs.isEmpty();
    }

    public final void markEverythingDirty() {
        this.isEverythingDirty = true;
        this.scopesByVcs.clear();
    }

    public final boolean addDirtyFiles(@NotNull VcsRoot vcsRoot, @NotNull Collection<? extends FilePath> files, @NotNull Collection<? extends FilePath> dirs) {
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(dirs, (String)"dirs");
        if (this.isEverythingDirty) {
            return true;
        }
        AbstractVcs vcs = vcsRoot.getVcs();
        VirtualFile virtualFile = vcsRoot.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getPath(...)");
        VirtualFile root = virtualFile;
        if (vcs != null) {
            VcsDirtyScopeBuilder vcsDirtyScopeBuilder = this.scopesByVcs.computeIfAbsent(vcs, arg_0 -> DirtBuilder.addDirtyFiles$lambda$1(arg_0 -> DirtBuilder.addDirtyFiles$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirtyScopeBuilder, (String)"computeIfAbsent(...)");
            VcsDirtyScopeBuilder scope = vcsDirtyScopeBuilder;
            for (FilePath filePath : files) {
                scope.addDirtyPathFast(root, filePath, false);
            }
            for (FilePath filePath : dirs) {
                scope.addDirtyPathFast(root, filePath, true);
            }
        }
        return !this.scopesByVcs.isEmpty();
    }

    public final boolean addDirtyRoot(@NotNull VcsRoot vcsRoot) {
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        if (this.isEverythingDirty) {
            return true;
        }
        AbstractVcs vcs = vcsRoot.getVcs();
        if (vcs != null) {
            VcsDirtyScopeBuilder vcsDirtyScopeBuilder = this.scopesByVcs.computeIfAbsent(vcs, arg_0 -> DirtBuilder.addDirtyRoot$lambda$1(arg_0 -> DirtBuilder.addDirtyRoot$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirtyScopeBuilder, (String)"computeIfAbsent(...)");
            VcsDirtyScopeBuilder scope = vcsDirtyScopeBuilder;
            scope.markRootDirty(vcsRoot.getPath());
        }
        return !this.scopesByVcs.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsModifiableDirtyScope> buildScopes(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        VcsDirtyScopeBuilder scope;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection<Object> scopes = null;
        if (this.isEverythingDirty) {
            Map allScopes = new LinkedHashMap();
            for (VcsRoot root : ProjectLevelVcsManager.Companion.getInstance(project).getAllVcsRoots()) {
                VirtualFile path;
                AbstractVcs vcs = root.getVcs();
                Intrinsics.checkNotNullExpressionValue((Object)root.getPath(), (String)"getPath(...)");
                if (vcs == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)allScopes.computeIfAbsent(vcs, arg_0 -> DirtBuilder.buildScopes$lambda$1(arg_0 -> DirtBuilder.buildScopes$lambda$0(this, arg_0), arg_0)), (String)"computeIfAbsent(...)");
                scope.markEverythingDirty();
                scope.addDirtyPathFast(path, VcsUtil.getFilePath((VirtualFile)path), true);
            }
            scopes = allScopes.values();
        } else {
            scopes = this.scopesByVcs.values();
        }
        Iterable $this$map$iv = scopes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            scope = (VcsDirtyScopeBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.pack());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFileDirty(@NotNull FilePath filePath) {
        VcsDirtyScopeBuilder it;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.isEverythingDirty) return true;
        Iterable $this$any$iv = this.scopesByVcs.values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (VcsDirtyScopeBuilder)element$iv;
            boolean bl = false;
        } while (!it.belongsTo(filePath));
        return true;
    }

    private final VcsDirtyScopeBuilder createDirtyScope(AbstractVcs vcs) {
        VcsDirtyScopeBuilder vcsDirtyScopeBuilder = vcs.createDirtyScope();
        if (vcsDirtyScopeBuilder == null) {
            vcsDirtyScopeBuilder = new VcsDirtyScopeImpl(vcs);
        }
        return vcsDirtyScopeBuilder;
    }

    private static final VcsDirtyScopeBuilder addDirtyFiles$lambda$0(DirtBuilder this$0, AbstractVcs key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this$0.createDirtyScope(key);
    }

    private static final VcsDirtyScopeBuilder addDirtyFiles$lambda$1(Function1 $tmp0, Object p0) {
        return (VcsDirtyScopeBuilder)$tmp0.invoke(p0);
    }

    private static final VcsDirtyScopeBuilder addDirtyRoot$lambda$0(DirtBuilder this$0, AbstractVcs key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this$0.createDirtyScope(key);
    }

    private static final VcsDirtyScopeBuilder addDirtyRoot$lambda$1(Function1 $tmp0, Object p0) {
        return (VcsDirtyScopeBuilder)$tmp0.invoke(p0);
    }

    private static final VcsDirtyScopeBuilder buildScopes$lambda$0(DirtBuilder this$0, AbstractVcs key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this$0.createDirtyScope(key);
    }

    private static final VcsDirtyScopeBuilder buildScopes$lambda$1(Function1 $tmp0, Object p0) {
        return (VcsDirtyScopeBuilder)$tmp0.invoke(p0);
    }
}

