/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

final class PatternDialog
extends DialogWrapper {
    private final TodoPattern myPattern;
    private final ComboBox<Icon> myIconComboBox;
    private final JBCheckBox myCaseSensitiveCheckBox;
    private final LanguageTextField myPatternStringField;
    private final ColorAndFontDescriptionPanel myColorAndFontDescriptionPanel;
    private final ColorAndFontDescription myColorAndFontDescription;
    private final JBCheckBox myUsedDefaultColorsCheckBox;
    private final int myPatternIndex;
    private final List<TodoPattern> myExistingPatterns;

    PatternDialog(Component parent, TodoPattern pattern, int patternIndex, List<TodoPattern> existingPatterns) {
        super(parent, true);
        Language language;
        this.myPatternIndex = patternIndex;
        this.myExistingPatterns = existingPatterns;
        this.setTitle(IdeBundle.message((String)"title.add.todo.pattern", (Object[])new Object[0]));
        this.setResizable(false);
        TodoAttributes attrs = pattern.getAttributes();
        this.myPattern = pattern;
        this.myIconComboBox = new ComboBox((Object[])new Icon[]{null, AllIcons.General.TodoDefault, AllIcons.General.TodoQuestion, AllIcons.General.TodoImportant});
        this.myIconComboBox.setSelectedItem((Object)attrs.getIcon());
        this.myIconComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setIcon(value);
            label.setText(" ");
        }));
        this.myCaseSensitiveCheckBox = new JBCheckBox(IdeBundle.message((String)"checkbox.case.sensitive", (Object[])new Object[0]), pattern.isCaseSensitive());
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parent));
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName("dummy.regexp");
        if (fileType instanceof LanguageFileType) {
            LanguageFileType languageFileType = (LanguageFileType)fileType;
            language = languageFileType.getLanguage();
        } else {
            language = null;
        }
        Language language2 = language;
        this.myPatternStringField = new LanguageTextField(language2, project, pattern.getPatternString());
        this.myUsedDefaultColorsCheckBox = new JBCheckBox(IdeBundle.message((String)"checkbox.todo.use.default.colors", (Object[])new Object[0]));
        this.myUsedDefaultColorsCheckBox.setSelected(!attrs.shouldUseCustomTodoColor());
        this.myColorAndFontDescriptionPanel = new ColorAndFontDescriptionPanel();
        TextAttributes attributes = this.myPattern.getAttributes().getCustomizedTextAttributes();
        this.myColorAndFontDescription = new TextAttributesDescription(this, "null", null, attributes, null, EditorColorsManager.getInstance().getGlobalScheme(), null, null){

            public boolean isErrorStripeEnabled() {
                return true;
            }

            public boolean isEditable() {
                return true;
            }
        };
        this.myColorAndFontDescriptionPanel.reset((EditorSchemeAttributeDescriptor)this.myColorAndFontDescription);
        this.updateCustomColorsPanel();
        this.myUsedDefaultColorsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternDialog.this.updateCustomColorsPanel();
            }
        });
        this.init();
    }

    private void updateCustomColorsPanel() {
        if (this.useCustomTodoColor()) {
            this.myColorAndFontDescriptionPanel.reset((EditorSchemeAttributeDescriptor)this.myColorAndFontDescription);
        } else {
            this.myColorAndFontDescriptionPanel.resetDefault();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPatternStringField;
    }

    protected void doOKAction() {
        this.myPattern.setPatternString(this.myPatternStringField.getText().trim());
        this.myPattern.setCaseSensitive(this.myCaseSensitiveCheckBox.isSelected());
        TodoAttributes attrs = this.myPattern.getAttributes();
        attrs.setIcon((Icon)this.myIconComboBox.getSelectedItem());
        attrs.setUseCustomTodoColor(this.useCustomTodoColor(), TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
        if (this.useCustomTodoColor()) {
            this.myColorAndFontDescriptionPanel.apply((EditorSchemeAttributeDescriptor)this.myColorAndFontDescription, null);
        }
        super.doOKAction();
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        String patternString = this.myPatternStringField.getText().trim();
        if (patternString.isEmpty()) {
            List<ValidationInfo> list = Collections.singletonList(new ValidationInfo(IdeBundle.message((String)"error.pattern.should.be.specified", (Object[])new Object[0]), (JComponent)this.myPatternStringField));
            if (list == null) {
                PatternDialog.$$$reportNull$$$0(0);
            }
            return list;
        }
        for (int i = 0; i < this.myExistingPatterns.size(); ++i) {
            TodoPattern pattern = this.myExistingPatterns.get(i);
            if (this.myPatternIndex == i || !patternString.equals(pattern.getPatternString())) continue;
            List<ValidationInfo> list = Collections.singletonList(new ValidationInfo(IdeBundle.message((String)"error.same.pattern.already.exists", (Object[])new Object[0]), (JComponent)this.myPatternStringField));
            if (list == null) {
                PatternDialog.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = super.doValidateAll();
        if (list == null) {
            PatternDialog.$$$reportNull$$$0(2);
        }
        return list;
    }

    private boolean useCustomTodoColor() {
        return !this.myUsedDefaultColorsCheckBox.isSelected();
    }

    protected JComponent createCenterPanel() {
        return FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message((String)"label.todo.pattern", (Object[])new Object[0]), (JComponent)this.myPatternStringField).addLabeledComponent(IdeBundle.message((String)"label.todo.icon", (Object[])new Object[0]), this.myIconComboBox).addComponent((JComponent)this.myCaseSensitiveCheckBox).addComponent((JComponent)this.myUsedDefaultColorsCheckBox).addComponent((JComponent)this.myColorAndFontDescriptionPanel).getPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/configurable/PatternDialog", "doValidateAll"));
    }
}

